/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.test.util.Activator;
import org.eclipse.jst.jsf.test.util.ZipStreamWrapper;
import org.eclipse.wst.validation.ValidationFramework;
import org.osgi.framework.Bundle;

public class TestUtil {
    private static final boolean PROJECT_IS_OPEN = true;

    public static IProject createProjectFromZip(Bundle bundle, String prjname, String path) throws Exception {
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        Assert.assertNotNull((Object)url);
        return TestUtil.createProjectFromZip(prjname, url);
    }

    public static IProject createProjectFromZip(File file, String prjname) throws Exception {
        URL url = file.toURL();
        Assert.assertNotNull((Object)url);
        return TestUtil.createProjectFromZip(prjname, url);
    }

    public static void buildProject(IProject project, IProgressMonitor monitor) {
        try {
            project.build(6, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace(System.err);
        }
    }

    private static void expandZip(URL url, IContainer dir) throws Exception {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(url.openStream());
            String prefix = TestUtil.getPrefix(zis);
            zis = new ZipInputStream(url.openStream());
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String name = ze.getName();
                if (!name.startsWith(prefix)) {
                    ze = zis.getNextEntry();
                    continue;
                }
                name = name.substring(prefix.length());
                if (ze.isDirectory()) {
                    IFolder folder = dir.getFolder((IPath)new Path(name));
                    if (!folder.exists()) {
                        TestUtil.ensurePath((IResource)folder);
                        folder.create(true, true, null);
                    }
                } else {
                    IFile file = dir.getFile((IPath)new Path(name));
                    TestUtil.ensurePath((IResource)file);
                    if (file.exists()) {
                        file.setContents((InputStream)new ZipStreamWrapper(zis), 0, null);
                    } else {
                        file.create((InputStream)new ZipStreamWrapper(zis), true, null);
                    }
                }
                ze = zis.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (zis != null) {
                zis.close();
            }
        }
        catch (Exception exception) {}
    }

    private static String getPrefix(ZipInputStream zipStream) throws IOException {
        ZipEntry ze = zipStream.getNextEntry();
        while (ze != null) {
            String name = ze.getName();
            if (name != null && name.endsWith(".project") && !ze.isDirectory()) {
                int index = name.lastIndexOf(".project");
                return name.substring(0, index);
            }
            ze = zipStream.getNextEntry();
        }
        return "";
    }

    private static void ensurePath(IResource file) throws CoreException {
        IContainer container = file.getParent();
        if (!container.exists()) {
            TestUtil.ensurePath((IResource)container);
            ((IFolder)container).create(true, true, null);
        }
    }

    public static IFile copyFile(Bundle bundle, IProject project, String targetPath, String sourcePath) throws Exception {
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(sourcePath), null);
        InputStream stream = url.openStream();
        IFile file = null;
        Path path = new Path(sourcePath);
        if (targetPath != null && targetPath.length() > 0) {
            IFolder folder = project.getFolder(targetPath);
            file = folder.getFile(path.lastSegment());
        } else {
            file = project.getFile(path.lastSegment());
        }
        if (!file.exists()) {
            TestUtil.ensurePath((IResource)file);
            file.create(stream, true, null);
        } else {
            file.setContents(stream, 1, null);
        }
        return file;
    }

    public static IFile createFile(IProject project, String filePath, String content) throws Exception {
        IFile file = project.getFile(filePath);
        TestUtil.ensurePath((IResource)file);
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)stream, true, null);
        return file;
    }

    public static String getFileAsString(String path) throws Exception {
        int count;
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(path), null);
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer buffer = new StringBuffer();
        char[] temp = new char[256];
        while ((count = reader.read(temp)) > 0) {
            buffer.append(temp, 0, count);
        }
        reader.close();
        stream.close();
        return buffer.toString();
    }

    private static IProject createProjectFromZip(final String prjname, final URL url) throws Exception {
        final IProject[] holder = new IProject[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjname);
                if (!prj.exists()) {
                    prj.create(null);
                }
                prj.open(null);
                ValidationFramework.getDefault().suspendValidation(prj, true);
                try {
                    TestUtil.expandZip(url, (IContainer)prj);
                }
                catch (Exception ex) {
                    throw new CoreException((IStatus)new Status(0, "org.eclipse.jst.jsf.test.util", 0, ex.getMessage(), (Throwable)ex));
                }
                holder[0] = prj;
            }
        };
        ResourcesPlugin.getWorkspace().run(r, null);
        return holder[0];
    }

    public static String removeAllWhitespace(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        int i = 0;
        int length = s.length();
        while (i < length) {
            if (!Character.isWhitespace(s.charAt(i))) {
                buffer.append(s.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void removeResource(final IResource prj) throws CoreException {
        if (prj instanceof IFile) {
            ((IFile)prj).delete(true, false, null);
            return;
        }
        Job job = new Job("DeleteProject"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    prj.delete(true, monitor);
                }
                catch (CoreException coreException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static boolean verifyProjectStatus(IProject project, boolean isOpenCondition, int waitTimeInMs) {
        return TestUtil.waitForCondition(TestUtil.createProjectStatusCondition(project, isOpenCondition), waitTimeInMs, 20);
    }

    public static TestCondition createProjectStatusCondition(final IProject project, final boolean isOpenCondition) {
        return new TestCondition(){

            @Override
            public boolean test() {
                return project.isOpen() == isOpenCondition;
            }
        };
    }

    public static boolean openProject(IProject project, int waitTimeInMs) throws CoreException {
        project.open(null);
        return TestUtil.verifyProjectStatus(project, true, waitTimeInMs);
    }

    public static boolean closeProject(IProject project, int waitTimeInMs) throws CoreException {
        project.close(null);
        return TestUtil.verifyProjectStatus(project, false, waitTimeInMs);
    }

    public static boolean waitForCondition(TestCondition condition, int maxTime, int numIntervals) {
        int curIteration = 0;
        int waitPerInterval = maxTime / numIntervals;
        if (waitPerInterval < 1) {
            Assert.fail((String)"Your wait interval is less than 1");
        }
        do {
            if (condition.test()) {
                return true;
            }
            try {
                Thread.sleep(waitPerInterval);
            }
            catch (InterruptedException interruptedException) {}
        } while (curIteration++ < numIntervals);
        return false;
    }

    public static class CompositeTestCondition
    extends TestCondition {
        protected final List<? extends TestCondition> _conditions;

        public CompositeTestCondition(List<? extends TestCondition> conditions) {
            this._conditions = Collections.unmodifiableList(new ArrayList<TestCondition>(conditions));
        }

        public void dispose() {
        }

        @Override
        public boolean test() {
            boolean isSatisfied = true;
            for (TestCondition testCondition : this._conditions) {
                isSatisfied &= testCondition.test();
            }
            return isSatisfied;
        }
    }

    public static abstract class TestCondition {
        public abstract boolean test();
    }
}

