/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.ParameterSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.DomTestUtils;
import org.eclipse.jst.ws.jaxws.testutils.IWaitCondition;
import org.eclipse.jst.ws.jaxws.testutils.assertions.Assertions;
import org.eclipse.jst.ws.jaxws.testutils.dom.WaitingDomUtil;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestEjb3Project;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;

public class MethodParamsSynchronizationTests
extends TestCase {
    private TestEjb3Project testEjbPrj1;
    private IJavaProject testPrj1;
    private JaxWsWorkspaceResource target;
    private IJavaModel javaModel;
    private IType sei1Type;
    private IWebServiceProject wsPrj1;
    private IServiceEndpointInterface sei1;
    private DomUtil domUtil;
    private DomTestUtils testUtil = new DomTestUtils();
    private static final String sei1ImplName = "com.sap.test.modelsync1.Sei1";

    public void setUp() throws Exception {
        this.domUtil = new WaitingDomUtil();
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.target = new JaxWsWorkspaceResource(this.javaModel){

            public IProjectSelector[] getProjectSelectors() {
                return new IProjectSelector[]{new IProjectSelector(){

                    public boolean approve(IJavaProject prj) {
                        return prj.getElementName().equals(MethodParamsSynchronizationTests.this.testPrj1.getElementName());
                    }
                }};
            }
        };
        this.testEjbPrj1 = new TestEjb3Project("TestProject1");
        this.testPrj1 = JavaCore.create((IProject)this.testEjbPrj1.getProject());
        IPackageFragment modelSync1 = this.testPrj1.findPackageFragmentRoot(this.testEjbPrj1.getProject().getFullPath().append("ejbModule")).createPackageFragment("com.sap.test.modelsync1", false, null);
        JobUtils.waitForJobs();
        MethodParamsSynchronizationTests.assertTrue((boolean)modelSync1.exists());
        this.sei1Type = this.createType(modelSync1, "Sei1.java", "import javax.jws.soap.SOAPBinding;\nimport javax.xml.ws.Holder;\n@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1 {}");
        this.createType(modelSync1, "Class1.java", "public class Class1 {}");
        JobUtils.waitForJobs();
        this.target.load(null);
        MethodParamsSynchronizationTests.assertEquals((String)"One projects were defined but a different number were found in the DOM", (int)1, (int)this.target.getDOM().getWebServiceProjects().size());
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)((IWebServiceProject)this.target.getDOM().getWebServiceProjects().get(0)).getServiceEndpointInterfaces().size());
        this.wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        MethodParamsSynchronizationTests.assertNotNull((Object)this.wsPrj1);
        this.sei1 = this.domUtil.findSeiByImplName(this.wsPrj1, sei1ImplName);
        MethodParamsSynchronizationTests.assertNotNull((Object)this.sei1);
    }

    private IType createType(IPackageFragment pack, String compUnit, String contents) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append("package " + pack.getElementName() + ";\n");
        buf.append("\n");
        buf.append(contents);
        ICompilationUnit cu = pack.createCompilationUnit(compUnit, buf.toString(), false, null);
        return cu.getTypes()[0];
    }

    public void tearDown() throws CoreException {
        this.target.stopSynchronizing();
    }

    public void test_voidMethodWithNoArgsSynched() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod voidNoArgs = this.sei1Type.createMethod("public void voidMethodWithNoArgsNoAnnotation();\n", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(voidNoArgs));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(voidNoArgs));
        MethodParamsSynchronizationTests.assertEquals((int)0, (int)wsMethod.getParameters().size());
    }

    public void test_nonVoidMethodWithNoArgs() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod nonVoidNoArgs = this.sei1Type.createMethod("public Class1 nonVoidMethodWithNoArgs();\n", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(nonVoidNoArgs));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(nonVoidNoArgs));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"return", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((Object)WebParamKind.OUT, (Object)((IWebParam)wsMethod.getParameters().get(0)).getKind());
        MethodParamsSynchronizationTests.assertEquals((String)"QClass1;", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
    }

    public void test_voidMethodWithPrimitiveArg() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodWithPrimitiveArg(int param1);\n", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"arg0", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((Object)WebParamKind.IN, (Object)((IWebParam)wsMethod.getParameters().get(0)).getKind());
        MethodParamsSynchronizationTests.assertEquals((String)"I", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
    }

    public void test_voidMethodWithNonParameterizedHolderParam() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodWithParameterizedHolderParam(Holder param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"arg0", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((String)"QHolder;", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
    }

    public void test_voidMethodWithParameterizedHolderParam() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodWithParameterizedHolderParam(javax.xml.ws.Holder<Class1> param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"arg0", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((String)"Qjavax.xml.ws.Holder<QClass1;>;", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
    }

    public void test_paramNameDefaultSunchronized() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void method1(int param);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((String)"arg0", (String)this.testUtil.findParam(wsMethod, "param").getName());
    }

    public void test_paramNameSunchronized() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public int method2(@javax.jws.WebParam(name=\"param\", header=true) int param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((String)"param", (String)this.testUtil.findParam(wsMethod, "param1").getName());
        MethodParamsSynchronizationTests.assertEquals((String)"return", (String)this.testUtil.findParam(wsMethod, "return").getName());
        IMethod method2 = this.sei1Type.createMethod("@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, parameterStyle=SOAPBinding.ParameterStyle.BARE)\npublic int method3(int param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method2));
        IWebMethod wsMethod2 = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method2));
        MethodParamsSynchronizationTests.assertEquals((String)"method3Response", (String)this.testUtil.findParam(wsMethod2, "return").getName());
        MethodParamsSynchronizationTests.assertEquals((String)"method3", (String)this.testUtil.findParam(wsMethod2, "param1").getName());
    }

    public void test_paramHeaderDefaultSyncromized() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method1 = this.sei1Type.createMethod("public void method2(@javax.jws.WebParam(name=\"param1\") int param1);", null, false, null);
        JobUtils.waitForJobs();
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method1));
        IWebMethod wsMethod1 = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method1));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod1.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"param1", (String)((IWebParam)wsMethod1.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertFalse((boolean)((IWebParam)wsMethod1.getParameters().get(0)).isHeader());
    }

    public void test_paramHeaderFalseSyncromized() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method2 = this.sei1Type.createMethod("public void method2(@javax.jws.WebParam(name=\"param1\", header=false) int param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method2));
        IWebMethod wsMethod2 = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method2));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod2.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"param1", (String)((IWebParam)wsMethod2.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertFalse((boolean)((IWebParam)wsMethod2.getParameters().get(0)).isHeader());
    }

    public void test_paramHeaderTrueSyncromized() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method2 = this.sei1Type.createMethod("public void method2(@javax.jws.WebParam(name=\"param1\", header=true) int param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method2));
        IWebMethod wsMethod2 = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method2));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod2.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((String)"param1", (String)((IWebParam)wsMethod2.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertTrue((boolean)((IWebParam)wsMethod2.getParameters().get(0)).isHeader());
    }

    public void test_paramPartNameDefault() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodExcluded(@javax.jws.WebParam(name=\"paramA\") int a);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((Object)WebParamKind.IN, (Object)((IWebParam)wsMethod.getParameters().get(0)).getKind());
        MethodParamsSynchronizationTests.assertEquals((String)"I", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
        MethodParamsSynchronizationTests.assertEquals((String)"paramA", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((String)"paramA", (String)((IWebParam)wsMethod.getParameters().get(0)).getPartName());
    }

    public void test_paramPartName() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodExcluded(@javax.jws.WebParam(name=\"paramA\", partName=\"partNameA\") int a);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((Object)WebParamKind.IN, (Object)((IWebParam)wsMethod.getParameters().get(0)).getKind());
        MethodParamsSynchronizationTests.assertEquals((String)"I", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
        MethodParamsSynchronizationTests.assertEquals((String)"paramA", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((String)"partNameA", (String)((IWebParam)wsMethod.getParameters().get(0)).getPartName());
    }

    public void test_paramTargetNamespaceDefault() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodExcluded(@javax.jws.WebParam(name=\"paramA\") int a);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((Object)WebParamKind.IN, (Object)((IWebParam)wsMethod.getParameters().get(0)).getKind());
        MethodParamsSynchronizationTests.assertEquals((String)"I", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
        MethodParamsSynchronizationTests.assertEquals((String)"paramA", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((String)"", (String)((IWebParam)wsMethod.getParameters().get(0)).getTargetNamespace());
    }

    public void test_paramTargetNamespaceEmptyNs() throws Exception {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED) public void method3(@javax.jws.WebParam(name=\"param\", header=false) int param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((String)"", (String)((IWebParam)wsMethod.getParameters().get(0)).getTargetNamespace());
        IMethod method2 = this.sei1Type.createMethod("@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)\npublic void method4(@javax.jws.WebParam(name=\"param\", header=true) int param1);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method2));
        IWebMethod wsMethod2 = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method2));
        MethodParamsSynchronizationTests.assertEquals((String)"http://sap.com/test/modelsync1/", (String)((IWebParam)wsMethod2.getParameters().get(0)).getTargetNamespace());
    }

    public void test_paramTargetNamespace() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod method = this.sei1Type.createMethod("public void voidMethodExcluded(@javax.jws.WebParam(name=\"paramA\", targetNamespace=\"http://targetNs/\") int a);", null, false, null);
        this.waitMethodLoadedInDom(this.sei1, this.domUtil.calcImplementation(method));
        IWebMethod wsMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(method));
        MethodParamsSynchronizationTests.assertEquals((int)1, (int)wsMethod.getParameters().size());
        MethodParamsSynchronizationTests.assertEquals((Object)WebParamKind.IN, (Object)((IWebParam)wsMethod.getParameters().get(0)).getKind());
        MethodParamsSynchronizationTests.assertEquals((String)"I", (String)((IWebParam)wsMethod.getParameters().get(0)).getTypeName());
        MethodParamsSynchronizationTests.assertEquals((String)"paramA", (String)((IWebParam)wsMethod.getParameters().get(0)).getName());
        MethodParamsSynchronizationTests.assertEquals((String)"http://targetNs/", (String)((IWebParam)wsMethod.getParameters().get(0)).getTargetNamespace());
    }

    private void waitMethodLoadedInDom(final IServiceEndpointInterface sei, final String implementation) {
        IWaitCondition condition = new IWaitCondition(){

            public boolean checkCondition() {
                return MethodParamsSynchronizationTests.this.domUtil.findWebMethodByImpl(sei, implementation) != null;
            }
        };
        Assertions.waitAssert((IWaitCondition)condition, (String)("Method " + implementation + " not found"));
    }

    public void test_paramTypeResolvedForNonQualifiedHolderType() throws Exception {
        ParameterSynchronizerForParamTypesTests syncronizer = new ParameterSynchronizerForParamTypesTests(null);
        syncronizer.calcKind(null, null, "QHolder;");
        MethodParamsSynchronizationTests.assertTrue((String)"resolveFullyQualifiedName should be called for non qualified Holder type", (boolean)syncronizer.called);
    }

    public void test_paramTypeResolvedForQualifiedHolderType() throws Exception {
        ParameterSynchronizerForParamTypesTests syncronizer = new ParameterSynchronizerForParamTypesTests(null);
        syncronizer.calcKind(null, null, "Qjavax.xml.ws.Holder<QClass1;>;");
        MethodParamsSynchronizationTests.assertTrue((String)"resolveFullyQualifiedName should be called for qualified Holder type", (boolean)syncronizer.called);
    }

    public void test_paramTypeNotResolvedForNonHolderType() throws Exception {
        ParameterSynchronizerForParamTypesTests syncronizer = new ParameterSynchronizerForParamTypesTests(null);
        syncronizer.calcKind(null, null, "QString;");
        MethodParamsSynchronizationTests.assertFalse((String)"resolveFullyQualifiedName should not be called for non Holder type", (boolean)syncronizer.called);
    }

    private class ParameterSynchronizerForParamTypesTests
    extends ParameterSynchronizer {
        public boolean called;

        public ParameterSynchronizerForParamTypesTests(IModelElementSynchronizer parent) {
            super(parent);
            this.called = false;
        }

        protected WebParamKind calcKind(IAnnotation<ITypeParameter> parmAnnotation, IMethod method, String typeSignature) throws JavaModelException, IllegalArgumentException {
            return super.calcKind(parmAnnotation, method, typeSignature);
        }

        protected String resolveFullyQualifiedName(IMethod method, String typeSignature) {
            this.called = true;
            return "";
        }
    }
}

