/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.uriresolver.tests;

import junit.framework.TestCase;
import org.eclipse.wst.common.uriresolver.internal.ExtensibleURIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.tests.util.AuxiliaryCounter;

public class ExtensibleURIResolverTest
extends TestCase {
    public void testExtensibleURIResolver() {
        URIResolver resolver = URIResolverPlugin.createResolver();
        if (resolver instanceof ExtensibleURIResolver) {
            ExtensibleURIResolver extensibleURIResolver = (ExtensibleURIResolver)resolver;
            AuxiliaryCounter.getInstance().resetCounter();
            String publicResolve = extensibleURIResolver.resolve(null, "http://www.public.org", null);
            ExtensibleURIResolverTest.assertEquals((String)"/folder/public.extension", (String)publicResolve);
            String systemResolve = extensibleURIResolver.resolve(null, null, "http://www.system.org");
            ExtensibleURIResolverTest.assertEquals((String)"/folder/system.extension", (String)systemResolve);
            int count = AuxiliaryCounter.getInstance().getCount();
            ExtensibleURIResolverTest.assertEquals((int)2, (int)count);
        }
    }
}

