/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema.catalog;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.internal.schema.catalog.CommonXML;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EntryParser {
    public static final String JSON_CATALOG_ENTRIES = "catalogEntries";

    public Set<UserEntry> parse(String xml) throws CoreException {
        if (xml == null || xml.trim().isEmpty()) {
            return null;
        }
        HashSet<UserEntry> list = new HashSet<UserEntry>();
        try {
            Document parsed = CommonXML.getDocumentBuilder(false).parse(new InputSource(new StringReader(xml)));
            NodeList entryElements = parsed.getElementsByTagName("entry");
            int i = 0;
            while (i < entryElements.getLength()) {
                Element el = (Element)entryElements.item(i);
                UserEntry entry = new UserEntry();
                entry.setFileMatch(el.getAttribute("fileMatch"));
                entry.setUrl(new URI(el.getAttribute("url")));
                list.add(entry);
                ++i;
            }
            return list;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.json.core", "Unable to parse entry", (Throwable)e));
        }
    }

    public String serialize(Set<UserEntry> entries) throws CoreException {
        try {
            Document document = CommonXML.getDocumentBuilder(false).newDocument();
            Element entriesElement = document.createElement("entries");
            document.appendChild(entriesElement);
            for (UserEntry userEntry : entries) {
                Element entryElement = document.createElement("entry");
                entriesElement.appendChild(entryElement);
                entryElement.setAttribute("fileMatch", userEntry.getFileMatch());
                entryElement.setAttribute("url", userEntry.getUrl().toString());
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            CommonXML.serialize(document, bytes);
            return new String(bytes.toByteArray(), "utf8");
        }
        catch (Exception shouldntHappen) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.json.core", "Unable to serialize entries ", (Throwable)shouldntHappen));
        }
    }

    public static Set<UserEntry> getUserEntries() {
        LinkedHashSet<UserEntry> entries = new LinkedHashSet<UserEntry>();
        IEclipsePreferences prefs = EntryParser.getPreferences();
        String xml = prefs.get(JSON_CATALOG_ENTRIES, null);
        if (xml != null && !xml.trim().isEmpty()) {
            try {
                Set<UserEntry> set = new EntryParser().parse(xml);
                if (set != null) {
                    entries.addAll(set);
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.wst.json.core", e.getLocalizedMessage(), (Throwable)e);
                JSONCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return entries;
    }

    private static IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.wst.json.ui");
        return preferences;
    }
}

