/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.MasterIndex;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.SerializableTLDNamespace;

class TagRepository {
    private static final Object GLOBAL_MASTER_INDEX_LOCK = new Object();
    private static MasterIndex GLOBAL_MASTER_INDEX;
    private static final String PATH_TO_REPOSITORY = "/.jsptagregistry";
    private static final String MASTER_INDEX_FILE_NAME = "tagRegistryMasterIndex.idx";
    private final IProject _project;

    public TagRepository(IProject project) {
        this._project = project;
    }

    public Map<String, SerializableTLDNamespace> load() throws IOException, ClassNotFoundException {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log("Loading tag repository for: " + this._project.toString());
        }
        MasterIndex index = this.getOrCreateMasterIndex();
        MasterIndex.ProjectIndex projIndex = index.getProjectIndex(this._project);
        Map<String, SerializableTLDNamespace> namespaces = projIndex.getNamespaces();
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log("Contents of repo for: " + this._project.toString());
            for (Map.Entry<String, SerializableTLDNamespace> nsEntry : namespaces.entrySet()) {
                JSFCoreTraceOptions.log("\tNamespace: " + nsEntry.getKey());
                SerializableTLDNamespace ns = nsEntry.getValue();
                for (ITagElement iTagElement : ns.getViewElements()) {
                    JSFCoreTraceOptions.log("\t\tTag: " + iTagElement.toString());
                }
            }
        }
        return namespaces;
    }

    public void save(Map<String, SerializableTLDNamespace> namespaces) throws IOException, ClassNotFoundException {
        MasterIndex index = this.getOrCreateMasterIndex();
        MasterIndex.ProjectIndex projectIndex = index.getProjectIndex(this._project);
        projectIndex.save(namespaces);
    }

    public void clearAll() throws IOException, ClassNotFoundException {
        MasterIndex index = this.getOrCreateMasterIndex();
        index.removeProjectIndex(this._project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterIndex getOrCreateMasterIndex() throws IOException, ClassNotFoundException {
        IPath wkspacePath = JSFCorePlugin.getDefault().getStateLocation();
        IPath repoPath = wkspacePath.append(PATH_TO_REPOSITORY);
        File repoDir = new File(repoPath.toOSString());
        Object object = GLOBAL_MASTER_INDEX_LOCK;
        synchronized (object) {
            if (GLOBAL_MASTER_INDEX != null) {
                if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                    JSFCoreTraceOptions.log("GLOBAL_MASTER_INDEX already exists for: " + this._project.toString());
                }
                return GLOBAL_MASTER_INDEX;
            }
            if (!repoDir.exists()) {
                TagRepository.createNewRepo(repoDir);
            }
            File masterIndexFile = new File(new Path(repoDir.getAbsolutePath()).append(MASTER_INDEX_FILE_NAME).toOSString());
            MasterIndex index = new MasterIndex(masterIndexFile, repoDir.getAbsolutePath());
            if (!masterIndexFile.exists()) {
                if (!masterIndexFile.createNewFile()) {
                    throw new IOException("Could not create new master index file: " + masterIndexFile.toString());
                }
                if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                    JSFCoreTraceOptions.log("Creating master index file for " + this._project.toString());
                }
                index.create(new MasterIndex.SerializableVersion(1, 0, 0));
            } else {
                if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                    JSFCoreTraceOptions.log("Loading master index file for " + this._project.toString());
                }
                index.load(new MasterIndex.SerializableVersion(1, 0, 0));
            }
            GLOBAL_MASTER_INDEX = index;
            return index;
        }
    }

    private static void createNewRepo(File repoDir) throws IOException {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log("Creating repo directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.mkdir()) {
            throw new IOException("Failed to create repo directory: " + repoDir.getAbsolutePath());
        }
    }
}

