/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.FaceletRegistryManager;
import org.eclipse.jst.jsf.facelet.ui.internal.FaceletUiPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XHTMLContentAssistProcessor2
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<Object> proposals = new ArrayList();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(viewer, offset);
        if (context != null) {
            IDOMContextResolver domContextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
            Document doc = domContextResolver.getDOMDocument();
            if (doc == null) {
                return NO_PROPOSALS;
            }
            Map<String, PrefixEntry> documentNamespaces = this.getDocumentNamespaces(doc);
            ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
            if (resolver != null) {
                String regionType = resolver.getRegionType();
                if ("XML_CONTENT".equals(regionType)) {
                    proposals = this.getTagCompletionsForDocument(context, documentNamespaces, TagPrefix.NO_PREFIX);
                } else if ("XML_TAG_NAME".equals(regionType)) {
                    TagPrefix tagPrefix = new TagPrefix(resolver.getRegionText());
                    proposals = this.getTagCompletionsForDocument(context, documentNamespaces, tagPrefix);
                } else {
                    System.out.println(regionType);
                }
            }
        }
        return proposals.toArray(NO_PROPOSALS);
    }

    private List<ICompletionProposal> getTagCompletionsForDocument(IStructuredDocumentContext context, Map<String, PrefixEntry> namespaces, TagPrefix tagPrefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IWorkspaceContextResolver wkspaceResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        IProject project = wkspaceResolver.getProject();
        FaceletRegistryManager.MyRegistryFactory factory = new FaceletRegistryManager.MyRegistryFactory();
        try {
            ITagRegistry registry = factory.createTagRegistry(project);
            if (registry == null) {
                return proposals;
            }
            Collection tagLibs = registry.getAllTagLibraries();
            for (Namespace tagLib : tagLibs) {
                PrefixEntry ns = namespaces.get(tagLib.getNSUri());
                if (ns == null || !tagLib.isInitialized() || !ns._prefix.startsWith(tagPrefix.getPrefix())) continue;
                Collection tags = tagLib.getViewElements();
                for (ITagElement tagElement : tags) {
                    if (!tagElement.getName().startsWith(tagPrefix.getLocalName())) continue;
                    String userPrefix = tagPrefix.getUserPrefix();
                    String tagName = String.valueOf(ns._prefix) + ":" + tagElement.getName();
                    String replacementText = "";
                    replacementText = "".equals(userPrefix) ? "<" + tagName + "></" + tagName + ">" : tagName.substring(userPrefix.length());
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementText, context.getDocumentPosition(), 0, 0, null, tagName, null, null));
                }
            }
        }
        catch (TagRegistryFactory.TagRegistryFactoryException e) {
            FaceletUiPlugin.log(e);
        }
        return proposals;
    }

    private Map<String, PrefixEntry> getDocumentNamespaces(Document doc) {
        HashMap<String, PrefixEntry> namespaces = new HashMap<String, PrefixEntry>();
        Element rootElement = doc.getDocumentElement();
        if (rootElement != null) {
            NamedNodeMap attrs = rootElement.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Attr a = (Attr)attrs.item(i);
                PrefixEntry ns = PrefixEntry.parseNamespace(a);
                if (ns != null) {
                    namespaces.put(ns.getUri(), ns);
                }
                ++i;
            }
        }
        return namespaces;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private static class PrefixEntry {
        private final String _uri;
        private final String _prefix;

        public static PrefixEntry parseNamespace(Attr attr) {
            String uri;
            String prefixName;
            String prefix = attr.getPrefix();
            if ("xmlns".equals(prefix) && (prefixName = attr.getLocalName()) != null && (uri = attr.getNodeValue()) != null) {
                return new PrefixEntry(uri, prefixName);
            }
            return null;
        }

        public PrefixEntry(String uri, String prefix) {
            this._uri = uri;
            this._prefix = prefix;
        }

        public final String getUri() {
            return this._uri;
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object obj) {
            return this._uri.equals(obj);
        }
    }

    private static class TagPrefix {
        public static final TagPrefix NO_PREFIX = new TagPrefix("");
        private final String _prefix;
        private final String _localName;
        private final boolean _hasColon;

        public TagPrefix(String tagName) {
            int prefixIdx = tagName.indexOf(58);
            if (prefixIdx != -1) {
                this._prefix = tagName.substring(0, prefixIdx);
                this._hasColon = true;
                this._localName = tagName.length() > prefixIdx ? tagName.substring(prefixIdx + 1) : "";
            } else {
                this._hasColon = false;
                this._prefix = tagName;
                this._localName = "";
            }
        }

        public String getUserPrefix() {
            String userPrefix = this._prefix;
            if (this._hasColon) {
                userPrefix = String.valueOf(userPrefix) + ":";
                userPrefix = String.valueOf(userPrefix) + this._localName;
            }
            return userPrefix;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public String getLocalName() {
            return this._localName;
        }
    }
}

