/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.editor;

import java.util.HashSet;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.SelectionConverter;

public class JSONSelectionConverterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_LIST = new Class[]{SelectionConverter.class};
    private static final Object selectionConverter = new JSONSelectionConverter();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Object adapter = null;
        if (adaptableObject instanceof IJSONModel && SelectionConverter.class.equals((Object)adapterType)) {
            adapter = selectionConverter;
        }
        return adapter;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static int beginingWhitespaceLength(String s) {
        int length = 0;
        int i = 0;
        while (i < s.length() && length == 0) {
            if (!Character.isWhitespace(s.charAt(i))) {
                length = i;
            }
            ++i;
        }
        return length;
    }

    private static class JSONSelectionConverter
    extends SelectionConverter {
        public Object[] getElements(IStructuredModel model, int start, int end) {
            Object[] localSelectedStructures = null;
            if (model != null) {
                IndexedRegion region = model.getIndexedRegion(start);
                if (region instanceof IJSONObject || region instanceof IJSONDocument) {
                    try {
                        String selection = model.getStructuredDocument().get(start, end);
                        int whitespaceLength = JSONSelectionConverterFactory.beginingWhitespaceLength(selection);
                        region = model.getIndexedRegion(start + whitespaceLength + 1);
                    }
                    catch (BadLocationException e) {
                        Logger.logException("Bad location on selection, this should never happen", e);
                    }
                }
                if (region != null) {
                    if (end <= region.getEndOffset()) {
                        localSelectedStructures = new Object[]{region};
                    } else {
                        int maxLength = model.getStructuredDocument().getLength();
                        HashSet<IndexedRegion> structures = new HashSet<IndexedRegion>();
                        while (region != null && region.getEndOffset() <= end && region.getEndOffset() <= maxLength && !structures.contains(region)) {
                            IJSONNode node;
                            structures.add(region);
                            boolean foundNextSibling = false;
                            if (region instanceof IJSONNode && (node = ((IJSONNode)region).getNextSibling()) instanceof IndexedRegion) {
                                region = node;
                                foundNextSibling = true;
                            }
                            if (foundNextSibling) continue;
                            region = model.getIndexedRegion(region.getEndOffset() + 1);
                        }
                        localSelectedStructures = structures.toArray();
                    }
                }
            }
            if (localSelectedStructures == null) {
                localSelectedStructures = new Object[]{};
            }
            return localSelectedStructures;
        }
    }
}

