/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.AbstractEJBValidator;
import org.eclipse.jst.j2ee.model.internal.validation.EJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.EJBValidationRuleFactory;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class EJBValidator
extends AbstractEJBValidator {
    private static EJBValidator _inst = null;
    private static AbstractEJBValidator.TargetObjectPool _targetObjectPoolSingleton = null;
    private LogEntry logEntry = null;

    public EJBValidator() {
        _inst = this;
    }

    public static EJBValidator getValidator() {
        return _inst;
    }

    private LogEntry getLogEntry() {
        if (this.logEntry == null) {
            this.logEntry = new LogEntry("ejbvalidator");
        }
        return this.logEntry;
    }

    @Override
    public String getBaseName() {
        return "ejbvalidator";
    }

    public void commonValidate(IValidationContext helper, IReporter reporter) throws ValidationException {
        long start = System.currentTimeMillis();
        Logger logger = Logger.getLogger((String)"org.eclipse.jst.j2ee.internal.core");
        if (logger != null && logger.isLoggingLevel(Level.FINER)) {
            long end = System.currentTimeMillis();
            LogEntry entry = this.getLogEntry();
            entry.setSourceID("EJBValidator::validate");
            entry.setText("validate took " + (end - start) + " milliseconds.");
            logger.write(Level.FINER, (Object)entry);
        }
        EJBValidationContext vc = new EJBValidationContext((IValidator)this, helper, reporter);
        this.setValidationContext(vc);
        if (this.isFullValidate(vc)) {
            this.fullValidate(vc);
        } else {
            this.incrementalValidate(vc);
        }
        if (logger != null && logger.isLoggingLevel(Level.FINER)) {
            long end = System.currentTimeMillis();
            LogEntry entry = this.getLogEntry();
            entry.setSourceID("EJBValidator::validate");
            entry.setText("validate took " + (end - start) + " milliseconds.");
            logger.write(Level.FINER, (Object)entry);
        }
    }

    @Override
    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.commonValidate(helper, reporter);
    }

    @Override
    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.commonValidate(helper, reporter);
        return this.status;
    }

    public boolean isFullValidate(IEJBValidationContext vc) {
        String[] fileURIs = vc.getURIs();
        if (fileURIs == null) {
            return true;
        }
        if (fileURIs.length == 0) {
            return true;
        }
        int i = 0;
        while (i < fileURIs.length) {
            String uri = fileURIs[i];
            if (uri.endsWith("ejb-jar.xml")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void runDependents(IEJBValidationContext vc, IValidationRule rule, Object targetParent, Object target) throws ValidationException {
        Set dependents = rule.getDependents();
        if (dependents == null) {
            return;
        }
        Iterator iterator = dependents.iterator();
        while (iterator.hasNext()) {
            try {
                try {
                    IValidationRule dRule = (IValidationRule)iterator.next();
                    Object dRuleTarget = dRule.getTarget(targetParent, target);
                    if (dRuleTarget != null) {
                        this.run(dRule, targetParent, dRuleTarget);
                    }
                }
                catch (ValidationCancelledException e) {
                    throw e;
                }
                catch (ValidationException e) {
                    throw e;
                }
                catch (Throwable exc) {
                    this.addInternalErrorMessage(this.getValidationContext(), exc);
                    EJBValidationRuleFactory.getFactory().release(rule);
                    continue;
                }
            }
            catch (Throwable throwable) {
                EJBValidationRuleFactory.getFactory().release(rule);
                throw throwable;
            }
            EJBValidationRuleFactory.getFactory().release(rule);
        }
    }

    protected String internalErrorMessage() {
        return "CHKJ2900";
    }

    @Override
    protected void logMissingRule(IEJBValidationContext vc, Object ruleId) {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, ruleId + " = null");
        }
        this.addInternalErrorMessage(vc);
    }

    @Override
    protected void preRemoveOldMessages(IEJBValidationContext vc, Map targets) throws ValidationException {
        ArrayList<JavaClass> validatedClasses = new ArrayList<JavaClass>();
        try {
            String[] uris = vc.getURIs();
            int i = 0;
            while (i < uris.length) {
                String uriInst = uris[i];
                if (uriInst != null && uriInst.length() != 0) {
                    Object id = EJBValidationRuleFactory.getFactory().getRuleId(vc, uriInst);
                    if (id == null) {
                        Object[] clazzAndBean = (Object[])vc.loadModel(uriInst, null);
                        if (clazzAndBean == null) {
                            this.logMissingRule(vc, id);
                        } else {
                            JavaClass clazz = (JavaClass)clazzAndBean[0];
                            List beans = (List)clazzAndBean[1];
                            validatedClasses.add(clazz);
                            if (beans != null && beans.size() != 0) {
                                for (EnterpriseBean bean : beans) {
                                    id = EJBValidationRuleFactory.getFactory().getRuleId(vc, clazz, bean);
                                    IValidationRule clazzRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                                    if (clazzRule == null) continue;
                                    this.setValidated(clazzRule.getId(), bean, clazz);
                                }
                            }
                        }
                    } else {
                        IValidationRule ejbExtRule;
                        EJBJar ejbJar = (EJBJar)vc.loadModel("EJB_MODEL");
                        if (ejbJar != null && (ejbExtRule = EJBValidationRuleFactory.getFactory().getRule(vc, id)) != null) {
                            this.setValidated(ejbExtRule.getId(), null, ejbJar);
                        }
                    }
                }
                ++i;
            }
            EJBJar ejbJar = (EJBJar)vc.loadModel("EJB_MODEL");
            if (ejbJar != null) {
                Object id = EJBValidationRuleFactory.getFactory().getRuleId(vc, "ejb-jar.xml");
                if (id == null) {
                    this.logMissingRule(vc, id);
                } else {
                    IValidationRule ejbJarRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                    if (ejbJarRule == null) {
                        this.logMissingRule(vc, id);
                    } else {
                        this.setValidated(ejbJarRule.getId(), null, ejbJar);
                    }
                }
            }
            if (validatedClasses.size() > 0) {
                int vC = 0;
                while (vC < validatedClasses.size()) {
                    List beans = (List)vc.loadModel("EJB", new Object[]{validatedClasses.get(vC)});
                    if (beans != null && beans.size() != 0) {
                        HashSet rootValidatedClass = new HashSet();
                        rootValidatedClass.add(validatedClasses.get(vC));
                        JavaClass[] children = (JavaClass[])vc.loadModel("children", new Object[]{vc.getReporter(), rootValidatedClass});
                        if (children != null && children.length > 0) {
                            Iterator bciterator = null;
                            Object id = null;
                            int c = 0;
                            while (c < children.length) {
                                JavaClass child = children[c];
                                beans = (List)vc.loadModel("EJB", new Object[]{child});
                                if (beans != null && beans.size() != 0) {
                                    for (EnterpriseBean bean : beans) {
                                        id = EJBValidationRuleFactory.getFactory().getRuleId(vc, child, bean);
                                        IValidationRule clazzRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                                        if (clazzRule == null) continue;
                                        this.setValidated(clazzRule.getId(), bean, child);
                                    }
                                }
                                ++c;
                            }
                        }
                    }
                    ++vC;
                }
                validatedClasses.clear();
            }
            targets.putAll(this._validated);
            for (Object id : targets.keySet()) {
                Set contexts;
                IValidationRule rule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                if (rule == null || (contexts = (Set)targets.get(id)) == null) continue;
                for (AbstractEJBValidator.TargetObject to : contexts) {
                    Object targetParent = to.getTargetParent();
                    Object target = to.getTarget();
                    Set dependents = rule.getDependents();
                    if (dependents == null) continue;
                    Iterator dIterator = dependents.iterator();
                    while (dIterator.hasNext()) {
                        try {
                            try {
                                IValidationRule dRule = (IValidationRule)dIterator.next();
                                Object dRuleTarget = dRule.getTarget(targetParent, target);
                                if (dRuleTarget != null) {
                                    this.setValidated(dRule.getId(), targetParent, dRuleTarget);
                                }
                            }
                            catch (ValidationCancelledException e) {
                                throw e;
                            }
                            catch (Throwable exc) {
                                this.addInternalErrorMessage(this.getValidationContext(), exc);
                                EJBValidationRuleFactory.getFactory().release(rule);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            EJBValidationRuleFactory.getFactory().release(rule);
                            throw throwable;
                        }
                        EJBValidationRuleFactory.getFactory().release(rule);
                    }
                }
            }
        }
        finally {
            targets.clear();
            validatedClasses.clear();
            targets.putAll(this._validated);
            this._validated.clear();
        }
    }

    @Override
    protected String removeOldMessagesString() {
        return "REMOVE_OLD_MESSAGES";
    }

    public void fullValidate(IEJBValidationContext vc) throws ValidationException {
        this.removeOldMessages(vc, null);
        EJBJar ejbJar = (EJBJar)vc.loadModel("EJB_MODEL");
        if (ejbJar == null) {
            IMessage mssg = vc.getMessage();
            mssg.setId("CHKJ2905");
            vc.addMessage(mssg);
            return;
        }
        Object id = EJBValidationRuleFactory.getFactory().getRuleId(vc, "ejb-jar.xml");
        if (id == null) {
            this.logMissingRule(vc, "ejb-jar.xml");
            return;
        }
        IValidationRule ejbJarRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
        if (ejbJarRule == null) {
            this.logMissingRule(vc, id);
            return;
        }
        this.run(ejbJarRule, null, ejbJar);
        EList beans = ejbJar.getEnterpriseBeans();
        Iterator iterator = beans.iterator();
        id = null;
        while (iterator.hasNext()) {
            EnterpriseBean bean = (EnterpriseBean)iterator.next();
            JavaClass[] classes = this.getJavaClass(bean);
            int i = 0;
            while (i < classes.length) {
                JavaClass clazz = classes[i];
                id = EJBValidationRuleFactory.getFactory().getRuleId(vc, clazz, bean);
                IValidationRule clazzRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                if (clazzRule != null) {
                    this.run(clazzRule, bean, clazz);
                }
                ++i;
            }
        }
    }

    protected JavaClass[] getJavaClass(EnterpriseBean bean) {
        JavaClass key;
        JavaClass localHomeClass;
        JavaClass homeClass;
        JavaClass localClass;
        JavaClass remoteClass;
        int count = 0;
        JavaClass[] classes = new JavaClass[6];
        JavaClass ejbClass = bean.getEjbClass();
        if (ejbClass != null && ejbClass.isExistingType()) {
            classes[count++] = ejbClass;
        }
        if ((remoteClass = bean.getRemoteInterface()) != null && remoteClass.isExistingType()) {
            classes[count++] = remoteClass;
        }
        if ((localClass = bean.getLocalInterface()) != null && localClass.isExistingType()) {
            classes[count++] = localClass;
        }
        if ((homeClass = bean.getHomeInterface()) != null && homeClass.isExistingType()) {
            classes[count++] = homeClass;
        }
        if ((localHomeClass = bean.getLocalHomeInterface()) != null && localHomeClass.isExistingType()) {
            classes[count++] = localHomeClass;
        }
        if (bean instanceof Entity && (key = ((Entity)bean).getPrimaryKey()) != null && key.isExistingType()) {
            classes[count++] = key;
        }
        if (count == 6) {
            return classes;
        }
        JavaClass[] result = new JavaClass[count];
        System.arraycopy(classes, 0, result, 0, count);
        return result;
    }

    public void incrementalValidate(IEJBValidationContext vc) throws ValidationException {
        HashMap targets = new HashMap();
        try {
            this.removeOldMessages(vc, targets);
            for (Object id : targets.keySet()) {
                Set contexts;
                IValidationRule rule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                if (rule == null || (contexts = (Set)targets.get(id)) == null) continue;
                for (AbstractEJBValidator.TargetObject to : contexts) {
                    this.run(rule, to.getTargetParent(), to.getTarget());
                }
            }
        }
        finally {
            targets.clear();
            targets = null;
        }
    }

    @Override
    protected AbstractEJBValidator.TargetObjectPool getTargetObjectPool() {
        if (_targetObjectPoolSingleton == null) {
            _targetObjectPoolSingleton = new AbstractEJBValidator.TargetObjectPool(this, 100);
        }
        return _targetObjectPoolSingleton;
    }

    @Override
    protected void releaseRules(IValidationRule rule) {
        EJBValidationRuleFactory.getFactory().release(rule);
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    @Override
    public void cleanup(IReporter reporter) {
        EJBValidationRuleFactory.getFactory().clearRuleMap(reporter);
    }

    @Override
    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        HashMap helperMap = ValidationRuleUtility.getHelperMap(project);
        helperMap.clear();
        ValidationRuleUtility.projectHelperMap.remove(helperMap);
        helperMap = null;
        super.validationFinishing(project, state, monitor);
    }
}

