/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;

public final class T7A
extends AbstractValidator {
    private static List<ValEntryPoint> _list = new LinkedList<ValEntryPoint>();

    public static void resetList() {
        _list.clear();
    }

    public static List<ValEntryPoint> getList() {
        return _list;
    }

    public static ValEntryPoint[] getArray() {
        ValEntryPoint[] array = new ValEntryPoint[_list.size()];
        _list.toArray(array);
        return array;
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        _list.add(new ValEntryPoint(EntryType.Starting, (IResource)project));
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        _list.add(new ValEntryPoint(EntryType.Finishing, (IResource)project));
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        _list.add(new ValEntryPoint(EntryType.Normal, resource));
        return null;
    }

    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
        _list.add(new ValEntryPoint(EntryType.Clean, (IResource)project));
    }

    public static enum EntryType {
        Starting,
        Normal,
        Finishing,
        Clean;

    }

    public static final class ValEntryPoint {
        private final EntryType _type;
        private final IResource _resource;

        public ValEntryPoint(EntryType type, IResource resource) {
            this._type = type;
            this._resource = resource;
        }

        public String toString() {
            String resource = this._resource == null ? "null" : this._resource.getName();
            return "ValEntryPoint: " + (Object)((Object)this._type) + " " + resource;
        }

        public EntryType getType() {
            return this._type;
        }

        public IResource getResource() {
            return this._resource;
        }
    }
}

