/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.util;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CreateTestCaseForJSP
extends TestCase {
    private static final String jspFile = "preferenceTest1";
    private static IFile file;
    private static IStructuredModel model;
    private WebProjectTestEnvironment _testEnv;

    protected void setUp() throws Exception {
        super.setUp();
        this._testEnv = new WebProjectTestEnvironment("ELValidationTest_" + this.getName());
        this._testEnv.createProject(false);
        CreateTestCaseForJSP.assertNotNull((Object)this._testEnv);
        CreateTestCaseForJSP.assertNotNull((Object)this._testEnv.getTestProject());
        CreateTestCaseForJSP.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        file = (IFile)this._testEnv.loadResourceInWebRoot(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/jsps/preferenceTest1.jsp.data", "/WEB-INF/preferenceTest1.jsp");
        model = StructuredModelManager.getModelManager().getModelForRead(file);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        model.releaseFromRead();
    }

    public void testDoTestGen() {
        System.out.println("    protected void setUp() throws Exception");
        System.out.println("    {");
        System.out.println("        _srcFileName = \"/testdata/jsps/preferenceTest1.jsp.data\";");
        System.out.println("        _destFileName = \"/preferenceTest1.jsp\";");
        System.out.println("        super.setUp();");
        System.out.println("    }\n");
        System.out.println("    public void testSanity()");
        System.out.println("    {");
        ELRegionHandler handler = new ELRegionHandler(){

            @Override
            public void handleRegion(ITextRegionCollection parentRegion, ITextRegion elRegion) {
                int contentStart = parentRegion.getStartOffset(elRegion);
                String elTextStr = "\"" + parentRegion.getText(elRegion) + "\"";
                System.out.println("        assertEquals(" + elTextStr + ", getELText(_structuredDocument," + contentStart + "));");
            }
        };
        CreateTestCaseForJSP.processJSP(model.getStructuredDocument(), handler);
        System.out.println("    }");
    }

    public static void processJSP(IStructuredDocument document, ELRegionHandler handler) {
        IStructuredDocumentRegion curNode = document.getFirstStructuredDocumentRegion();
        while (curNode != null) {
            if (curNode.getFirstRegion().getType() == "XML_TAG_OPEN") {
                Iterator regions = curNode.getRegions().iterator();
                ITextRegion region = null;
                while (regions.hasNext()) {
                    ITextRegion content;
                    ITextRegionCollection parentRegion;
                    ITextRegionList regionList;
                    region = (ITextRegion)regions.next();
                    if (!(region instanceof ITextRegionCollection) || region.getType() != "XML_TAG_ATTRIBUTE_VALUE" || (regionList = (parentRegion = (ITextRegionCollection)region).getRegions()).size() < 4) continue;
                    ITextRegion openQuote = regionList.get(0);
                    ITextRegion openVBLQuote = regionList.get(1);
                    if (openQuote.getType() != "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" && openQuote.getType() != "XML_TAG_ATTRIBUTE_VALUE_SQUOTE" || openVBLQuote.getType() != "JSP_VBL_OPEN" || (content = regionList.get(2)).getType() != "JSP_VBL_CONTENT") continue;
                    handler.handleRegion(parentRegion, content);
                }
            }
            curNode = curNode.getNext();
        }
    }

    public static interface ELRegionHandler {
        public void handleRegion(ITextRegionCollection var1, ITextRegion var2);
    }
}

