/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitHandler;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.WorkspaceCUFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.CompilationUnitFinderContractTest;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;

public class WorkspaceCUFinderTest
extends CompilationUnitFinderContractTest {
    @Override
    protected ICompilationUnitFinder createTarget() {
        IProjectSelector[] ps = new IProjectSelector[this.projectSelectors().size()];
        this.projectSelectors().toArray(ps);
        return new WorkspaceCUFinder(this.javaModel(), ps);
    }

    public void testProgressMonitorUpdated() throws CoreException, WsDOMLoadCanceledException {
        Mock monitor = this.mock(IProgressMonitor.class);
        monitor.stubs().method("isCanceled").will(this.returnValue(false));
        monitor.expects(this.once()).method("beginTask");
        monitor.expects(this.once()).method("done");
        monitor.expects(this.exactly(2)).method("worked");
        ICompilationUnitFinder cuFinder = this.setUpForProgressMonitorTests();
        Mock cuHandler = this.mock(ICompilationUnitHandler.class);
        cuHandler.stubs().method("handle");
        cuHandler.stubs().method("started");
        cuHandler.stubs().method("finished");
        cuFinder.find((IProgressMonitor)monitor.proxy(), (ICompilationUnitHandler)cuHandler.proxy());
    }

    public void testCnacelationRequestsProcessed() throws CoreException {
        Mock monitor = this.mock(IProgressMonitor.class);
        monitor.expects(this.once()).method("beginTask");
        monitor.expects(this.once()).method("done");
        monitor.expects(this.once()).method("isCanceled").will(this.returnValue(true));
        ICompilationUnitFinder cuFinder = this.setUpForProgressMonitorTests();
        Mock cuHandler = this.mock(ICompilationUnitHandler.class);
        cuHandler.stubs().method("handle");
        cuHandler.stubs().method("started");
        try {
            cuFinder.find((IProgressMonitor)monitor.proxy(), (ICompilationUnitHandler)cuHandler.proxy());
            WorkspaceCUFinderTest.fail((String)"SynchronizationCanceledException not thrown");
        }
        catch (WsDOMLoadCanceledException wsDOMLoadCanceledException) {}
    }

    private ICompilationUnitFinder setUpForProgressMonitorTests() throws CoreException {
        final TestProject project1 = new TestProject();
        project1.createSourceFolder("src");
        IPackageFragment pf1 = project1.createPackage("com.sap.test");
        project1.createType(pf1, "Cu1.java", "class Cu1 {}");
        project1.createType(pf1, "Cu2.java", "class Cu2 {}");
        IProjectSelector[] slectors = new IProjectSelector[]{new IProjectSelector(){

            public boolean approve(IJavaProject prj) {
                return project1.getProject().getName().equals(prj.getProject().getName());
            }
        }};
        return new WorkspaceCUFinder(this.javaModel(), slectors);
    }
}

