/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.DelegatingWSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;

public class DefaultConfiguration
extends DelegatingWSDDEngineConfiguration {
    private static final Log log = LogFactory.getLog(DefaultConfiguration.class.getName());
    private final String type;
    private WSDDDeployment deployment;

    public DefaultConfiguration(String type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        Enumeration<URL> resources;
        InputStream in;
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException ex) {
            classLoader = null;
        }
        if (classLoader != null) {
            try {
                classLoader.loadClass(DefaultConfiguration.class.getName());
            }
            catch (ClassNotFoundException ex) {
                log.debug((Object)(DefaultConfiguration.class.getName() + " not visible to thread context class loader"));
                classLoader = null;
            }
        }
        if (classLoader == null) {
            log.debug((Object)"Not using thread context class loader");
            classLoader = DefaultConfiguration.class.getClassLoader();
        } else {
            log.debug((Object)"Using thread context class loader");
        }
        String resourceName = "org/apache/axis/" + this.type + "/" + this.type + "-config.wsdd";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading resource " + resourceName));
        }
        if ((in = classLoader.getResourceAsStream(resourceName)) == null) {
            throw new ConfigurationException("Resource " + resourceName + " not found");
        }
        try {
            try {
                this.deployment = new WSDDDocument(XMLUtils.newDocument(in)).getDeployment();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
        resourceName = "META-INF/axis/default-" + this.type + "-config.wsdd";
        try {
            resources = classLoader.getResources(resourceName);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading " + url));
            }
            try {
                Object var8_13;
                in = url.openStream();
                try {
                    new WSDDDocument(XMLUtils.newDocument(in)).deploy(this.deployment);
                    var8_13 = null;
                }
                catch (Throwable throwable) {
                    var8_13 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                {
                }
            }
            catch (Exception ex) {
                throw new ConfigurationException(ex);
            }
        }
        this.deployment.configureEngine(engine);
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
    }
}

