/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.ecore.resource.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.axis.model.common.notify.AdapterFactory;
import org.apache.axis.model.common.notify.NotificationChain;
import org.apache.axis.model.common.notify.impl.NotifierImpl;
import org.apache.axis.model.common.notify.impl.NotifyingListImpl;
import org.apache.axis.model.common.util.BasicEList;
import org.apache.axis.model.common.util.EList;
import org.apache.axis.model.common.util.TreeIterator;
import org.apache.axis.model.common.util.URI;
import org.apache.axis.model.common.util.WrappedException;
import org.apache.axis.model.ecore.EObject;
import org.apache.axis.model.ecore.EPackage;
import org.apache.axis.model.ecore.impl.EPackageRegistryImpl;
import org.apache.axis.model.ecore.resource.Resource;
import org.apache.axis.model.ecore.resource.ResourceSet;
import org.apache.axis.model.ecore.resource.URIConverter;
import org.apache.axis.model.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.apache.axis.model.ecore.resource.impl.ResourceSetImpl;
import org.apache.axis.model.ecore.resource.impl.URIConverterImpl;
import org.apache.axis.model.ecore.util.EcoreUtil;
import org.apache.axis.model.ecore.util.InternalEList;

public class ResourceSetImpl
extends NotifierImpl
implements ResourceSet {
    protected EList resources;
    protected EList adapterFactories;
    protected Map loadOptions;
    protected Resource.Factory.Registry resourceFactoryRegistry;
    protected URIConverter uriConverter;
    protected EPackage.Registry packageRegistry;
    protected Map uriResourceMap;

    public Map getURIResourceMap() {
        return this.uriResourceMap;
    }

    public void setURIResourceMap(Map uriResourceMap) {
        this.uriResourceMap = uriResourceMap;
    }

    public EList getResources() {
        if (this.resources == null) {
            this.resources = new ResourcesEList();
        }
        return this.resources;
    }

    public TreeIterator getAllContents() {
        TreeIterator result = EcoreUtil.getAllContents(Collections.singleton(this));
        result.next();
        return result;
    }

    public EList getAdapterFactories() {
        if (this.adapterFactories == null) {
            this.adapterFactories = new BasicEList(){

                protected boolean useEquals() {
                    return false;
                }

                protected boolean isUnique() {
                    return true;
                }

                protected Object[] newData(int capacity) {
                    return new AdapterFactory[capacity];
                }
            };
        }
        return this.adapterFactories;
    }

    public Map getLoadOptions() {
        if (this.loadOptions == null) {
            this.loadOptions = new HashMap();
        }
        return this.loadOptions;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        if (resource != null) {
            return resource.getEObject(uri.fragment());
        }
        return null;
    }

    protected Resource demandCreateResource(URI uri) {
        return this.createResource(uri);
    }

    protected void demandLoad(Resource resource) throws IOException {
        resource.load(this.getLoadOptions());
    }

    protected void demandLoadHelper(Resource resource) {
        try {
            this.demandLoad(resource);
        }
        catch (IOException exception) {
            this.handleDemandLoadException(resource, exception);
        }
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) throws RuntimeException {
        String location = resource.getURI() == null ? null : resource.getURI().toString();
        IOException cause = exception instanceof Resource.IOWrappedException ? (Exception)exception.getCause() : exception;
        class DiagnosticWrappedException
        extends WrappedException
        implements Resource.Diagnostic {
            final /* synthetic */ ResourceSetImpl this$0;
            private final /* synthetic */ String val$location;

            public DiagnosticWrappedException(ResourceSetImpl resourceSetImpl, Exception exception, String string) {
                super(exception);
                this.this$0 = resourceSetImpl;
                this.val$location = string;
            }

            public String getLocation() {
                return this.val$location;
            }

            public int getColumn() {
                return 0;
            }

            public int getLine() {
                return 0;
            }
        }
        DiagnosticWrappedException wrappedException = new DiagnosticWrappedException(this, cause, location);
        if (resource.getErrors().isEmpty()) {
            resource.getErrors().add(exception instanceof Resource.Diagnostic ? exception : wrappedException);
        }
        throw wrappedException;
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage = this.getPackageRegistry().getEPackage(uri.toString());
        return ePackage == null ? null : ePackage.eResource();
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource;
        Resource resource2;
        Map map = this.getURIResourceMap();
        if (map != null && (resource2 = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            return resource2;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        Iterator i = this.getResources().iterator();
        while (i.hasNext()) {
            resource = (Resource)i.next();
            if (!theURIConverter.normalize(resource.getURI()).equals(normalizedURI)) continue;
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            if (map != null) {
                map.put(uri, resource);
            }
            return resource;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            if (map != null) {
                map.put(uri, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            resource = this.demandCreateResource(uri);
            if (resource == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource);
            if (map != null) {
                map.put(uri, resource);
            }
            return resource;
        }
        return null;
    }

    public Resource createResource(URI uri) {
        Resource.Factory resourceFactory = this.getResourceFactoryRegistry().getFactory(uri);
        if (resourceFactory != null) {
            Resource result = resourceFactory.createResource(uri);
            this.getResources().add(result);
            return result;
        }
        return null;
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = new ResourceFactoryRegistryImpl(){

                public Resource.Factory delegatedGetFactory(URI uri) {
                    return Resource.Factory.Registry.INSTANCE.getFactory(uri);
                }
            };
        }
        return this.resourceFactoryRegistry;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        this.resourceFactoryRegistry = resourceFactoryRegistry;
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new URIConverterImpl();
        }
        return this.uriConverter;
    }

    public void setURIConverter(URIConverter uriConverter) {
        this.uriConverter = uriConverter;
    }

    public EPackage.Registry getPackageRegistry() {
        if (this.packageRegistry == null) {
            this.packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        }
        return this.packageRegistry;
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '@' + Integer.toHexString(this.hashCode()) + " resources=" + (this.resources == null ? "[]" : this.resources.toString());
    }

    protected class ResourcesEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ResourcesEList() {
        }

        protected boolean isNotificationRequired() {
            return ResourceSetImpl.this.eNotificationRequired();
        }

        protected Object[] newData(int capacity) {
            return new Resource[capacity];
        }

        public Object getNotifier() {
            return ResourceSetImpl.this;
        }

        public int getFeatureID() {
            return 0;
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        protected NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            Resource.Internal resource = (Resource.Internal)object;
            return resource.basicSetResourceSet(ResourceSetImpl.this, notifications);
        }

        protected NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            Resource.Internal resource = (Resource.Internal)object;
            Map map = ResourceSetImpl.this.getURIResourceMap();
            if (map != null) {
                Iterator i = map.values().iterator();
                while (i.hasNext()) {
                    if (resource != i.next()) continue;
                    i.remove();
                }
            }
            return resource.basicSetResourceSet(null, notifications);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public List basicList() {
            return super.basicList();
        }
    }
}

