/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jem.internal.instantiation.InstantiationPackage;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.impl.PTCharacterLiteralImpl;
import org.eclipse.jem.internal.instantiation.impl.PTExpressionImpl;

public class PTStringLiteralImpl
extends PTExpressionImpl
implements PTStringLiteral {
    protected static final String ESCAPED_VALUE_EDEFAULT = null;
    protected String escapedValue = ESCAPED_VALUE_EDEFAULT;
    protected static final String LITERAL_VALUE_EDEFAULT = null;
    protected String literalValue = LITERAL_VALUE_EDEFAULT;
    private boolean stringLiteralSet;

    protected PTStringLiteralImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return InstantiationPackage.eINSTANCE.getPTStringLiteral();
    }

    @Override
    public String getEscapedValue() {
        return this.escapedValue;
    }

    @Override
    public void setEscapedValue(String newEscapedValue) {
        this.stringLiteralSet = false;
        this.setLiteralValueGen(LITERAL_VALUE_EDEFAULT);
        this.setEscapedValueGen(newEscapedValue);
    }

    public void setEscapedValueGen(String newEscapedValue) {
        String oldEscapedValue = this.escapedValue;
        this.escapedValue = newEscapedValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldEscapedValue, (Object)this.escapedValue));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getLiteralValue() {
        if (this.stringLiteralSet || this.escapedValue == ESCAPED_VALUE_EDEFAULT) return this.getLiteralValueGen();
        String s = this.getEscapedValue();
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer(len);
        int stop = len - 1;
        int i = 1;
        while (i < stop) {
            char ati = s.charAt(i);
            if (ati == '\\') {
                if (++i >= stop) throw new IllegalArgumentException("illegal string literal");
                ati = s.charAt(i);
                if (ati == 'u') {
                    int c1 = 0;
                    int c2 = 0;
                    int c3 = 0;
                    int c4 = 0;
                    if (i + 4 >= stop || (c1 = Character.getNumericValue(s.charAt(++i))) > 15 || c1 < 0 || (c2 = Character.getNumericValue(s.charAt(++i))) > 15 || c2 < 0 || (c3 = Character.getNumericValue(s.charAt(++i))) > 15 || c3 < 0 || (c4 = Character.getNumericValue(s.charAt(++i))) > 15 || c4 < 0) {
                        throw new IllegalArgumentException("illegal string literal");
                    }
                    buffer.append((char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4));
                } else {
                    buffer.append(PTCharacterLiteralImpl.getCharEscaped(ati));
                }
            } else {
                buffer.append(ati);
            }
            ++i;
        }
        this.stringLiteralSet = true;
        this.setLiteralValueGen(buffer.toString());
        return this.getLiteralValueGen();
    }

    public String getLiteralValueGen() {
        return this.literalValue;
    }

    @Override
    public void setLiteralValue(String newLiteralValue) {
        this.stringLiteralSet = true;
        this.setLiteralValueGen(newLiteralValue);
        StringBuffer b = new StringBuffer(newLiteralValue.length() + 2);
        b.append('\"');
        int stop = newLiteralValue.length();
        int i = 0;
        while (i < stop) {
            PTCharacterLiteralImpl.appendCharacter(newLiteralValue.charAt(i), b);
            ++i;
        }
        b.append('\"');
        this.setEscapedValueGen(b.toString());
    }

    public void setLiteralValueGen(String newLiteralValue) {
        String oldLiteralValue = this.literalValue;
        this.literalValue = newLiteralValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldLiteralValue, (Object)this.literalValue));
        }
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEscapedValue();
            }
            case 1: {
                return this.getLiteralValue();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setEscapedValue((String)newValue);
                return;
            }
            case 1: {
                this.setLiteralValue((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setEscapedValue(ESCAPED_VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setLiteralValue(LITERAL_VALUE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ESCAPED_VALUE_EDEFAULT == null ? this.escapedValue != null : !ESCAPED_VALUE_EDEFAULT.equals(this.escapedValue);
            }
            case 1: {
                return LITERAL_VALUE_EDEFAULT == null ? this.literalValue != null : !LITERAL_VALUE_EDEFAULT.equals(this.literalValue);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected void accept0(ParseVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }
}

