/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class EarFacetValidator
implements IFacetedProjectValidator {
    private static final String MARKER_ID = "org.eclipse.jst.j2ee.differentRuntimesDetected";

    public void validate(IFacetedProject fproj) throws CoreException {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)fproj.getProject());
        if (vc == null) {
            return;
        }
        if (fproj.hasProjectFacet(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) {
            fproj.getProject().deleteMarkers(MARKER_ID, false, 0);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                IProject refpj;
                IFacetedProject facetedProject;
                IVirtualReference ref = refs[i];
                IVirtualComponent refvc = ref.getReferencedComponent();
                if (refvc != null && !refvc.isBinary() && (facetedProject = ProjectFacetsManager.create((IProject)(refpj = refvc.getProject()))) != null) {
                    this.validate(fproj, facetedProject);
                }
                ++i;
            }
        } else {
            IVirtualComponent[] referencing = vc.getReferencingComponents();
            int i = 0;
            while (i < referencing.length) {
                IVirtualComponent refvc = referencing[i];
                IFacetedProject reffpj = ProjectFacetsManager.create((IProject)refvc.getProject());
                if (reffpj.hasProjectFacet(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) {
                    this.validate(reffpj);
                }
                ++i;
            }
        }
    }

    private void validate(IFacetedProject ear, IFacetedProject module) throws CoreException {
        IRuntime earRuntime = ear.getRuntime();
        IRuntime moduleRuntime = module.getRuntime();
        if (!(earRuntime == null && moduleRuntime != null || earRuntime != null && moduleRuntime == null || earRuntime == null || moduleRuntime == null || earRuntime.equals(moduleRuntime))) {
            String msg = NLS.bind((String)Resources.targetingDifferentRuntimes, (Object)module.getProject().getName());
            IMarker m = ear.createWarningMarker(MARKER_ID, msg);
            m.setAttribute("moduleProject", (Object)module.getProject().getName());
            m.setAttribute("runtime1", (Object)ear.getRuntime().getName());
            m.setAttribute("runtime2", (Object)module.getRuntime().getName());
        }
    }

    private static final class Resources
    extends NLS {
        public static String targetingDifferentRuntimes;

        static {
            Resources.initializeMessages((String)EarFacetValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

