/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class ClasspathTests
extends ModifyingResourceTests {
    public ClasspathTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ClasspathTests.buildModelTestSuite(ClasspathTests.class);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setupExternalJCL("jclMin");
    }

    protected void assertCycleMarkers(IJavaScriptProject project, IJavaScriptProject[] p, int[] expectedCycleParticipants) throws CoreException {
        ClasspathTests.waitForAutoBuild();
        StringBuffer expected = new StringBuffer("{");
        int expectedCount = 0;
        StringBuffer computed = new StringBuffer("{");
        int computedCount = 0;
        int j = 0;
        while (j < p.length) {
            int markerCount = this.numberOfCycleMarkers(p[j]);
            if (markerCount > 0) {
                if (computedCount++ > 0) {
                    computed.append(", ");
                }
                computed.append(p[j].getElementName());
            }
            if ((markerCount = expectedCycleParticipants[j]) > 0) {
                if (expectedCount++ > 0) {
                    expected.append(", ");
                }
                expected.append(p[j].getElementName());
            }
            ++j;
        }
        expected.append("}");
        computed.append("}");
        ClasspathTests.assertEquals((String)("Invalid cycle detection after setting classpath for: " + project.getElementName()), (String)expected.toString(), (String)computed.toString());
    }

    private void assertEncodeDecodeEntry(String projectName, String expectedEncoded, IIncludePathEntry entry) {
        IJavaScriptProject project = this.getJavaProject(projectName);
        String encoded = project.encodeIncludepathEntry(entry);
        this.assertSourceEquals("Unexpected encoded entry", expectedEncoded, encoded);
        IIncludePathEntry decoded = project.decodeIncludepathEntry(encoded);
        ClasspathTests.assertEquals((String)"Unexpected decoded entry", (Object)entry, (Object)decoded);
    }

    protected File createFile(File parent, String name, String content) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        file.setLastModified(System.currentTimeMillis() + 2000L);
        return file;
    }

    protected File createFolder(File parent, String name) {
        File file = new File(parent, name);
        file.mkdirs();
        return file;
    }

    protected int numberOfCycleMarkers(IJavaScriptProject javaProject) throws CoreException {
        IMarker[] markers = javaProject.getProject().findMarkers("org.eclipse.wst.jsdt.core.buildpath_problem", false, 0);
        int result = 0;
        int i = 0;
        int length = markers.length;
        while (i < length) {
            IMarker marker = markers[i];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void testAddRoot1() throws CoreException {
        IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        try {
            IIncludePathEntry newEntry = JavaScriptCore.newSourceEntry((IPath)project.getProject().getFullPath().append("extra"));
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = newEntry;
            project.setRawIncludepath(newCP, null);
            project.getProject().getFolder("extra").create(false, true, null);
            IPackageFragmentRoot newRoot = this.getPackageFragmentRoot("P", "extra");
            ClasspathTests.assertTrue((String)"New root should now be visible", (newRoot != null ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testAddRoot2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0]);
            project.setRawIncludepath(this.createClasspath("P", new String[]{"/P/src", ""}), null);
            ClasspathTests.waitForAutoBuild();
            project.getProject().getFolder("src").create(false, true, null);
            this.assertMarkers("Unexpected markers", "", project);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathChangeExternalResources() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] newEntries = new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)this.getSystemJsPath(), null, null, (boolean)false), JavaScriptCore.newLibraryEntry((IPath)this.getExternalJCLSourcePath(), null, null, (boolean)false)};
            this.setClasspath(proj, newEntries);
            this.startDeltas();
            IIncludePathEntry[] swappedEntries = new IIncludePathEntry[]{newEntries[1], newEntries[0]};
            this.setClasspath(proj, swappedEntries);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t" + this.getSystemJsPathString() + "[*]: {REORDERED}\n" + "\t" + this.getExternalJCLSourcePathString() + "[*]: {REORDERED}\n" + "\tResourceDelta(/P/.settings)[*]");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testClasspathCorruption() throws CoreException {
        try {
            try {
                JavaProject p1 = (JavaProject)this.createJavaProject("P1", new String[]{""}, new String[0], new String[0]);
                this.createJavaProject("P2", new String[]{""}, new String[0], new String[0]);
                this.createFile("P2/foo.txt", "not a project");
                String newCPContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<classpath>\t\n\t<classpathentry kind=\"src\" path=\"\"/>\t\n\t<classpathentry kind=\"src\" path=\"/P2/foo.txt\"/>\t\n</classpath>\t\n";
                IFile fileRsc = p1.getProject().getFile(".settings/.jsdtscope");
                fileRsc.setContents((InputStream)new ByteArrayInputStream(newCPContent.getBytes()), true, false, null);
                p1.close();
                JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(p1.getProject(), true);
                perProjectInfo.setClasspath(null, null, null, null, null, null, null);
                p1.getExpandedClasspath();
            }
            catch (ClassCastException classCastException) {
                ClasspathTests.assertTrue((String)"internal ClassCastException on corrupted classpath file", (boolean)false);
                this.deleteProject("P1");
                this.deleteProject("P2");
            }
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testClasspathFileRead() throws CoreException {
        try {
            IProject proj = this.createProject("P1");
            String newCPContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<classpath>\t\n\t<classpathentry kind=\"src\" path=\"src\"/>\t\n</classpath>\t\n";
            this.createFolder("/P1/.settings/");
            this.createFile("/P1/.settings/.jsdtscope", newCPContent);
            final IJavaScriptProject jproj = JavaScriptCore.create((IProject)proj);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    IIncludePathEntry[] entries = jproj.readRawIncludepath();
                    IIncludePathEntry entry = entries[0];
                    ClasspathTests.assertEquals((String)"first classpath entry should have been read", (String)"/P1/src", (String)entry.getPath().toString());
                }
            }, null);
        }
        finally {
            this.deleteProject("P1");
        }
    }

    public void testClasspathForceReload() throws CoreException {
        try {
            final JavaProject p1 = (JavaProject)this.createJavaProject("P1", new String[]{""}, new String[0], new String[0]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    p1.getRawIncludepath();
                    ClasspathTests.this.createFolder("P1/src");
                    String newCPContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<classpath>\t\n\t<classpathentry kind=\"src\" path=\"src\"/>\t\n</classpath>\t\n";
                    IFile fileRsc = p1.getProject().getFile(".settings/.jsdtscope");
                    fileRsc.setContents((InputStream)new ByteArrayInputStream(newCPContent.getBytes()), true, false, null);
                    p1.close();
                    IIncludePathEntry[] entries = p1.readRawIncludepath();
                    ClasspathTests.assertEquals((String)"source location should not have been refreshed", (String)"/P1", (String)entries[0].getPath().toString());
                }
            }, null);
        }
        finally {
            this.deleteProject("P1");
        }
    }

    public void testClasspathCreateLibraryEntry() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            this.createFile("P/src/X.js", "function X() {}");
            IFolder rootFolder = proj.getProject().getFolder((IPath)new Path("src"));
            IPackageFragmentRoot root = proj.getPackageFragmentRoot((IResource)rootFolder);
            ClasspathTests.assertEquals((String)"Unexpected root kind 1", (int)1, (int)root.getKind());
            IPackageFragment pkg = root.getPackageFragment("");
            ClasspathTests.assertEquals((String)"Unexpected numbers of compilation units", (int)1, (int)pkg.getJavaScriptUnits().length);
            this.setClasspath(proj, new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)rootFolder.getFullPath(), null, null, (boolean)false)});
            ClasspathTests.assertEquals((String)"Unexpected root kind 2", (int)2, (int)root.getKind());
            ClasspathTests.assertEquals((String)"Unexpected numbers of compilation units", (int)0, (int)pkg.getJavaScriptUnits().length);
            proj.close();
            ClasspathTests.assertEquals((String)"Unexpected root kind 3", (int)2, (int)root.getKind());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathCrossProject() throws CoreException {
        IJavaScriptProject project = this.createJavaProject("P1", new String[]{""});
        this.createJavaProject("P2", new String[0]);
        try {
            this.startDeltas();
            IPackageFragmentRoot oldRoot = this.getPackageFragmentRoot("P1", "");
            IIncludePathEntry projectEntry = JavaScriptCore.newProjectEntry((IPath)new Path("/P2"), (boolean)false);
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[]{projectEntry};
            project.setRawIncludepath(newClasspath, null);
            project.getAllPackageFragmentRoots();
            IJavaScriptElementDelta removedDelta = this.getDeltaFor((IJavaScriptElement)oldRoot, true);
            this.assertDeltas("Unexpected delta", "<project root>[*]: {REMOVED FROM CLASSPATH}", removedDelta);
        }
        catch (Throwable throwable) {
            this.stopDeltas();
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.stopDeltas();
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testClasspathDeleteNestedRoot() throws CoreException {
        IJavaScriptProject project = this.createJavaProject("P", new String[]{"nested/src"}, new String[0]);
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "nested/src");
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        this.deleteResource(root.getUnderlyingResource());
        IIncludePathEntry[] newCP = project.getRawIncludepath();
        try {
            ClasspathTests.assertTrue((String)"classpath should not have been updated", (newCP.length == 2 && newCP[0].equals(originalCP[0]) && newCP[1].equals(originalCP[1]) ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathDiamond() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{""});
            this.createJavaProject("P2", new String[]{""}, new String[0], new String[]{"/P1"});
            this.createJavaProject("P3", new String[]{""}, new String[0], new String[]{"/P1", "/P2"});
            IJavaScriptProject p4 = this.createJavaProject("P4", new String[]{""}, new String[0], new String[]{"/P2", "/P3"});
            ClasspathTests.assertTrue((String)"Should not detect cycle", (!p4.hasIncludepathCycle(null) ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2", "P3", "P4"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2", "P3", "P4"});
    }

    public void testClasspathDeleteNestedRootParent() throws CoreException {
        IJavaScriptProject project = this.createJavaProject("P", new String[]{"nested/src"}, new String[0]);
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "nested/src");
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        IFolder folder = (IFolder)root.getUnderlyingResource().getParent();
        this.deleteResource((IResource)folder);
        IIncludePathEntry[] newCP = project.getRawIncludepath();
        try {
            ClasspathTests.assertTrue((String)"classpath should not have been updated", (newCP.length == 2 && newCP[0].equals(originalCP[0]) && newCP[1].equals(originalCP[1]) ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathExternalize() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{this.getSystemJsPathString()});
            IIncludePathEntry[] classpath = project.getRawIncludepath();
            IIncludePathEntry jar = null;
            int i = 0;
            while (i < classpath.length) {
                if (classpath[i].getEntryKind() == 1) {
                    jar = classpath[i];
                    break;
                }
                ++i;
            }
            project.close();
            project.open(null);
            classpath = project.getRawIncludepath();
            i = 0;
            while (i < classpath.length) {
                if (classpath[i].getEntryKind() == 1) {
                    ClasspathTests.assertTrue((String)"Paths must be the same", (boolean)classpath[i].getPath().equals((Object)jar.getPath()));
                    break;
                }
                ++i;
            }
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathMoveNestedRoot() throws CoreException {
        IJavaScriptProject project = this.createJavaProject("P", new String[]{"nested/src"}, new String[0]);
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "nested/src");
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        IFolder folder = (IFolder)root.getUnderlyingResource();
        IPath originalPath = folder.getFullPath();
        IPath newPath = originalPath.removeLastSegments(1);
        newPath = newPath.append((IPath)new Path("newsrc"));
        this.startDeltas();
        folder.move(newPath, true, null);
        IIncludePathEntry[] newCP = project.getRawIncludepath();
        IPackageFragmentRoot newRoot = project.getPackageFragmentRoot((IResource)project.getProject().getFolder("nested").getFolder("newsrc"));
        try {
            ClasspathTests.assertTrue((String)"classpath not automatically updated", (newCP.length == 2 && newCP[1].equals(originalCP[1]) && newCP[0].equals(originalCP[0]) ? 1 : 0) != 0);
            IJavaScriptElementDelta rootDelta = this.getDeltaFor((IJavaScriptElement)root, true);
            IJavaScriptElementDelta projectDelta = this.getDeltaFor(newRoot.getParent(), true);
            ClasspathTests.assertTrue((String)"should get delta for moved root", (rootDelta != null && rootDelta.getKind() == 2 && rootDelta.getFlags() == 0 ? 1 : 0) != 0);
            ClasspathTests.assertTrue((String)"should get delta indicating content changed for project", (boolean)this.deltaContentChanged(projectDelta));
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testClasspathMoveNestedRootParent() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"nested/src"}, new String[0]);
            IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "nested/src");
            IIncludePathEntry[] originalCP = project.getRawIncludepath();
            IFolder folder = (IFolder)root.getUnderlyingResource().getParent();
            IPath originalPath = folder.getFullPath();
            IPath newPath = originalPath.removeLastSegments(1);
            newPath = newPath.append((IPath)new Path("newsrc"));
            folder.move(newPath, true, null);
            IIncludePathEntry[] newCP = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"classpath should not automatically be updated", (newCP.length == 2 && newCP[1].equals(originalCP[1]) && newCP[0].equals(originalCP[0]) ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathNoChanges() throws CoreException {
        try {
            IJavaScriptProject p = this.createJavaProject("P", new String[]{""});
            IIncludePathEntry[] oldClasspath = p.getRawIncludepath();
            this.startDeltas();
            p.setRawIncludepath(oldClasspath, null);
            this.assertDeltas("Unexpected delta", "");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testClasspathReordering() throws CoreException {
        IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"}, new String[]{this.getSystemJsPathString()});
        IIncludePathEntry[] originalCP = proj.getRawIncludepath();
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "src");
        try {
            IIncludePathEntry[] newEntries = new IIncludePathEntry[originalCP.length];
            int index = originalCP.length - 1;
            int i = 0;
            while (i < originalCP.length) {
                newEntries[index] = originalCP[i];
                --index;
                ++i;
            }
            this.startDeltas();
            this.setClasspath(proj, newEntries);
            ClasspathTests.assertTrue((String)"should be one delta - two roots reordered", (this.deltaListener.deltas.length == 1 ? 1 : 0) != 0);
            IJavaScriptElementDelta d = null;
            d = this.getDeltaFor((IJavaScriptElement)root, true);
            ClasspathTests.assertTrue((String)"root should be reordered in the classpath", (d != null && (d.getFlags() & 0x100) > 0 ? 1 : 0) != 0);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation01() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = newCP[0];
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have detected duplicate entries on the classpath", "Include path contains duplicate entry: 'src' for project P", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation02() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"));
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have detected nested source folders on the classpath", "Cannot nest 'P/src' inside 'P'. To enable the nesting exclude 'src/' from 'P'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation03() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newLibraryEntry((IPath)new Path("/P/src/lib"), null, null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have detected library folder nested inside source folder on the classpath", "Cannot nest 'P/src/lib' inside 'P/src'. To enable the nesting exclude 'lib/' from 'P/src'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation04() throws CoreException {
        IJavaScriptProject[] p = null;
        try {
            p = new IJavaScriptProject[]{this.createJavaProject("P0", new String[]{"src0"}), this.createJavaProject("P1", new String[]{"src1"})};
            JavaScriptCore.setIncludepathVariable((String)"var", (IPath)new Path("/P1"), null);
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P0/src0")), JavaScriptCore.newVariableEntry((IPath)new Path("var/src1"), null, null)};
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)p[0], (IIncludePathEntry[])newClasspath);
            this.assertStatus("should not detect external source folder through a variable on the classpath", "OK", (IStatus)status);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P0", "P1"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P0", "P1"});
    }

    public void testClasspathValidation05() throws CoreException {
        IJavaScriptProject[] p = null;
        try {
            p = new IJavaScriptProject[]{this.createJavaProject("P0", new String[]{"src0", "src1"}), this.createJavaProject("P1", new String[]{"src1"})};
            JavaScriptCore.setJsGlobalScopeContainer((IPath)new Path("container/default"), (IJavaScriptProject[])new IJavaScriptProject[]{p[0]}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{new TestContainer((IPath)new Path("container/default"), new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P0/src0")), JavaScriptCore.newVariableEntry((IPath)new Path("var/src1"), null, null)})}, null);
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P0/src1")), JavaScriptCore.newContainerEntry((IPath)new Path("container/default"))};
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)p[0], (IIncludePathEntry[])newClasspath);
            this.assertStatus("should not have detected external source folder through a container on the classpath", "OK", (IStatus)status);
            status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)p[0], (IIncludePathEntry)newClasspath[1], (boolean)true);
            this.assertStatus("should have detected external source folder through a container on the classpath", "Invalid classpath container: 'container/default' in project P0", (IStatus)status);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P0", "P1"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P0", "P1"});
    }

    public void testClasspathValidation06() throws CoreException {
        IJavaScriptProject[] p = null;
        try {
            p = new IJavaScriptProject[]{this.createJavaProject("P0", new String[]{"src"})};
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P0")), JavaScriptCore.newSourceEntry((IPath)new Path("/P0/src"))};
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)p[0], (IIncludePathEntry[])newClasspath);
            this.assertStatus("should have detected nested source folder", "Cannot nest 'P0/src' inside 'P0'. To enable the nesting exclude 'src/' from 'P0'", (IStatus)status);
        }
        finally {
            this.deleteProject("P0");
        }
    }

    public void testClasspathValidation07() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("src/")});
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have allowed nested source folders with exclusion on the classpath", "OK", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation08() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0], new String[]{"lib"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("lib/")});
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have allowed nested lib folders with exclusion on the classpath", "OK", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation15() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("**/src")});
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("End exclusion filter 'src' with / to fully exclude 'P/src'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation19() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0], new String[]{"lib"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P/lib/src"));
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have detected library folder nested inside source folder on the classpath", "Cannot nest 'P/lib/src' inside library 'P/lib'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation21() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0]);
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[]{new Path("**/src")}, null);
            Hashtable<String, String> options = new Hashtable<String, String>(5);
            options.put("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns", "disabled");
            proj.setOptions(options);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("Inclusion or exclusion patterns are disabled in project P, cannot selectively include or exclude from entry: 'src'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation27_Bug159325_project() throws CoreException {
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            IJavaScriptProject proj1 = this.createJavaProject("P1", new String[0]);
            proj1.setOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
            Hashtable options = JavaScriptCore.getOptions();
            options.put("org.eclipse.wst.jsdt.core.incompatibleJDKLevel", "warning");
            JavaScriptCore.setOptions((Hashtable)options);
            IJavaScriptProject proj2 = this.createJavaProject("P2", new String[0]);
            proj2.setOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
            proj2.setOption("org.eclipse.wst.jsdt.core.incompatibleJDKLevel", new String("ignore".toCharArray()));
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj2, (IIncludePathEntry)JavaScriptCore.newProjectEntry((IPath)new Path("/P1")), (boolean)false);
            this.assertStatus("OK", (IStatus)status);
        }
        catch (Throwable throwable) {
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testClasspathValidation27_Bug159325_lib() throws CoreException {
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            IJavaScriptProject proj = this.createJavaProject("P1", new String[0]);
            proj.setOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
            Hashtable options = JavaScriptCore.getOptions();
            options.put("org.eclipse.wst.jsdt.core.incompatibleJDKLevel", "warning");
            JavaScriptCore.setOptions((Hashtable)options);
            proj.setOption("org.eclipse.wst.jsdt.core.incompatibleJDKLevel", new String("ignore".toCharArray()));
            IIncludePathEntry library = JavaScriptCore.newLibraryEntry((IPath)new Path(this.getExternalJCLPathString("1.5")), null, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, null, (boolean)false);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)library, (boolean)false);
            this.assertStatus("OK", (IStatus)status);
        }
        catch (Throwable throwable) {
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testClasspathValidation34() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("src/")}, (IPath[])new IPath[0], null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should not have allowed nested source folders with inclusion on the classpath", "Cannot nest 'P/src' inside 'P'. To enable the nesting exclude 'src/' from 'P'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation35() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0], new String[]{"lib"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("lib/")}, (IPath[])new Path[0], null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should not have allowed nested lib folders with inclusion on the classpath", "Cannot nest 'P/lib' inside 'P'. To enable the nesting exclude 'lib/' from 'P'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation36() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("**/src")}, (IPath[])new Path[0], null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("OK", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation37() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0]);
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[]{new Path("**/src")}, (IPath[])new Path[0], null);
            Hashtable<String, String> options = new Hashtable<String, String>(5);
            options.put("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns", "disabled");
            proj.setOptions(options);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("Inclusion or exclusion patterns are disabled in project P, cannot selectively include or exclude from entry: 'src'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathValidation42() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
            proj.setOption("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns", "disabled");
            IIncludePathEntry[] originalCP = proj.getRawIncludepath();
            IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = JavaScriptCore.newSourceEntry((IPath)new Path("/P"));
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)proj, (IIncludePathEntry[])newCP);
            this.assertStatus("should have detected nested source folders on the classpath", "Cannot nest 'P/src' inside 'P'. To allow the nesting enable use of exclusion patterns in the preferences of project 'P' and exclude 'src/' from 'P'", (IStatus)status);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathWithDuplicateEntries() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] cp = project.getRawIncludepath();
            IIncludePathEntry[] newCp = new IIncludePathEntry[cp.length * 2];
            System.arraycopy(cp, 0, newCp, 0, cp.length);
            System.arraycopy(cp, 0, newCp, cp.length, cp.length);
            try {
                project.setRawIncludepath(newCp, null);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                this.deleteProject("P");
                return;
            }
            ClasspathTests.assertTrue((String)"Setting the classpath with two entries specifying the same path should fail", (boolean)false);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathDuplicateExtraAttribute() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P1", new String[0]);
            IIncludePathAttribute[] extraAttributes = new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"javadoc_location", (String)"http://www.sample-url.org/doc/"), JavaScriptCore.newIncludepathAttribute((String)"javadoc_location", (String)"d:/tmp")};
            IIncludePathEntry container = JavaScriptCore.newContainerEntry((IPath)new Path("JRE_CONTAINER"), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IIncludePathAttribute[])extraAttributes, (boolean)false);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)container, (boolean)false);
            this.assertStatus("Duplicate extra attribute: 'javadoc_location' in classpath entry 'JRE_CONTAINER' for project 'P1'", (IStatus)status);
            IIncludePathEntry library = JavaScriptCore.newLibraryEntry((IPath)new Path(this.getSystemJsPathString()), null, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IIncludePathAttribute[])extraAttributes, (boolean)false);
            status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)library, (boolean)false);
            this.assertStatus("Duplicate extra attribute: 'javadoc_location' in classpath entry '" + this.getExternalJCLPath("") + "' for project 'P1'", (IStatus)status);
            this.createJavaProject("P2");
            IIncludePathEntry projectEntry = JavaScriptCore.newProjectEntry((IPath)new Path("/P2"), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (boolean)false, (IIncludePathAttribute[])extraAttributes, (boolean)false);
            status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)projectEntry, (boolean)false);
            this.assertStatus("Duplicate extra attribute: 'javadoc_location' in classpath entry '/P2' for project 'P1'", (IStatus)status);
            this.createFolder("/P1/src");
            IIncludePathEntry sourceEntry = JavaScriptCore.newSourceEntry((IPath)new Path("/P1/src"), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IIncludePathAttribute[])extraAttributes);
            status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)sourceEntry, (boolean)false);
            this.assertStatus("Duplicate extra attribute: 'javadoc_location' in classpath entry 'src' for project 'P1'", (IStatus)status);
            IIncludePathEntry variable = JavaScriptCore.newVariableEntry((IPath)new Path("JCL_LIB"), (IPath)new Path("JCL_SRC"), null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IIncludePathAttribute[])extraAttributes, (boolean)false);
            status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)variable, (boolean)false);
            this.assertStatus("Duplicate extra attribute: 'javadoc_location' in classpath entry '" + this.getExternalJCLPath("") + "' for project 'P1'", (IStatus)status);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testClasspathWithNonExistentLibraryEntry() throws CoreException {
        try {
            IIncludePathEntry newEntry;
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalPath = project.getRawIncludepath();
            IPackageFragmentRoot[] originalRoots = project.getPackageFragmentRoots();
            IIncludePathEntry[] newPath = new IIncludePathEntry[originalPath.length + 1];
            System.arraycopy(originalPath, 0, newPath, 0, originalPath.length);
            newPath[originalPath.length] = newEntry = JavaScriptCore.newLibraryEntry((IPath)new Path("c:/nothing/nozip.jar").makeAbsolute(), null, null, (boolean)false);
            project.setRawIncludepath(newPath, null);
            IIncludePathEntry[] getPath = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"should be the same length", (getPath.length == newPath.length ? 1 : 0) != 0);
            int i = 0;
            while (i < getPath.length) {
                ClasspathTests.assertTrue((String)"entries should be the same", (boolean)getPath[i].equals(newPath[i]));
                ++i;
            }
            IPackageFragmentRoot[] newRoots = project.getPackageFragmentRoots();
            ClasspathTests.assertTrue((String)"Should be the same number of roots", (originalRoots.length == newRoots.length ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < newRoots.length) {
                ClasspathTests.assertTrue((String)"roots should be the same", (boolean)originalRoots[i2].equals(newRoots[i2]));
                ++i2;
            }
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathWithNonExistentProjectEntry() throws CoreException {
        try {
            IIncludePathEntry newEntry;
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalPath = project.getRawIncludepath();
            IPackageFragmentRoot[] originalRoots = project.getPackageFragmentRoots();
            IIncludePathEntry[] newPath = new IIncludePathEntry[originalPath.length + 1];
            System.arraycopy(originalPath, 0, newPath, 0, originalPath.length);
            newPath[originalPath.length] = newEntry = JavaScriptCore.newProjectEntry((IPath)new Path("/NoProject"), (boolean)false);
            project.setRawIncludepath(newPath, null);
            IIncludePathEntry[] getPath = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"should be the same length", (getPath.length == newPath.length ? 1 : 0) != 0);
            int i = 0;
            while (i < getPath.length) {
                ClasspathTests.assertTrue((String)"entries should be the same", (boolean)getPath[i].equals(newPath[i]));
                ++i;
            }
            IPackageFragmentRoot[] newRoots = project.getPackageFragmentRoots();
            ClasspathTests.assertTrue((String)"Should be the same number of roots", (originalRoots.length == newRoots.length ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < newRoots.length) {
                ClasspathTests.assertTrue((String)"roots should be the same", (boolean)originalRoots[i2].equals(newRoots[i2]));
                ++i2;
            }
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClasspathWithNonExistentSourceEntry() throws CoreException {
        try {
            IIncludePathEntry newEntry;
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IIncludePathEntry[] originalPath = project.getRawIncludepath();
            IPackageFragmentRoot[] originalRoots = project.getPackageFragmentRoots();
            IIncludePathEntry[] newPath = new IIncludePathEntry[originalPath.length + 1];
            System.arraycopy(originalPath, 0, newPath, 0, originalPath.length);
            newPath[originalPath.length] = newEntry = JavaScriptCore.newSourceEntry((IPath)new Path("/P/moreSource"));
            project.setRawIncludepath(newPath, null);
            IIncludePathEntry[] getPath = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"should be the same length", (getPath.length == newPath.length ? 1 : 0) != 0);
            int i = 0;
            while (i < getPath.length) {
                ClasspathTests.assertTrue((String)"entries should be the same", (boolean)getPath[i].equals(newPath[i]));
                ++i;
            }
            IPackageFragmentRoot[] newRoots = project.getPackageFragmentRoots();
            ClasspathTests.assertTrue((String)"Should be the same number of roots", (originalRoots.length == newRoots.length ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < newRoots.length) {
                ClasspathTests.assertTrue((String)"roots should be the same", (boolean)originalRoots[i2].equals(newRoots[i2]));
                ++i2;
            }
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCycleReport() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{""});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""});
            IJavaScriptProject p3 = this.createJavaProject("P3", new String[]{""}, new String[0], new String[]{"/P2"});
            IJavaScriptProject[] projects = new IJavaScriptProject[]{p1, p2, p3};
            int cycleMarkerCount = 0;
            int i = 0;
            while (i < projects.length) {
                cycleMarkerCount += this.numberOfCycleMarkers(projects[i]);
                ++i;
            }
            ClasspathTests.assertTrue((String)"Should have no cycle markers", (cycleMarkerCount == 0 ? 1 : 0) != 0);
            IIncludePathEntry[] originalP1CP = p1.getRawIncludepath();
            IIncludePathEntry[] originalP2CP = p2.getRawIncludepath();
            int length = originalP2CP.length;
            IIncludePathEntry[] newCP = new IIncludePathEntry[length + 1];
            System.arraycopy(originalP2CP, 0, newCP, 0, length);
            newCP[length] = JavaScriptCore.newProjectEntry((IPath)p1.getProject().getFullPath(), (boolean)false);
            p2.setRawIncludepath(newCP, null);
            length = originalP1CP.length;
            newCP = new IIncludePathEntry[length + 1];
            System.arraycopy(originalP1CP, 0, newCP, 0, length);
            newCP[length] = JavaScriptCore.newProjectEntry((IPath)p3.getProject().getFullPath(), (boolean)false);
            p1.setRawIncludepath(newCP, null);
            ClasspathTests.waitForAutoBuild();
            cycleMarkerCount = 0;
            int i2 = 0;
            while (i2 < projects.length) {
                cycleMarkerCount += this.numberOfCycleMarkers(projects[i2]);
                ++i2;
            }
            ClasspathTests.assertEquals((String)"Unexpected number of projects involved in a classpath cycle", (int)3, (int)cycleMarkerCount);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2", "P3"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2", "P3"});
    }

    public void testDefaultClasspathLocation() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{""});
            IIncludePathEntry[] classpath = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"Incorrect default classpath; to many entries", (classpath.length == 2 ? 1 : 0) != 0);
            ClasspathTests.assertTrue((String)("Incorrect default classpath: " + classpath[0]), (boolean)classpath[0].getPath().equals((Object)project.getUnderlyingResource().getFullPath()));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testEmptyClasspath() throws CoreException {
        IJavaScriptProject project = this.createJavaProject("P", new String[]{""});
        try {
            this.startDeltas();
            this.setClasspath(project, new IIncludePathEntry[0]);
            IIncludePathEntry[] cp = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"classpath should have no entries", (cp.length == 0 ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t<project root>[*]: {REMOVED FROM CLASSPATH}\n  D:\\WTPDevelopment\\junit-workspace\\.metadata\\.plugins\\org.eclipse.wst.jsdt.core\\libraries\\system.js[*]: {REORDERED}\n\tResourceDelta(/P/.settings)[*]");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testEncoding() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src\u3400"});
            IFile file = this.getFile("/P/.settings/.jsdtscope");
            String encodedContents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)file, (String)"UTF-8"));
            encodedContents = Util.convertToIndependantLineDelimiter((String)encodedContents);
            ClasspathTests.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src\u3400\"/>\n <classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.launching.JRE_CONTAINER\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", (String)encodedContents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testEncodeDecodeEntry01() {
        this.assertEncodeDecodeEntry("P", "<classpathentry kind=\"src\" path=\"src\"/>\n", JavaScriptCore.newSourceEntry((IPath)new Path("/P/src")));
    }

    public void testEncodeDecodeEntry02() {
        this.assertEncodeDecodeEntry("P", "<classpathentry excluding=\"**/X.js\" including=\"**/Y.js\" kind=\"src\" output=\"bin\" path=\"src\">\n\t<attributes>\n\t\t<attribute name=\"attrName\" value=\"some value\"/>\n\t</attributes>\n</classpathentry>\n", JavaScriptCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[]{new Path("**/Y.js")}, (IPath[])new IPath[]{new Path("**/X.js")}, (IPath)new Path("/P/bin"), (IIncludePathAttribute[])new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"attrName", (String)"some value")}));
    }

    public void testEncodeDecodeEntry03() {
        this.assertEncodeDecodeEntry("P1", "<classpathentry kind=\"src\" path=\"/P2\"/>\n", JavaScriptCore.newProjectEntry((IPath)new Path("/P2")));
    }

    public void testEncodeDecodeEntry04() {
        this.assertEncodeDecodeEntry("P", "<classpathentry exported=\"true\" kind=\"lib\" path=\"lib.jar\" rootpath=\"root\" sourcepath=\"src.zip\">\n\t<attributes>\n\t\t<attribute name=\"attr1\" value=\"val1\"/>\n\t</attributes>\n\t<accessrules>\n\t\t<accessrule kind=\"accessible\" pattern=\"**/A*.js\"/>\n\t</accessrules>\n</classpathentry>\n", JavaScriptCore.newLibraryEntry((IPath)new Path("/P/lib.jar"), (IPath)new Path("/P/src.zip"), (IPath)new Path("root"), (IAccessRule[])new IAccessRule[]{JavaScriptCore.newAccessRule((IPath)new Path("**/A*.js"), (int)0)}, (IIncludePathAttribute[])new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"attr1", (String)"val1")}, (boolean)true));
    }

    public void testEncodeDecodeEntry05() {
        this.assertEncodeDecodeEntry("P", "<classpathentry exported=\"true\" kind=\"lib\" path=\"lib.jar\" rootpath=\"root\" sourcepath=\"src.zip\">\n\t<attributes>\n\t\t<attribute name=\"attr1\" value=\"val1\"/>\n\t</attributes>\n\t<accessrules>\n\t\t<accessrule ignoreifbetter=\"true\" kind=\"accessible\" pattern=\"**/A*.js\"/>\n\t</accessrules>\n</classpathentry>\n", JavaScriptCore.newLibraryEntry((IPath)new Path("/P/lib.jar"), (IPath)new Path("/P/src.zip"), (IPath)new Path("root"), (IAccessRule[])new IAccessRule[]{JavaScriptCore.newAccessRule((IPath)new Path("**/A*.js"), (int)256)}, (IIncludePathAttribute[])new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"attr1", (String)"val1")}, (boolean)true));
    }

    public void testEmptyContainer() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0]);
            this.startDeltas();
            JavaScriptCore.setJsGlobalScopeContainer((IPath)new Path("container/default"), (IJavaScriptProject[])new IJavaScriptProject[]{proj}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{new TestContainer((IPath)new Path("container/default"), new IIncludePathEntry[0])}, null);
            IIncludePathEntry container = JavaScriptCore.newContainerEntry((IPath)new Path("container/default"), (boolean)true);
            proj.setRawIncludepath(new IIncludePathEntry[]{container}, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CONTENT | CLASSPATH CHANGED}\n   D:\\WTPDevelopment\\junit-workspace\\.metadata\\.plugins\\org.eclipse.wst.jsdt.core\\libraries\\system.js[*]: {REORDERED}\n\tResourceDelta(/P/.classpath)[*]");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testEmptyInclusionPattern() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{""});
            project.open(null);
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n  <classpathentry including=\"X.java|\" kind=\"src\" path=\"\"/>\n  <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            project.getProject().close(null);
            project.getProject().open(null);
            project.getPackageFragmentRoot((IResource)project.getProject()).open(null);
            IIncludePathEntry[] classpath = project.getRawIncludepath();
            this.assertClasspathEquals(classpath, "/P[CPE_SOURCE][K_SOURCE][isExported:false][including:X.java]");
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testExportContainer() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{""});
            JavaScriptCore.setJsGlobalScopeContainer((IPath)new Path("container/default"), (IJavaScriptProject[])new IJavaScriptProject[]{p1}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{new TestContainer((IPath)new Path("container/default"), new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)this.getExternalJCLPath(""), null, null)})}, null);
            IIncludePathEntry container = JavaScriptCore.newContainerEntry((IPath)new Path("container/default"), (boolean)true);
            p1.setRawIncludepath(new IIncludePathEntry[]{container}, null);
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[0], new String[]{"/P1"});
            IIncludePathEntry[] classpath = ((JavaProject)p2).getExpandedClasspath();
            ClasspathTests.assertEquals((String)"Unexpected number of classpath entries", (int)2, (int)classpath.length);
            ClasspathTests.assertEquals((String)"Unexpected first entry", (String)"/P1", (String)classpath[0].getPath().toString());
            ClasspathTests.assertEquals((String)"Unexpected second entry", (String)this.getSystemJsPathString(), (String)classpath[1].getPath().toOSString());
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testExtraAttributes1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IIncludePathEntry entry = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IIncludePathAttribute[])new IIncludePathAttribute[0]);
            project.setRawIncludepath(new IIncludePathEntry[]{entry}, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testExtraAttributes2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IIncludePathAttribute attribute = JavaScriptCore.newIncludepathAttribute((String)"foo", (String)"some value");
            IIncludePathEntry entry = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IIncludePathAttribute[])new IIncludePathAttribute[]{attribute});
            project.setRawIncludepath(new IIncludePathEntry[]{entry}, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"\">\n\t\t<attributes>\n\t\t\t<attribute name=\"foo\" value=\"some value\"/>\n\t\t</attributes>\n\t</classpathentry>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testExtraAttributes3() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IIncludePathAttribute attribute1 = JavaScriptCore.newIncludepathAttribute((String)"foo", (String)"some value");
            IIncludePathAttribute attribute2 = JavaScriptCore.newIncludepathAttribute((String)"bar", (String)"other value");
            IIncludePathEntry entry = JavaScriptCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IIncludePathAttribute[])new IIncludePathAttribute[]{attribute1, attribute2});
            project.setRawIncludepath(new IIncludePathEntry[]{entry}, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"\">\n\t\t<attributes>\n\t\t\t<attribute name=\"foo\" value=\"some value\"/>\n\t\t\t<attribute name=\"bar\" value=\"other value\"/>\n\t\t</attributes>\n\t</classpathentry>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testExtraAttributes4() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"\">\n\t\t<attributes>\n\t\t\t<attribute value=\"some value\" name=\"foo\"/>\n\t\t</attributes>\n\t</classpathentry>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n");
            this.assertClasspathEquals(project.getRawIncludepath(), "/P[CPE_SOURCE][K_SOURCE][isExported:false][attributes:foo=some value]");
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testHasClasspathCycle() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{""});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""});
            this.createJavaProject("P3", new String[]{""}, new String[0], new String[]{"/P1"});
            IIncludePathEntry[] originalP1CP = p1.getRawIncludepath();
            IIncludePathEntry[] originalP2CP = p2.getRawIncludepath();
            ClasspathTests.assertTrue((String)"P1 should not have a cycle", (!p1.hasIncludepathCycle(originalP1CP) ? 1 : 0) != 0);
            int length = originalP2CP.length;
            IIncludePathEntry[] newCP = new IIncludePathEntry[length + 1];
            System.arraycopy(originalP2CP, 0, newCP, 0, length);
            newCP[length] = JavaScriptCore.newProjectEntry((IPath)p1.getProject().getFullPath(), (boolean)false);
            ClasspathTests.assertTrue((String)"P2 should not have a cycle", (!p2.hasIncludepathCycle(newCP) ? 1 : 0) != 0);
            p2.setRawIncludepath(newCP, null);
            length = originalP1CP.length;
            newCP = new IIncludePathEntry[length + 1];
            System.arraycopy(originalP1CP, 0, newCP, 0, length);
            newCP[length] = JavaScriptCore.newProjectEntry((IPath)p2.getProject().getFullPath(), (boolean)false);
            ClasspathTests.assertTrue((String)"P3 should have a cycle", (boolean)p2.hasIncludepathCycle(newCP));
            IWorkspace workspace = this.getJavaModel().getWorkspace();
            IMarker[] markers = workspace.getRoot().findMarkers("org.eclipse.wst.jsdt.core.transient_problem", true, 1);
            boolean hasCycleMarker = false;
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("cycleDetected") != null) {
                    hasCycleMarker = true;
                    break;
                }
                ++i;
            }
            ClasspathTests.assertTrue((String)"Should have no cycle markers", (!hasCycleMarker ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2", "P3"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2", "P3"});
    }

    public void testInvalidClasspath1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            this.assertMarkers("Unexpected markers", "XML format error in '.classpath' file of project P: Bad format", project);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testInvalidClasspath2() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P", new String[]{"src"});
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src1\" path=\"src\"/>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            this.assertMarkers("Unexpected markers", "Illegal entry in '.classpath' of project P file: Unknown kind: 'src1'", javaProject);
            IProject project = javaProject.getProject();
            project.build(6, null);
            ClasspathTests.waitForAutoBuild();
            this.assertMarkers("Unexpected markers", "Illegal entry in '.classpath' of project P file: Unknown kind: 'src1'", javaProject);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testInvalidSourceFolder() throws CoreException {
        try {
            this.createJavaProject("P1");
            IJavaScriptProject proj = this.createJavaProject("P2", new String[0], new String[0], new String[]{"/P1/src1/src2"});
            this.assertMarkers("Unexpected markers", "Project P2 is missing required source folder: '/P1/src1/src2'", proj);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testMissingClasspath() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P");
            IProject project = javaProject.getProject();
            project.close(null);
            this.deleteFile(new File(project.getLocation().toOSString(), ".settings/.jsdtscope"));
            ClasspathTests.waitForAutoBuild();
            project.open(null);
            ClasspathTests.waitForAutoBuild();
            project.build(6, null);
            ClasspathTests.waitForAutoBuild();
            project.build(6, null);
            ClasspathTests.waitForAutoBuild();
            this.assertMarkers("Unexpected markers", "Unable to read '.jsdtscope' file of project P", javaProject);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testMissingPrereq1() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("A", new String[0]);
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)new Path("/B"))};
            javaProject.setRawIncludepath(classpath, null);
            this.assertMarkers("Unexpected markers", "Project A is missing required Java project: 'B'", javaProject);
        }
        finally {
            this.deleteProject("A");
        }
    }

    public void testMissingPrereq2() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("A", new String[0], new String[0], new String[]{"/B"});
            this.assertMarkers("Unexpected markers", "Project A is missing required Java project: 'B'", javaProject);
        }
        finally {
            this.deleteProject("A");
        }
    }

    public void testMissingPrereq3() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("A", new String[0], new String[0], new String[]{"/B"});
            this.createJavaProject("B", new String[0]);
            this.assertMarkers("Unexpected markers", "", javaProject);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"A", "B"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"A", "B"});
    }

    public void testMissingPrereq4() throws CoreException {
        try {
            IJavaScriptProject projectA = this.createJavaProject("A", new String[0], new String[0], new String[]{"/B"});
            IJavaScriptProject projectB = this.createJavaProject("B", new String[0], new String[0], new String[]{"/A"});
            this.assertMarkers("Unexpected markers for project A", "A cycle was detected in the include path of project: A", projectA);
            this.assertMarkers("Unexpected markers for project B", "A cycle was detected in the include path of project: B", projectB);
            this.deleteProject("B");
            this.assertMarkers("Unexpected markers for project A after deleting of project B", "Project A is missing required Java project: 'B'", projectA);
            projectB = this.createJavaProject("B", new String[0], new String[0], new String[]{"/A"});
            this.assertMarkers("Unexpected markers for project A after adding project B back", "A cycle was detected in the build path of project: A", projectA);
            this.assertMarkers("Unexpected markers for project B after adding project B back", "A cycle was detected in the build path of project: B", projectB);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"A", "B"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"A", "B"});
    }

    public void testNullClasspath() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{""});
            this.setClasspath(project, null);
            IIncludePathEntry[] cp = project.getRawIncludepath();
            ClasspathTests.assertTrue((String)"classpath should have one root entry", (cp.length == 1 && cp[0].getPath().equals((Object)project.getUnderlyingResource().getFullPath()) ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCombineAccessRules1() throws CoreException {
        try {
            this.createJavaProject("P1");
            IJavaScriptProject project = this.createJavaProject("P2");
            IIncludePathEntry entry = JavaScriptCore.newProjectEntry((IPath)new Path("/P1"), null, (boolean)false, (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)false);
            project.setRawIncludepath(new IIncludePathEntry[]{entry}, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P2/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/P1\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCombineAccessRules2() throws CoreException {
        try {
            this.createJavaProject("P1");
            IJavaScriptProject project = this.createJavaProject("P2");
            IIncludePathEntry entry = JavaScriptCore.newProjectEntry((IPath)new Path("/P1"), null, (boolean)true, (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)false);
            project.setRawIncludepath(new IIncludePathEntry[]{entry}, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P2/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"/P1\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCombineAccessRules3() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P2");
            this.editFile("/P2/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" combineaccessrules=\"false\" path=\"/P1\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n");
            this.assertClasspathEquals(project.getRawIncludepath(), "/P1[CPE_PROJECT][K_SOURCE][isExported:false][combine access rules:false]");
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCombineAccessRules4() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P2");
            this.editFile("/P2/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"/P1\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n");
            this.assertClasspathEquals(project.getRawIncludepath(), "/P1[CPE_PROJECT][K_SOURCE][isExported:false][combine access rules:true]");
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCombineAccessRules5() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P2");
            this.editFile("/P2/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src\"/>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n");
            this.assertClasspathEquals(project.getRawIncludepath(), "/P2/src[CPE_SOURCE][K_SOURCE][isExported:false]");
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCycleDetection() throws CoreException {
        int max = 5;
        IJavaScriptProject[] p = new IJavaScriptProject[max];
        String[] projectNames = new String[max];
        try {
            int i = 0;
            while (i < max) {
                projectNames[i] = "P" + i;
                p[i] = this.createJavaProject(projectNames[i], new String[]{""});
                ++i;
            }
            IIncludePathEntry[][] extraEntries = new IIncludePathEntry[][]{{JavaScriptCore.newProjectEntry((IPath)p[1].getPath()), JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[2].getPath()), JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[1].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[4].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[3].getPath()), JavaScriptCore.newProjectEntry((IPath)p[0].getPath())}};
            int[][] nArrayArray = new int[5][];
            nArrayArray[0] = new int[5];
            nArrayArray[1] = new int[5];
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 1;
            nArrayArray[2] = nArray;
            int[] nArray2 = new int[5];
            nArray2[1] = 1;
            nArray2[2] = 1;
            nArrayArray[3] = nArray2;
            nArrayArray[4] = new int[]{1, 1, 1, 1, 1};
            int[][] expectedCycleParticipants = nArrayArray;
            int i2 = 0;
            while (i2 < p.length) {
                IIncludePathEntry[] oldClasspath = p[i2].getRawIncludepath();
                IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries[i2].length];
                System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                int j = 0;
                while (j < extraEntries[i2].length) {
                    newClasspath[oldClasspath.length + j] = extraEntries[i2][j];
                    ++j;
                }
                p[i2].setRawIncludepath(newClasspath, null);
                this.assertCycleMarkers(p[i2], p, expectedCycleParticipants[i2]);
                ++i2;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    public void testCycleDetectionThroughContainers() throws CoreException {
        int max = 5;
        IJavaScriptProject[] p = new IJavaScriptProject[max];
        String[] projectNames = new String[max];
        try {
            int i = 0;
            while (i < max) {
                projectNames[i] = "P" + i;
                p[i] = this.createJavaProject(projectNames[i], new String[]{""});
                ++i;
            }
            IJsGlobalScopeContainer[] containers = new IJsGlobalScopeContainer[]{new TestContainer((IPath)new Path("container0/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}), new TestContainer((IPath)new Path("container1/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)p[1].getPath())}), new TestContainer((IPath)new Path("container2/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)p[4].getPath())})};
            IIncludePathEntry[][] extraEntries = new IIncludePathEntry[][]{{JavaScriptCore.newProjectEntry((IPath)p[1].getPath()), JavaScriptCore.newContainerEntry((IPath)containers[0].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[2].getPath()), JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}, {JavaScriptCore.newContainerEntry((IPath)containers[1].getPath())}, {JavaScriptCore.newContainerEntry((IPath)containers[2].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[3].getPath()), JavaScriptCore.newProjectEntry((IPath)p[0].getPath())}};
            int[][] expectedCycleParticipants = new int[][]{new int[5], new int[5], new int[5], new int[5], {1, 1, 1, 1, 1}};
            int i2 = 0;
            while (i2 < p.length) {
                IIncludePathEntry[] oldClasspath = p[i2].getRawIncludepath();
                IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries[i2].length];
                System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                int j = 0;
                while (j < extraEntries[i2].length) {
                    newClasspath[oldClasspath.length + j] = extraEntries[i2][j];
                    ++j;
                }
                p[i2].setRawIncludepath(newClasspath, null);
                if (i2 == p.length - 1) {
                    JavaScriptCore.setJsGlobalScopeContainer((IPath)containers[0].getPath(), (IJavaScriptProject[])new IJavaScriptProject[]{p[0]}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{containers[0]}, null);
                    JavaScriptCore.setJsGlobalScopeContainer((IPath)containers[1].getPath(), (IJavaScriptProject[])new IJavaScriptProject[]{p[2]}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{containers[1]}, null);
                    JavaScriptCore.setJsGlobalScopeContainer((IPath)containers[2].getPath(), (IJavaScriptProject[])new IJavaScriptProject[]{p[3]}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{containers[2]}, null);
                }
                this.assertCycleMarkers(p[i2], p, expectedCycleParticipants[i2]);
                ++i2;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    public void testCycleDetectionThroughContainerVariants() throws CoreException {
        int max = 5;
        IJavaScriptProject[] p = new IJavaScriptProject[max];
        String[] projectNames = new String[max];
        try {
            int i = 0;
            while (i < max) {
                projectNames[i] = "P" + i;
                p[i] = this.createJavaProject(projectNames[i], new String[]{""});
                ++i;
            }
            class LocalTestContainer
            implements IJsGlobalScopeContainer {
                IPath path;
                IIncludePathEntry[] entries;

                LocalTestContainer(IPath path, IIncludePathEntry[] entries) {
                    this.path = path;
                    this.entries = entries;
                }

                public IPath getPath() {
                    return this.path;
                }

                public IIncludePathEntry[] getClasspathEntries() {
                    return this.getIncludepathEntries();
                }

                public IIncludePathEntry[] getIncludepathEntries() {
                    return this.entries;
                }

                public String getDescription() {
                    return null;
                }

                public int getKind() {
                    return 0;
                }

                public String[] resolvedLibraryImport(String a) {
                    return new String[]{a};
                }
            }
            IJsGlobalScopeContainer[] containers = new IJsGlobalScopeContainer[]{new LocalTestContainer((IPath)new Path("container0/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}), new LocalTestContainer((IPath)new Path("container0/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)p[1].getPath())}), new LocalTestContainer((IPath)new Path("container0/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)p[4].getPath())})};
            IIncludePathEntry[][] extraEntries = new IIncludePathEntry[][]{{JavaScriptCore.newProjectEntry((IPath)p[1].getPath()), JavaScriptCore.newContainerEntry((IPath)containers[0].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[2].getPath()), JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}, {JavaScriptCore.newContainerEntry((IPath)containers[1].getPath())}, {JavaScriptCore.newContainerEntry((IPath)containers[2].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[3].getPath()), JavaScriptCore.newProjectEntry((IPath)p[0].getPath())}};
            int[][] expectedCycleParticipants = new int[][]{new int[5], new int[5], new int[5], new int[5], {1, 1, 1, 1, 1}};
            int i2 = 0;
            while (i2 < p.length) {
                IIncludePathEntry[] oldClasspath = p[i2].getRawIncludepath();
                IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries[i2].length];
                System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                int j = 0;
                while (j < extraEntries[i2].length) {
                    newClasspath[oldClasspath.length + j] = extraEntries[i2][j];
                    ++j;
                }
                p[i2].setRawIncludepath(newClasspath, null);
                if (i2 == p.length - 1) {
                    JavaScriptCore.setJsGlobalScopeContainer((IPath)containers[0].getPath(), (IJavaScriptProject[])new IJavaScriptProject[]{p[0], p[2], p[3]}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{containers[0], containers[1], containers[2]}, null);
                }
                this.assertCycleMarkers(p[i2], p, expectedCycleParticipants[i2]);
                ++i2;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    public void testCycleDetection2() throws CoreException {
        int max = 5;
        IJavaScriptProject[] p = new IJavaScriptProject[max];
        String[] projectNames = new String[max];
        try {
            int i = 0;
            while (i < max) {
                projectNames[i] = "P" + i;
                p[i] = this.createJavaProject(projectNames[i], new String[]{""});
                ++i;
            }
            IIncludePathEntry[][] extraEntries = new IIncludePathEntry[][]{{JavaScriptCore.newProjectEntry((IPath)p[1].getPath()), JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[2].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[0].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[4].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[0].getPath())}};
            int[][] nArrayArray = new int[5][];
            nArrayArray[0] = new int[5];
            nArrayArray[1] = new int[5];
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            nArrayArray[2] = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            nArrayArray[3] = nArray2;
            nArrayArray[4] = new int[]{1, 1, 1, 1, 1};
            int[][] expectedCycleParticipants = nArrayArray;
            int i2 = 0;
            while (i2 < p.length) {
                IIncludePathEntry[] oldClasspath = p[i2].getRawIncludepath();
                IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries[i2].length];
                System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                int j = 0;
                while (j < extraEntries[i2].length) {
                    newClasspath[oldClasspath.length + j] = extraEntries[i2][j];
                    ++j;
                }
                p[i2].setRawIncludepath(newClasspath, null);
                this.assertCycleMarkers(p[i2], p, expectedCycleParticipants[i2]);
                ++i2;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    public void testCycleDetection3() throws CoreException {
        int max = 6;
        IJavaScriptProject[] p = new IJavaScriptProject[max];
        String[] projectNames = new String[max];
        try {
            int i = 0;
            while (i < max) {
                projectNames[i] = "P" + i;
                p[i] = this.createJavaProject(projectNames[i], new String[]{""});
                ++i;
            }
            IIncludePathEntry[][] extraEntries = new IIncludePathEntry[][]{{JavaScriptCore.newProjectEntry((IPath)p[2].getPath()), JavaScriptCore.newProjectEntry((IPath)p[4].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[0].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[3].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[1].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[5].getPath())}, {JavaScriptCore.newProjectEntry((IPath)p[1].getPath())}};
            int[][] nArrayArray = new int[6][];
            nArrayArray[0] = new int[6];
            nArrayArray[1] = new int[6];
            nArrayArray[2] = new int[6];
            int[] nArray = new int[6];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            nArray[3] = 1;
            nArrayArray[3] = nArray;
            int[] nArray2 = new int[6];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            nArray2[3] = 1;
            nArrayArray[4] = nArray2;
            nArrayArray[5] = new int[]{1, 1, 1, 1, 1, 1};
            int[][] expectedCycleParticipants = nArrayArray;
            int i2 = 0;
            while (i2 < p.length) {
                IIncludePathEntry[] oldClasspath = p[i2].getRawIncludepath();
                IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries[i2].length];
                System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                int j = 0;
                while (j < extraEntries[i2].length) {
                    newClasspath[oldClasspath.length + j] = extraEntries[i2][j];
                    ++j;
                }
                p[i2].setRawIncludepath(newClasspath, null);
                this.assertCycleMarkers(p[i2], p, expectedCycleParticipants[i2]);
                ++i2;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    public void testCycleDetection4() throws CoreException {
        IResourceChangeListener listener = new IResourceChangeListener(){
            boolean containerNeedUpdate = true;

            public void resourceChanged(IResourceChangeEvent event) {
                if (this.containerNeedUpdate) {
                    TestContainer container = new TestContainer((IPath)new Path("org.eclipse.wst.jsdt.core.tests.model.container/default"), new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)new Path("/P1"))});
                    try {
                        JavaScriptCore.setJsGlobalScopeContainer((IPath)container.getPath(), (IJavaScriptProject[])new IJavaScriptProject[]{ClasspathTests.this.getJavaProject("P2")}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{container}, null);
                    }
                    catch (JavaScriptModelException e) {
                        e.printStackTrace();
                    }
                    this.containerNeedUpdate = false;
                }
            }
        };
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[0], new String[]{"/P2"});
            TestContainer container = new TestContainer((IPath)new Path("org.eclipse.wst.jsdt.core.tests.model.container/default"), new IIncludePathEntry[0]);
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{container.getPath().toString()});
            JavaScriptCore.setJsGlobalScopeContainer((IPath)container.getPath(), (IJavaScriptProject[])new IJavaScriptProject[]{p2}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{container}, null);
            ClasspathTests.waitForAutoBuild();
            this.getWorkspace().addResourceChangeListener(listener, 1);
            this.createFile("/P1/test.txt", "");
            this.assertCycleMarkers(p1, new IJavaScriptProject[]{p1, p2}, new int[]{1, 1});
        }
        catch (Throwable throwable) {
            this.getWorkspace().removeResourceChangeListener(listener);
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.getWorkspace().removeResourceChangeListener(listener);
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testPerfDenseCycleDetection1() throws CoreException {
        this.denseCycleDetection(5);
    }

    public void testPerfDenseCycleDetection2() throws CoreException {
        this.denseCycleDetection(10);
    }

    public void testPerfDenseCycleDetection3() throws CoreException {
        this.denseCycleDetection(20);
    }

    public void testNoCycleDetection1() throws CoreException {
        this.noCycleDetection(5, false, false);
        this.noCycleDetection(10, false, false);
        this.noCycleDetection(20, false, false);
        this.noCycleDetection(5, true, false);
        this.noCycleDetection(10, true, false);
        this.noCycleDetection(20, true, false);
    }

    public void testNoCycleDetection2() throws CoreException {
        this.noCycleDetection(5, false, true);
        this.noCycleDetection(10, false, true);
        this.noCycleDetection(20, false, true);
        this.noCycleDetection(5, true, true);
        this.noCycleDetection(10, true, true);
        this.noCycleDetection(20, true, true);
    }

    public void testNoResourceChange01() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1"});
            IIncludePathEntry[] newClasspath = this.createClasspath("P", new String[]{"/P/src2", ""});
            project.setRawIncludepath(newClasspath, false, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src1\"/>\n   <classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.launching.JRE_CONTAINER\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNoResourceChange02() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1"});
            IIncludePathEntry[] newClasspath = this.createClasspath("P", new String[]{"/P/src2", ""});
            project.setRawIncludepath(newClasspath, false, null);
            this.assertClasspathEquals(project.getRawIncludepath(), "/P/src2[CPE_SOURCE][K_SOURCE][isExported:false]");
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNoResourceChange03() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1"});
            this.createFile("/P/src1/X.js", "public class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src1/X.js");
            cu.open(null);
            IIncludePathEntry[] newClasspath = this.createClasspath("P", new String[]{"/P/src2", ""});
            project.setRawIncludepath(newClasspath, false, null);
            ClasspathTests.assertFalse((String)"Compilation unit should not exist", (boolean)cu.exists());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNoResourceChange04() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1"});
            this.createFolder("/P/src2");
            IIncludePathEntry[] newClasspath = this.createClasspath("P", new String[]{"/P/src2", ""});
            this.startDeltas();
            project.setRawIncludepath(newClasspath, false, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CLASSPATH CHANGED}\n\tsrc1[*]: {REMOVED FROM CLASSPATH}\n\tsrc2[*]: {ADDED TO CLASSPATH}");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testNoResourceChange05() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1"});
            project.setRawIncludepath(project.getRawIncludepath(), false, null);
            IIncludePathEntry[] entries = project.readRawIncludepath();
            ClasspathTests.assertEquals((String)"/P/src2", (String)entries[0].getPath().toString());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testDuplicateEntries() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            this.assertMarkers("Unexpected markers", "Build path contains duplicate entry: 'src' for project P", project);
        }
        finally {
            this.deleteProject("P");
        }
    }

    private void denseCycleDetection(final int numberOfParticipants) throws CoreException {
        final IJavaScriptProject[] projects = new IJavaScriptProject[numberOfParticipants];
        final String[] projectNames = new String[numberOfParticipants];
        final int[] allProjectsInCycle = new int[numberOfParticipants];
        try {
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < numberOfParticipants) {
                        projectNames[i] = "P" + i;
                        projects[i] = ClasspathTests.this.createJavaProject(projectNames[i], new String[]{""});
                        allProjectsInCycle[i] = 1;
                        ++i;
                    }
                    i = 0;
                    while (i < numberOfParticipants) {
                        IIncludePathEntry[] extraEntries = new IIncludePathEntry[numberOfParticipants - 1];
                        int index = 0;
                        int j = 0;
                        while (j < numberOfParticipants) {
                            if (i != j) {
                                extraEntries[index++] = JavaScriptCore.newProjectEntry((IPath)projects[j].getPath());
                            }
                            ++j;
                        }
                        IIncludePathEntry[] oldClasspath = projects[i].getRawIncludepath();
                        IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries.length];
                        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                        int j2 = 0;
                        while (j2 < extraEntries.length) {
                            newClasspath[oldClasspath.length + j2] = extraEntries[j2];
                            ++j2;
                        }
                        projects[i].setRawIncludepath(newClasspath, null);
                        ++i;
                    }
                }
            }, null);
            int i = 0;
            while (i < numberOfParticipants) {
                this.assertCycleMarkers(projects[i], projects, allProjectsInCycle);
                ++i;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    private void noCycleDetection(final int numberOfParticipants, final boolean useForwardReferences, final boolean createProjectsFirst) throws CoreException {
        final IJavaScriptProject[] projects = new IJavaScriptProject[numberOfParticipants];
        final String[] projectNames = new String[numberOfParticipants];
        final int[] allProjectsInCycle = new int[numberOfParticipants];
        final long[] start = new long[1];
        final long[] time = new long[1];
        try {
            if (createProjectsFirst) {
                JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        int i = 0;
                        while (i < numberOfParticipants) {
                            projectNames[i] = "P" + i;
                            projects[i] = ClasspathTests.this.createJavaProject(projectNames[i], new String[]{""});
                            allProjectsInCycle[i] = 0;
                            ++i;
                        }
                    }
                }, null);
            }
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i;
                    if (!createProjectsFirst) {
                        i = 0;
                        while (i < numberOfParticipants) {
                            projectNames[i] = "P" + i;
                            projects[i] = ClasspathTests.this.createJavaProject(projectNames[i], new String[]{""});
                            allProjectsInCycle[i] = 0;
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < numberOfParticipants) {
                        IIncludePathEntry[] extraEntries = new IIncludePathEntry[useForwardReferences ? numberOfParticipants - i - 1 : i];
                        int index = 0;
                        int j = useForwardReferences ? i + 1 : 0;
                        while (!(useForwardReferences ? j >= numberOfParticipants : j >= i)) {
                            extraEntries[index++] = JavaScriptCore.newProjectEntry((IPath)projects[j].getPath());
                            ++j;
                        }
                        IIncludePathEntry[] oldClasspath = projects[i].getRawIncludepath();
                        IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldClasspath.length + extraEntries.length];
                        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                        int j2 = 0;
                        while (j2 < extraEntries.length) {
                            newClasspath[oldClasspath.length + j2] = extraEntries[j2];
                            ++j2;
                        }
                        long innerStart = System.currentTimeMillis();
                        projects[i].setRawIncludepath(newClasspath, null);
                        time[0] = time[0] + (System.currentTimeMillis() - innerStart);
                        ++i;
                    }
                    start[0] = System.currentTimeMillis();
                }
            }, null);
            time[0] = time[0] + (System.currentTimeMillis() - start[0]);
            int i = 0;
            while (i < numberOfParticipants) {
                this.assertCycleMarkers(projects[i], projects, allProjectsInCycle);
                ++i;
            }
        }
        finally {
            this.deleteProjects(projectNames);
        }
    }

    public void testNestedSourceFolders() throws CoreException, IOException {
        try {
            final IProject project = this.getProject("P");
            IWorkspaceRunnable create = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(null, null);
                    project.open(null);
                }
            };
            this.getWorkspace().run(create, null);
            File pro = project.getLocation().toFile();
            File src = this.createFolder(pro, "src");
            this.createFolder(src, "src2");
            this.createFile(pro, ".project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>org.eclipse.wst.jsdt.core</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.wst.jsdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.wst.jsdt.core.javanature</nature>\n\t</natures>\n</projectDescription>");
            this.createFile(pro, ".classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"src\" path=\"src/src2\"/>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            project.refreshLocal(2, null);
            this.assertMarkers("Unexpected markers", "Cannot nest 'P/src/src2' inside 'P/src'. To enable the nesting exclude 'src2/' from 'P/src'", JavaScriptCore.create((IProject)project));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testOptionalEntry1() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("A", new String[0]);
            IIncludePathAttribute attribute = JavaScriptCore.newIncludepathAttribute((String)"optional", (String)"true");
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/A/src"), (IPath[])new IPath[0], (IPath[])new IPath[0], (IPath)new Path("/A/bin"), (IIncludePathAttribute[])new IIncludePathAttribute[]{attribute})};
            javaProject.setRawIncludepath(classpath, null);
            this.assertMarkers("Unexpected markers", "", javaProject);
        }
        finally {
            this.deleteProject("A");
        }
    }

    public void testOptionalEntry2() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("A", new String[0]);
            IIncludePathAttribute attribute = JavaScriptCore.newIncludepathAttribute((String)"optional", (String)"true");
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)new Path("/A/lib"), null, null, null, (IIncludePathAttribute[])new IIncludePathAttribute[]{attribute}, (boolean)false)};
            javaProject.setRawIncludepath(classpath, null);
            this.assertMarkers("Unexpected markers", "", javaProject);
        }
        finally {
            this.deleteProject("A");
        }
    }

    public void testOptionalEntry3() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("A", new String[0]);
            IIncludePathAttribute attribute = JavaScriptCore.newIncludepathAttribute((String)"optional", (String)"true");
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)new Path("/B"), null, (boolean)false, (IIncludePathAttribute[])new IIncludePathAttribute[]{attribute}, (boolean)false)};
            javaProject.setRawIncludepath(classpath, null);
            this.assertMarkers("Unexpected markers", "", javaProject);
        }
        finally {
            this.deleteProject("A");
        }
    }

    public void testReplaceProject() throws CoreException {
        try {
            final IJavaScriptProject javaProject = this.createJavaProject("P", new String[]{"src"});
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IProjectDescription descr = javaProject.getProject().getDescription();
                    descr.setComment("dummy");
                    javaProject.getProject().setDescription(descr, monitor);
                    ClasspathTests.this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src2\"/>\n</classpath>");
                }
            }, null);
            IIncludePathEntry[] classpath = javaProject.getRawIncludepath();
            ClasspathTests.assertEquals((String)"classpath should have been refreshed", (Object)new Path("/P/src2"), (Object)classpath[0].getPath());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnknownAttributes() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry unknown=\"test\" kind=\"src\" path=\"src1\"/>\n\t<classpathentry kind=\"src\" path=\"src2\"/>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n");
            IIncludePathEntry[] classpath = project.getRawIncludepath();
            IIncludePathEntry src1 = classpath[0];
            classpath[0] = classpath[1];
            classpath[1] = src1;
            project.setRawIncludepath(classpath, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src2\"/>\n\t<classpathentry kind=\"src\" path=\"src1\" unknown=\"test\"/>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnknownElements1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src1\">\n\t\t<unknown>\n\t\t\t<test kind=\"\"/>\n\t\t</unknown>\n\t</classpathentry>\n\t<classpathentry kind=\"src\" path=\"src2\"/>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n");
            IIncludePathEntry[] classpath = project.getRawIncludepath();
            IIncludePathEntry src1 = classpath[0];
            classpath[0] = classpath[1];
            classpath[1] = src1;
            project.setRawIncludepath(classpath, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src2\"/>\n\t<classpathentry kind=\"src\" path=\"src1\">\n\t\t<unknown>\n\t\t\t<test kind=\"\"/>\n\t\t</unknown>\n\t</classpathentry>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnknownElements2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            this.editFile("/P/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" unknownattribute=\"abcde\" path=\"src1\">\n\t\t<unknown1>\n\t\t\t<test kind=\"1\"/>\n\t\t\t<test kind=\"2\"/>\n\t\t</unknown1>\n\t\t<unknown2 attribute2=\"\">\n\t\t\t<test>\n\t\t\t\t<other a=\"b\"/>\n\t\t\t</test>\n\t\t</unknown2>\n\t</classpathentry>\n\t<classpathentry kind=\"src\" path=\"src2\"/>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n");
            IIncludePathEntry[] classpath = project.getRawIncludepath();
            IIncludePathEntry src1 = classpath[0];
            classpath[0] = classpath[1];
            classpath[1] = src1;
            project.setRawIncludepath(classpath, null);
            String contents = new String(org.eclipse.wst.jsdt.internal.core.util.Util.getResourceContentsAsCharArray((IFile)this.getFile("/P/.settings/.jsdtscope")));
            this.assertSourceEquals("Unexpected content", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src2\"/>\n\t<classpathentry kind=\"src\" path=\"src1\" unknownattribute=\"abcde\">\n\t\t<unknown1>\n\t\t\t<test kind=\"1\"/>\n\t\t\t<test kind=\"2\"/>\n\t\t</unknown1>\n\t\t<unknown2 attribute2=\"\">\n\t\t\t<test>\n\t\t\t\t<other a=\"b\"/>\n\t\t\t</test>\n\t\t</unknown2>\n\t</classpathentry>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>\n", contents);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testBug55992a() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[0]);
            IPath path = this.getExternalJCLPath("");
            Path sourceAttachmentPath = new Path("jclMin.zip");
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"TEST_LIB", "TEST_SRC"}, (IPath[])new IPath[]{path, sourceAttachmentPath}, null);
            ClasspathEntry cp = new ClasspathEntry(1, 4, (IPath)new Path("TEST_LIB"), ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, (IPath)new Path("TEST_SRC"), null, null, false, null, false, ClasspathEntry.NO_EXTRA_ATTRIBUTES);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)proj, (IIncludePathEntry)cp, (boolean)false);
            ClasspathTests.assertEquals((String)"assertion failed: Source attachment path 'jclMin.zip' for IIncludePathEntry must be absolute", (String)status.getMessage());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testRemoveDuplicates() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{""});
            IIncludePathEntry[] p1ClasspathEntries = new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)this.getExternalJCLPath(""), null, null, (boolean)true)};
            this.setClasspath(p1, p1ClasspathEntries);
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""});
            IIncludePathEntry[] p2ClasspathEntries = new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)new Path("/P1")), JavaScriptCore.newLibraryEntry((IPath)this.getExternalJCLPath(""), null, null, (boolean)false)};
            this.setClasspath(p2, p2ClasspathEntries);
            IIncludePathEntry[] classpath = ((JavaProject)p2).getExpandedClasspath();
            ClasspathTests.assertEquals((String)"Unexpected number of classpath entries", (int)2, (int)classpath.length);
            ClasspathTests.assertEquals((String)"Unexpected first entry", (String)"/P1", (String)classpath[0].getPath().toString());
            ClasspathTests.assertEquals((String)"Unexpected second entry", (String)this.getSystemJsPathString(), (String)classpath[1].getPath().toOSString());
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public class TestContainer
    implements IJsGlobalScopeContainer {
        IPath path;
        IIncludePathEntry[] entries;

        TestContainer(IPath path, IIncludePathEntry[] entries) {
            this.path = path;
            this.entries = entries;
        }

        public IPath getPath() {
            return this.path;
        }

        public IIncludePathEntry[] getClasspathEntries() {
            return this.getIncludepathEntries();
        }

        public IIncludePathEntry[] getIncludepathEntries() {
            return this.entries;
        }

        public String getDescription() {
            return this.path.toString();
        }

        public int getKind() {
            return 0;
        }

        public String[] resolvedLibraryImport(String a) {
            return new String[]{a};
        }
    }
}

