/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jst.pagedesigner.commands.range.WorkNode;
import org.eclipse.jst.pagedesigner.css2.CSSUtil;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class DesignEdit {
    private Stack _selections;
    private DOMRange _range;
    private GraphicalViewer _viewer;
    private IDOMPosition _operationPosition;
    private final Document _document;
    private Stack _processedResult;

    public DesignEdit(DOMRange range, GraphicalViewer viewer) {
        this.setRange(range);
        this._viewer = viewer;
        this._operationPosition = this.getRange().getStartPosition();
        this._document = ((IDOMNode)this._operationPosition.getContainerNode()).getModel().getDocument();
    }

    protected final Document getDocument() {
        return this._document;
    }

    protected abstract boolean operate();

    protected abstract Text processText(WorkNode var1);

    protected abstract Node processNode(WorkNode var1);

    protected abstract Node processContainer(WorkNode var1);

    public DOMRange getRange() {
        return this._range;
    }

    void setRange(DOMRange range) {
        range = EditHelper.normal(range);
        IDOMPosition start = EditHelper.ensureDOMPosition(range.getStartPosition());
        IDOMPosition end = EditHelper.ensureDOMPosition(range.getEndPosition());
        this._range = new DOMRange(start, end);
        EditValidateUtil.validRange(range);
    }

    protected Clipboard getClipboard() {
        return new Clipboard(this._viewer.getControl().getDisplay());
    }

    public IDOMPosition getOperationPosition() {
        return this._operationPosition;
    }

    protected void setOperationPosition(IDOMPosition position) {
        if (!EditValidateUtil.validPosition(position)) {
            return;
        }
        this._operationPosition = position = EditHelper.ensureDOMPosition(position);
    }

    public boolean perform() {
        boolean result = false;
        result = this.operate();
        return result;
    }

    public GraphicalViewer getViewer() {
        return this._viewer;
    }

    private Stack collectNodes() {
        Stack<WorkNode> result = new Stack<WorkNode>();
        IDOMPosition start = this.getRange().getStartPosition();
        IDOMPosition end = this.getRange().getEndPosition();
        int[] pos = new int[]{EditModelQuery.getIndexedRegionLocation(start), EditModelQuery.getIndexedRegionLocation(end)};
        if (!EditModelQuery.isSame(start, end)) {
            Node ancestor = EditModelQuery.getInstance().getCommonAncestor(start, end);
            WorkNode rootWorkNode = new WorkNode(ancestor, pos[0], pos[1]);
            rootWorkNode.setRoot(true);
            result.push(rootWorkNode);
            try {
                if (EditModelQuery.isText(ancestor)) {
                    Stack temp = new Stack();
                    EditHelper.getInstance().collectNodes(ancestor, pos[0], pos[1], ancestor, temp);
                    WorkNode wNode = (WorkNode)temp.remove(0);
                    wNode.setParent(rootWorkNode);
                    result.push(wNode);
                } else {
                    Node node = ancestor.getFirstChild();
                    Stack temp = new Stack();
                    while (node != null) {
                        EditHelper.getInstance().collectNodes(node, pos[0], pos[1], ancestor, temp);
                        while (temp.size() > 0) {
                            WorkNode wNode = (WorkNode)temp.remove(0);
                            if (wNode.getNode().getParentNode() == ancestor) {
                                wNode.setParent(rootWorkNode);
                            }
                            result.push(wNode);
                        }
                        node = node.getNextSibling();
                    }
                }
            }
            catch (Exception exception) {
                result.clear();
            }
        }
        return result;
    }

    public Stack getSelections() {
        if (this._selections == null) {
            this._selections = this.collectNodes();
        }
        return this._selections;
    }

    public Stack getProcessedResult() {
        if (this._processedResult == null) {
            this._processedResult = new Stack();
            WorkNode rootNode = this.getRootWorkNode();
            if (rootNode != null) {
                this.processNodes(rootNode, this._processedResult);
            }
        }
        return this._processedResult;
    }

    protected final WorkNode getRootWorkNode() {
        WorkNode result = null;
        if (this.getSelections().size() > 0) {
            WorkNode node = (WorkNode)this.getSelections().get(0);
            while (node.getParent() != null) {
                node = node.getParent();
            }
            result = node;
            Assert.isTrue((boolean)node.isRoot());
        }
        return result;
    }

    private final boolean processText(WorkNode node, Stack result) {
        boolean done = false;
        if (EditModelQuery.isText(node.getNode())) {
            Text text = this.processText(node);
            if (text != null) {
                result.add(text);
            }
            this.getSelections().remove(node);
            done = true;
        }
        return done;
    }

    private final void processContainer(WorkNode node, Stack result) {
        this.processContainer(node);
        this.getSelections().remove(node);
    }

    private final boolean processChildren(WorkNode node, Stack result) {
        boolean done = false;
        if (this.getFirstSelectedChild(node) != null) {
            Stack myResult = new Stack();
            WorkNode child = null;
            while ((child = this.getFirstSelectedChild(node)) != null) {
                this.processNodes(child, myResult);
            }
            Node newParent = this.processContainer(node);
            newParent = this.toBeParent(newParent, myResult);
            result.push(newParent);
            this.getSelections().remove(node);
            done = true;
        }
        return done;
    }

    private final boolean processChildren1(WorkNode node, Stack result) {
        boolean done = false;
        if (node.getNode().hasChildNodes()) {
            Stack myResult = new Stack();
            Node childNode = node.getNode().getFirstChild();
            Node next = null;
            while (childNode != null) {
                next = childNode.getNextSibling();
                int x1 = EditModelQuery.getNodeStartIndex(childNode) - 1;
                int x2 = EditModelQuery.getNodeEndIndex(childNode) + 1;
                this.processNodes(new WorkNode(childNode, x1, x2), myResult);
                childNode = next;
            }
            Node newParent = this.processContainer(node);
            newParent = this.toBeParent(newParent, myResult);
            result.push(newParent);
            this.getSelections().remove(node);
            done = true;
        }
        return done;
    }

    protected final void processNodes(WorkNode node, Stack result) {
        WorkNode child = null;
        if (node.isRoot()) {
            while ((child = this.getFirstSelectedChild(node)) != null) {
                this.processNodes(child, result);
            }
        } else if (node.isWholeSelected() || !EditModelQuery.isText(node.getNode()) && EditModelQuery.getInstance().isSingleRegionNode(node.getNode()) || EditModelQuery.isWidget(node.getNode())) {
            Node temp = this.processNode(node);
            if (temp != null) {
                result.push(temp);
                this.getSelections().remove(node);
            } else if (!this.processText(node, result) && !this.processChildren1(node, result)) {
                this.processContainer(node, result);
            }
        } else if (!this.processText(node, result) && !this.processChildren(node, result)) {
            this.processContainer(node, result);
        }
    }

    protected void setClipboard(Stack result) {
        Node[] nodes = result.toArray(new Node[result.size()]);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int size = nodes.length;
        while (i < size) {
            DOMUtil.nodeToString(nodes[i], sb);
            ++i;
        }
        this.getClipboard().setContents(new Object[]{result, sb.toString()}, new Transfer[]{TemplateTransfer.getInstance(), TextTransfer.getInstance()});
    }

    private Node toBeParent(Node parent, Stack children) {
        while (children.size() > 0) {
            parent.appendChild((Node)children.remove(0));
        }
        return parent;
    }

    private WorkNode getFirstSelectedChild(WorkNode node) {
        int i = 0;
        int n = this.getSelections().size();
        while (i < n) {
            WorkNode wNode = (WorkNode)this.getSelections().get(i);
            if (wNode.getParent() == node) {
                return wNode;
            }
            ++i;
        }
        return null;
    }

    Node collectStyleNodes(Node rootNode, Vector result) {
        Element element = null;
        if (rootNode instanceof Element) {
            element = (Element)rootNode;
        } else if (rootNode.getParentNode() != null) {
            element = (Element)rootNode.getParentNode();
        }
        ICSSStyle style = CSSUtil.getCSSStyle(element);
        Element node = EditModelQuery.getDocumentNode(rootNode).createElement("span");
        int i = 0;
        int n = result.size();
        while (i < n) {
            node.appendChild((Node)result.elementAt(i));
            ++i;
        }
        node.setAttribute("style", CSSUtil.resolveCSSStyle(style));
        result.removeAllElements();
        result.add(node);
        return node;
    }

    protected final Node collectOtherStyles(Node rootNode, Vector result) {
        Node cur = rootNode;
        Node prev = null;
        Node appendPoint = null;
        if (EditValidateUtil.validNode(rootNode)) {
            while (!EditModelQuery.isDocument(cur)) {
                String name;
                if (!EditValidateUtil.validNode(cur)) {
                    return null;
                }
                String string = name = cur.getNodeName() != null ? cur.getNodeName().toLowerCase() : "";
                if (EditModelQuery.HTML_STYLE_NODES.contains(name)) {
                    if (prev != null) {
                        Node newone = cur.cloneNode(false);
                        newone.appendChild(prev);
                        prev = newone;
                    } else {
                        appendPoint = prev = cur.cloneNode(false);
                    }
                }
                cur = cur.getParentNode();
            }
            if (appendPoint != null) {
                int i = 0;
                int n = result.size();
                while (i < n) {
                    appendPoint.appendChild((Node)result.elementAt(i));
                    ++i;
                }
                result.removeAllElements();
                result.add(prev);
            }
        }
        return prev;
    }
}

