/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaLibraries;
import org.eclipse.jst.servlet.ui.internal.navigator.ICompressedNode;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.plugin.WEBUIMessages;
import org.eclipse.swt.graphics.Image;

public class CompressedJavaProject
implements ICompressedNode,
IAdaptable {
    private IProject project;
    private CompressedJavaLibraries compressedLibraries;
    private Image image;

    public CompressedJavaProject(StructuredViewer viewer, IProject project) {
        this.project = project;
    }

    @Override
    public Image getImage() {
        if (this.image == null) {
            this.image = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif");
        }
        return this.image;
    }

    @Override
    public String getLabel() {
        return this.determineLabel();
    }

    public boolean isFlatteningSourceFolder() {
        return this.getNonExternalSourceFolders().size() == 1;
    }

    private String determineLabel() {
        return WEBUIMessages.Compressed_JavaResources;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public Object[] getChildren(ITreeContentProvider delegateContentProvider) {
        List nonExternalSourceFolders = this.getNonExternalSourceFolders();
        nonExternalSourceFolders.add(this.getCompressedJavaLibraries());
        return nonExternalSourceFolders.toArray();
    }

    public List getNonExternalSourceFolders() {
        ArrayList<IPackageFragmentRoot> nonExternalSourceFolders = null;
        try {
            IJavaProject jProject = JavaCore.create((IProject)this.project);
            IPackageFragmentRoot[] sourceFolders = jProject.getPackageFragmentRoots();
            nonExternalSourceFolders = new ArrayList<IPackageFragmentRoot>(Arrays.asList(sourceFolders));
            Iterator iter = nonExternalSourceFolders.iterator();
            while (iter.hasNext()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)iter.next();
                if (!root.isExternal() && !root.isArchive() && root.getKind() != 2) continue;
                iter.remove();
            }
        }
        catch (JavaModelException e) {
            ServletUIPlugin.log((Exception)((Object)e));
        }
        return nonExternalSourceFolders != null ? nonExternalSourceFolders : Collections.EMPTY_LIST;
    }

    public CompressedJavaLibraries getCompressedJavaLibraries() {
        if (this.compressedLibraries == null) {
            this.compressedLibraries = new CompressedJavaLibraries(this);
        }
        return this.compressedLibraries;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IJavaElement getJavaElement() {
        List nonExternalSourceFolders = this.getNonExternalSourceFolders();
        if (nonExternalSourceFolders.size() == 1) {
            return (IJavaElement)nonExternalSourceFolders.get(0);
        }
        return JavaCore.create((IProject)this.project);
    }
}

