/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.EclipseLinkSourceNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConverterAnnotation;

public final class EclipseLinkSourceConverterAnnotation
extends EclipseLinkSourceNamedConverterAnnotation
implements ConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Converter");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Converters");
    private final DeclarationAnnotationElementAdapter<String> converterClassDeclarationAdapter = this.buildConverterDeclarationClassAdapter();
    private final AnnotationElementAdapter<String> converterClassAdapter = this.buildConverterClassAdapter();
    private String converterClass;
    private TextRange converterClassTextRange;
    private String fullyQualifiedConverterClassName;
    private boolean fqConverterClassNameStale = true;

    public static EclipseLinkSourceConverterAnnotation buildSourceConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, int index) {
        IndexedDeclarationAnnotationAdapter idaa = EclipseLinkSourceConverterAnnotation.buildConverterDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = EclipseLinkSourceConverterAnnotation.buildConverterAnnotationAdapter(element, idaa);
        return new EclipseLinkSourceConverterAnnotation(parent, element, idaa, iaa);
    }

    public EclipseLinkSourceConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.converterClass = this.buildConverterClass(astAnnotation);
        this.converterClassTextRange = this.buildConverterClassTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncConverterClass(this.buildConverterClass(astAnnotation));
        this.converterClassTextRange = this.buildConverterClassTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.converterClass == null;
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        if (ObjectTools.notEquals((Object)this.converterClass, (Object)converterClass)) {
            this.converterClass = converterClass;
            this.fqConverterClassNameStale = true;
            this.converterClassAdapter.setValue((Object)converterClass);
        }
    }

    private void syncConverterClass(String astConverterClass) {
        if (ObjectTools.notEquals((Object)this.converterClass, (Object)astConverterClass)) {
            this.syncConverterClass_(astConverterClass);
        }
    }

    private void syncConverterClass_(String astConverterClass) {
        String old = this.converterClass;
        this.converterClass = astConverterClass;
        this.fqConverterClassNameStale = true;
        this.firePropertyChanged("converterClass", old, astConverterClass);
    }

    private String buildConverterClass(Annotation astAnnotation) {
        return (String)this.converterClassAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getConverterClassTextRange() {
        return this.converterClassTextRange;
    }

    private TextRange buildConverterClassTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.converterClassDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildConverterDeclarationClassAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "converterClass", SimpleTypeStringExpressionConverter.instance());
    }

    private AnnotationElementAdapter<String> buildConverterClassAdapter() {
        return this.buildStringElementAdapter(this.converterClassDeclarationAdapter);
    }

    @Override
    public String getFullyQualifiedConverterClassName() {
        if (this.fqConverterClassNameStale) {
            this.fullyQualifiedConverterClassName = this.buildFullyQualifiedConverterClassName();
            this.fqConverterClassNameStale = false;
        }
        return this.fullyQualifiedConverterClassName;
    }

    private String buildFullyQualifiedConverterClassName() {
        return this.converterClass == null ? null : this.buildFullyQualifiedConverterClassName_();
    }

    private String buildFullyQualifiedConverterClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.converterClassAdapter.getExpression(this.buildASTRoot()));
    }

    private static IndexedAnnotationAdapter buildConverterAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildConverterDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.eclipse.persistence.annotations.Converter");
        return idaa;
    }
}

