/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.CommonResourceDialog;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.IPreExecuteCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowValidation;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class CreateNodeCommand
extends Command
implements IPreExecuteCommand {
    private static final String UNNAMED_NODE = "unnamed";
    private PageflowNode child;
    private Rectangle rect;
    private Pageflow parent;

    public CreateNodeCommand() {
        super(PageflowMessages.Pageflow_Commands_CreateNodeCommand_Label);
    }

    public boolean canExecute() {
        return this.child != null && this.parent != null;
    }

    public void execute() {
        if (this.rect != null) {
            this.child.setX(this.rect.x);
            this.child.setY(this.rect.y);
            if (!this.rect.isEmpty()) {
                this.child.setHeight(this.rect.getSize().height);
                this.child.setWidth(this.rect.getSize().width);
            }
        }
        if (this.child.getName() == UNNAMED_NODE) {
            this.child.setName(this.parent.getDefaultNodeName(this.child.getClass()));
        }
        this.parent.getNodes().add((Object)this.child);
    }

    public void redo() {
        if (this.rect != null) {
            this.child.setX(this.rect.x);
            this.child.setY(this.rect.y);
            if (!this.rect.isEmpty()) {
                this.child.setHeight(this.rect.getSize().height);
                this.child.setWidth(this.rect.getSize().width);
            }
        }
        this.parent.getNodes().add((Object)this.child);
    }

    public void undo() {
        this.parent.getNodes().remove((Object)this.child);
    }

    private boolean selectJSPPage() {
        IFile jspFile;
        Object[] result;
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EditorPlugin.getActiveWorkbenchWindow();
        shell = workbenchWindow.getShell() != null ? workbenchWindow.getShell() : new Shell();
        IProject project = WebrootUtil.getProject(this.getParent());
        CommonResourceDialog dialog = new CommonResourceDialog(shell, project, 0);
        dialog.setTitle(PageflowMessages.Pageflow_Commands_CreateNodeCommand_SelectJSPDialog_Title);
        dialog.setSuffixs(null);
        dialog.setResourceDescription(PageflowMessages.Pageflow_Commands_CreateNodeCommand_SelectJSPDialog_Description);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && (jspFile = (IFile)result[0]) != null) {
            String jsfSelection = WebrootUtil.getWebPath((IPath)jspFile.getFullPath());
            if (jsfSelection != null && jsfSelection.length() > 0) {
                if (PageflowValidation.getInstance().isExistedPage(this.parent, jsfSelection)) {
                    EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.DNDResourceTitle", "Pageflow.PageflowEditor.Alert.ExistingPage", (Object)jsfSelection);
                    return false;
                }
                ((PageflowPage)this.child).setPath(jsfSelection);
                ((PageflowPage)this.child).setName(WebrootUtil.getPageNameFromWebPath((String)jsfSelection));
            }
            return true;
        }
        return false;
    }

    public Pageflow getParent() {
        return this.parent;
    }

    public void setChild(PageflowNode subpart) {
        this.child = subpart;
    }

    public void setLocation(Rectangle r) {
        this.rect = r;
    }

    public void setParent(Pageflow newParent) {
        this.parent = newParent;
    }

    @Override
    public boolean preExecute() {
        if (this.child instanceof PageflowPage) {
            if (((PageflowPage)this.child).getPath() != null) {
                if (PageflowValidation.getInstance().isExistedPage(this.parent, (PageflowPage)this.child)) {
                    EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.DNDResourceTitle", "Pageflow.PageflowEditor.Alert.ExistingPage", (Object)((PageflowPage)this.child).getPath());
                    return false;
                }
            } else {
                return this.selectJSPPage();
            }
        }
        return true;
    }
}

