/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;

public class TypeHierarchyTransferDropAdapter
extends SelectionTransferDropAdapter {
    private static final int OPERATION = 4;
    private TypeHierarchyViewPart fTypeHierarchyViewPart;

    public TypeHierarchyTransferDropAdapter(TypeHierarchyViewPart viewPart, AbstractTreeViewer viewer) {
        super((StructuredViewer)viewer);
        this.setFullWidthMatchesItem(false);
        this.fTypeHierarchyViewPart = viewPart;
    }

    @Override
    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        this.initializeSelection();
        if (target != null) {
            super.validateDrop(target, event, operation);
            return;
        }
        if (TypeHierarchyTransferDropAdapter.getInputElement(this.getSelection()) != null) {
            event.detail = 4;
        }
    }

    @Override
    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    @Override
    public void drop(Object target, DropTargetEvent event) {
        if (target != null || event.detail != 4) {
            super.drop(target, event);
            return;
        }
        IJavaScriptElement input = TypeHierarchyTransferDropAdapter.getInputElement(this.getSelection());
        this.fTypeHierarchyViewPart.setInputElement(input);
    }

    private static IJavaScriptElement getInputElement(ISelection selection) {
        Object single = SelectionUtil.getSingleElement(selection);
        if (single == null) {
            return null;
        }
        IJavaScriptElement[] candidates = OpenTypeHierarchyUtil.getCandidates(single);
        if (candidates != null && candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }
}

