/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.debug.core.tests;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;

public class DebugEventWaiter
implements IDebugEventSetListener {
    protected int fEventType;
    protected long fTimeout;
    protected DebugPlugin fDebugPlugin = DebugPlugin.getDefault();
    protected DebugEvent fEvent;
    protected DebugEvent[] fEventSet;
    public static final long DEFAULT_TIMEOUT = 15000L;

    public DebugEventWaiter(int eventType) {
        this.fEventType = eventType;
        this.fTimeout = 15000L;
        this.fDebugPlugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    public boolean accept(DebugEvent event) {
        return event.getKind() == this.fEventType && event.getDetail() != 128;
    }

    public String getEventKindName() {
        switch (this.fEventType) {
            case 4: {
                return "Create";
            }
            case 8: {
                return "Terminate";
            }
            case 1: {
                return "Resume";
            }
            case 2: {
                return "Suspend";
            }
        }
        return "UNKNOWN";
    }

    public synchronized void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            if (this.accept(events[i])) {
                this.fEvent = events[i];
                this.fEventSet = events;
                this.unregister();
                this.notifyAll();
                return;
            }
            ++i;
        }
    }

    protected void printReceived(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            System.out.println(this + " got " + events[i]);
            ++i;
        }
    }

    public void setTimeout(long milliseconds) {
        this.fTimeout = milliseconds;
    }

    public void unregister() {
        this.fDebugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
    }

    public synchronized Object waitForEvent() {
        if (this.fEvent == null) {
            try {
                this.wait(this.fTimeout);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Interrupted waiting for event");
            }
        }
        this.unregister();
        if (this.fEvent == null) {
            return null;
        }
        return this.fEvent.getSource();
    }

    public DebugEvent getEvent() {
        return this.fEvent;
    }

    public DebugEvent[] getEventSet() {
        return this.fEventSet;
    }
}

