/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.utils.XMLUtils;

public class JSSESocketFactory
extends DefaultSocketFactory
implements SecureSocketFactory {
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    protected SSLSocketFactory sslFactory = null;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public JSSESocketFactory(Hashtable attributes) {
        super(attributes);
    }

    protected void initFactory() throws IOException {
        this.sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        if (this.sslFactory == null) {
            this.initFactory();
        }
        if (port == -1) {
            port = 443;
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create("https");
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        Socket sslSocket = null;
        if (tcp.getProxyHost().length() == 0 || hostInNonProxyList) {
            sslSocket = this.sslFactory.createSocket(host, port);
        } else {
            int tunnelPort;
            int n = tunnelPort = tcp.getProxyPort().length() != 0 ? Integer.parseInt(tcp.getProxyPort()) : 80;
            if (tunnelPort < 0) {
                tunnelPort = 80;
            }
            Socket tunnel = new Socket(tcp.getProxyHost(), tunnelPort);
            OutputStream tunnelOutputStream = tunnel.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
            out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\nUser-Agent: AxisClient");
            if (tcp.getProxyUser().length() != 0 && tcp.getProxyPassword().length() != 0) {
                String encodedPassword = XMLUtils.base64encode((tcp.getProxyUser() + ":" + tcp.getProxyPassword()).getBytes());
                out.print("\nProxy-Authorization: Basic " + encodedPassword);
            }
            out.print("\nContent-Length: 0");
            out.print("\nPragma: no-cache");
            out.print("\r\n\r\n");
            out.flush();
            InputStream tunnelInputStream = tunnel.getInputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("isNull00", "tunnelInputStream", "" + (tunnelInputStream == null)));
            }
            String replyStr = "";
            int newlinesSeen = 0;
            boolean headerDone = false;
            while (newlinesSeen < 2) {
                int i = tunnelInputStream.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone) continue;
                replyStr = replyStr + String.valueOf((char)i);
            }
            if (StringUtils.startsWithIgnoreWhitespaces("HTTP/1.0 200", replyStr) && StringUtils.startsWithIgnoreWhitespaces("HTTP/1.1 200", replyStr)) {
                throw new IOException(Messages.getMessage("cantTunnel00", new String[]{tcp.getProxyHost(), "" + tunnelPort, replyStr}));
            }
            sslSocket = this.sslFactory.createSocket(tunnel, host, port, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("setupTunnel00", tcp.getProxyHost(), "" + tunnelPort));
            }
        }
        ((SSLSocket)sslSocket).startHandshake();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("createdSSL00"));
        }
        JSSESocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
        return sslSocket;
    }

    private static void verifyHostName(String host, SSLSocket ssl) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("host to verify was null");
        }
        SSLSession session = ssl.getSession();
        if (session == null) {
            InputStream in = ssl.getInputStream();
            in.available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        Certificate[] certs = session.getPeerCertificates();
        JSSESocketFactory.verifyHostName(host.trim().toLowerCase(Locale.US), (X509Certificate)certs[0]);
    }

    private static void verifyHostName(String host, X509Certificate cert) throws SSLException {
        String[] cns = JSSESocketFactory.getCNs(cert);
        String[] subjectAlts = JSSESocketFactory.getDNSSubjectAlts(cert);
        JSSESocketFactory.verifyHostName(host, cns, subjectAlts);
    }

    private static String[] getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            cpe.printStackTrace();
        }
        if (c != null) {
            Iterator<List<?>> it = c.iterator();
            while (it.hasNext()) {
                List<?> list = it.next();
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return new String[0];
    }

    private static void verifyHostName(String host, String[] cns, String[] subjectAlts) throws SSLException {
        int i;
        StringBuffer cnTested = new StringBuffer();
        for (i = 0; i < subjectAlts.length; ++i) {
            String name = subjectAlts[i];
            if (name == null) continue;
            if (JSSESocketFactory.verifyHostName(host, name = name.toLowerCase(Locale.US))) {
                return;
            }
            cnTested.append("/").append(name);
        }
        for (i = 0; i < cns.length; ++i) {
            String cn = cns[i];
            if (cn == null) continue;
            if (JSSESocketFactory.verifyHostName(host, cn = cn.toLowerCase(Locale.US))) {
                return;
            }
            cnTested.append("/").append(cn);
        }
        throw new SSLException("hostname in certificate didn't match: <" + host + "> != <" + cnTested + ">");
    }

    private static boolean verifyHostName(String host, String cn) {
        if (JSSESocketFactory.doWildCard(cn) && !JSSESocketFactory.isIPAddress(host)) {
            return JSSESocketFactory.matchesWildCard(cn, host);
        }
        return host.equalsIgnoreCase(cn);
    }

    private static boolean doWildCard(String cn) {
        String[] parts = cn.split("\\.");
        return parts.length >= 3 && parts[0].endsWith("*") && JSSESocketFactory.acceptableCountryWildcard(cn) && !JSSESocketFactory.isIPAddress(cn);
    }

    private static boolean isIPAddress(String hostname) {
        return hostname != null && (IPV4_PATTERN.matcher(hostname).matches() || IPV6_STD_PATTERN.matcher(hostname).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(hostname).matches());
    }

    private static boolean acceptableCountryWildcard(String cn) {
        String[] parts = cn.split("\\.");
        if (parts.length > 3 || parts[parts.length - 1].length() != 2) {
            return true;
        }
        String countryCode = parts[parts.length - 2];
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, countryCode) < 0;
    }

    private static boolean matchesWildCard(String cn, String hostName) {
        String[] parts = cn.split("\\.");
        boolean match = false;
        String firstpart = parts[0];
        if (firstpart.length() > 1) {
            String prefix = firstpart.substring(0, firstpart.length() - 1);
            String suffix = cn.substring(firstpart.length());
            String hostSuffix = hostName.substring(prefix.length());
            match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
        } else {
            match = hostName.endsWith(cn.substring(1));
        }
        if (match) {
            match = JSSESocketFactory.countDots(hostName) == JSSESocketFactory.countDots(cn);
        }
        return match;
    }

    private static int countDots(String data) {
        int dots = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '.') continue;
            ++dots;
        }
        return dots;
    }

    private static String[] getCNs(X509Certificate cert) {
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        return JSSESocketFactory.getCNs(subjectPrincipal);
    }

    private static String[] getCNs(String subjectPrincipal) {
        if (subjectPrincipal == null) {
            return null;
        }
        ArrayList<String> cns = new ArrayList<String>();
        try {
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    cns.add(value.toString());
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return cns.isEmpty() ? null : cns.toArray(new String[cns.size()]);
    }
}

