/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1005
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1005(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry registry;
            Binding binding;
            OperationSignature.OperationMatch match;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document doc = entryContext.getMessageEntryDocument();
            if (this.validator.isFault(doc)) {
                throw new AssertionNotApplicableException();
            }
            if (!this.validator.containsSoapBodyWithChild(doc)) {
                throw new AssertionNotApplicableException();
            }
            Document docRequest = entryContext.getRequestDocument();
            String headers = entryContext.getRequest().getHTTPHeaders();
            String action = null;
            if (headers != null) {
                action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
            }
            if ((match = OperationSignature.matchOperation(docRequest, action, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = match.getOperation();
            if (!"rpc".equals(match.getOperationStyle())) {
                throw new AssertionNotApplicableException();
            }
            List extElements = null;
            if (bindingOperation.getBindingOutput() != null) {
                extElements = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (!this.validator.isLiteral(extElements)) {
                throw new AssertionNotApplicableException();
            }
            NodeList soapBodyList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (soapBodyList.getLength() == 0 || soapBodyList.getLength() > 1) {
                throw new AssertionFailException();
            }
            Element soapBodyElem = (Element)soapBodyList.item(0);
            Element wrapperElement = XMLUtils.getFirstChild(soapBodyElem);
            if (wrapperElement == null) {
                throw new AssertionFailException();
            }
            this.result = wrapperElement.getLocalName().equals(String.valueOf(bindingOperation.getName()) + "Response") ? "passed" : "failed";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

