/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.style;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.ui.internal.Logger;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForCSS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class LineStyleProviderForEmbeddedCSS
extends LineStyleProviderForCSS {
    int fCacheKey = -1;
    List fCacheResult = null;

    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        int regionStart = typedRegion.getOffset();
        int regionEnd = regionStart + typedRegion.getLength();
        IStructuredDocumentRegion wholeRegion = this.getDocument().getRegionAtCharacterOffset(regionStart);
        if (wholeRegion == null) {
            return false;
        }
        List tokens = null;
        int offset = typedRegion.getOffset();
        List cache = this.getCachedParsingResult(wholeRegion);
        if (cache == null) {
            try {
                String content = this.getDocument().get(typedRegion.getOffset(), typedRegion.getLength());
                int mode = wholeRegion.getType() == "XML_TAG_NAME" ? 1 : 0;
                CSSTextParser parser = new CSSTextParser(mode, content);
                tokens = parser.getTokenList();
                this.cacheParsingResult(wholeRegion, tokens);
            }
            catch (BadLocationException e) {
                Logger.logException("Given a bad ITypedRegion: " + String.valueOf(typedRegion), e);
            }
        } else {
            tokens = cache;
        }
        boolean result = false;
        if (tokens != null && tokens.size() > 0) {
            int start;
            int end = start = offset;
            for (CSSTextToken token : tokens) {
                end = start + token.length;
                int styleLength = token.length;
                if (regionStart <= start && start < regionEnd) {
                    if (regionEnd < end) {
                        styleLength = regionEnd - start;
                    }
                    this.addStyleRange(holdResults, this.getAttributeFor(token.kind), start, styleLength);
                } else if (start <= regionStart && regionStart < end) {
                    styleLength = end < regionEnd ? end - regionStart : regionEnd - regionStart;
                    this.addStyleRange(holdResults, this.getAttributeFor(token.kind), regionStart, styleLength);
                }
                start += token.length;
            }
            result = true;
        }
        return result;
    }

    private void addStyleRange(Collection holdResults, TextAttribute attribute, int start, int end) {
        if (attribute != null) {
            holdResults.add(new StyleRange(start, end, attribute.getForeground(), attribute.getBackground(), attribute.getStyle()));
        } else {
            holdResults.add(new StyleRange(start, end, null, null));
        }
    }

    @Override
    protected TextAttribute getAttributeFor(ITextRegion region) {
        return null;
    }

    private void cleanupCache() {
        this.fCacheKey = -1;
        this.fCacheResult = null;
    }

    private List getCachedParsingResult(IStructuredDocumentRegion region) {
        if (this.fCacheKey == region.getText().hashCode()) {
            return this.fCacheResult;
        }
        return null;
    }

    private void cacheParsingResult(IStructuredDocumentRegion region, List result) {
        this.fCacheKey = region.getText().hashCode();
        this.fCacheResult = result;
    }

    @Override
    public void release() {
        super.release();
        this.cleanupCache();
    }
}

