/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.util.ErrorMessage;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLReaderImpl;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.XSDValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.AbstractXMLConformanceFactory;
import org.eclipse.wst.wsdl.validation.internal.xml.DefaultXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalogResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ImportHolder
implements Comparable {
    private MessageGenerator messagegenerator;
    private WSDLDocument importingWSDLDoc = null;
    private WSDLDocument wsdlDocument = null;
    private Definition importingDef = null;
    private Element importingDocImportElement = null;
    private String namespace = null;
    private String location = null;
    private String classpathURI = null;
    private String contextURI = null;
    private int depth;
    private Element element = null;
    private List schemas = new ArrayList();
    private boolean isWSDLFileImport = true;
    private boolean importInvalid = false;
    private Import importDef = null;
    private IWSDL11ValidationInfo valinfo;

    public ImportHolder(String namespace, String location, String contextURI, WSDLDocument importingWSDLDoc, int depth, Element importingDocImportElement, MessageGenerator messagegenerator, IWSDL11ValidationInfo valinfo) {
        this.messagegenerator = messagegenerator;
        this.valinfo = valinfo;
        this.importingWSDLDoc = importingWSDLDoc;
        if (importingWSDLDoc != null) {
            this.importingDef = importingWSDLDoc.getDefinition();
        }
        this.importingDocImportElement = importingDocImportElement;
        this.depth = depth;
        this.namespace = namespace;
        this.location = location;
        if (this.location == null) {
            this.location = namespace;
        }
        this.contextURI = contextURI;
        this.location = this.location.replace('\\', '/');
        IURIResolutionResult classpathURI = valinfo.getURIResolver().resolve(this.contextURI, this.namespace, this.location);
        if (classpathURI.getLogicalLocation() != null) {
            this.location = classpathURI.getLogicalLocation();
        }
        if (classpathURI.getPhysicalLocation() != null) {
            this.classpathURI = classpathURI.getPhysicalLocation();
            this.contextURI = null;
        }
    }

    public void initialize() {
        Element documentElement = null;
        try {
            documentElement = this.getElement();
        }
        catch (WSDLException wSDLException) {}
        if (documentElement != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DEFINITIONS, (Node)documentElement)) {
                if (this.isXMLValid(this.classpathURI)) {
                    try {
                        this.wsdlDocument = new WSDLDocument(this.location, documentElement, this.depth, this.messagegenerator, this.valinfo);
                        this.createWSDLImport(this.wsdlDocument);
                    }
                    catch (WSDLException wSDLException) {
                        this.valinfo.addError(this.messagegenerator.getString("_UNABLE_TO_IMPORT_BAD_LOCATION", "'" + this.importDef.getLocationURI() + "'"), this.importingDocImportElement);
                    }
                }
            } else if (QNameUtils.matches((QName)SchemaConstants.Q_ELEM_XSD_2001, (Node)documentElement)) {
                this.createXSDImport();
            }
        }
    }

    protected boolean isXMLValid(String uri) {
        XMLGrammarPool grammarPool;
        IXMLValidator xmlValidator = AbstractXMLConformanceFactory.getInstance().getXMLValidator();
        xmlValidator.setFile(uri);
        xmlValidator.setURIResolver(this.valinfo.getURIResolver());
        if (xmlValidator instanceof DefaultXMLValidator && (grammarPool = this.valinfo.getXMLCache()) != null) {
            ((DefaultXMLValidator)xmlValidator).setGrammarPool(grammarPool);
        }
        xmlValidator.run();
        if (xmlValidator.hasErrors()) {
            List errors = xmlValidator.getErrors();
            for (IValidationMessage valMes : errors) {
                this.valinfo.addError(valMes.getMessage(), valMes.getLine(), valMes.getColumn(), valMes.getURI());
            }
            this.importInvalid = true;
            return false;
        }
        return true;
    }

    public WSDLDocument getImportingDocument() {
        return this.importingWSDLDoc;
    }

    public WSDLDocument getWSDLDocument() {
        return this.wsdlDocument;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContextURI() {
        return this.contextURI;
    }

    public int getDepth() {
        return this.depth;
    }

    public Definition getImportingDefinition() {
        return this.importingDef;
    }

    public Element getElement() throws WSDLException {
        block30: {
            if (this.element != null) {
                return this.element;
            }
            String locationURI = this.location;
            InputStream reader = null;
            if (locationURI != null) {
                try {
                    try {
                        String importTargetNS;
                        String canonicalfileString;
                        File testfile;
                        String testfileString;
                        String urlString;
                        InputSource inputSource = null;
                        URL url = null;
                        URL contextURL = this.contextURI != null ? StringUtils.getURL(null, (String)this.contextURI) : null;
                        url = StringUtils.getURL((URL)contextURL, (String)locationURI);
                        String urlAuthority = url.getAuthority();
                        String urlProtocol = url.getProtocol();
                        if (urlAuthority != null && urlProtocol.equalsIgnoreCase("file") && !urlAuthority.equals("")) {
                            url = new URL(urlProtocol, "", "/" + urlAuthority + url.getFile());
                        }
                        if (!(!(urlString = url.toString()).startsWith("file:") || (testfileString = (testfile = new File(url.getFile())).getAbsolutePath()).equals(canonicalfileString = testfile.getCanonicalPath()) || String.valueOf(testfileString.charAt(0)).equalsIgnoreCase(String.valueOf(canonicalfileString.charAt(0))) && testfileString.substring(1, testfileString.length()).equals(canonicalfileString.substring(1, canonicalfileString.length())))) {
                            urlString = "";
                            url = null;
                        }
                        if (url != null) {
                            try {
                                reader = StringUtils.getContentAsInputStream((URL)url);
                            }
                            catch (IOException iOException) {}
                        }
                        if (reader != null) {
                            inputSource = new InputSource(reader);
                            if (this.classpathURI != null && !this.classpathURI.equals(this.location)) {
                                inputSource.setByteStream(new URL(this.classpathURI).openStream());
                            }
                        }
                        if (inputSource == null) {
                            String actualLocation = DOMUtils.getAttribute((Element)this.importingDocImportElement, (String)"location");
                            if (actualLocation == null) {
                                actualLocation = DOMUtils.getAttribute((Element)this.importingDocImportElement, (String)"schemaLocation");
                            }
                            if (actualLocation == null) {
                                actualLocation = this.namespace;
                            }
                            this.importingWSDLDoc.addReaderWarning(this.importingDef, this.importingDocImportElement, this.messagegenerator.getString("_UNABLE_TO_IMPORT_BAD_LOCATION", "'" + actualLocation + "'"));
                            this.importInvalid = true;
                            throw new WSDLException("OTHER_ERROR", "Unable to locate imported document at '" + locationURI + "'" + (String)(this.contextURI == null ? "." : ", relative to '" + this.contextURI + "'."));
                        }
                        Document doc = null;
                        try {
                            doc = WSDLReaderImpl.getDocument(inputSource, locationURI);
                        }
                        catch (WSDLException e) {
                            this.isXMLValid(locationURI);
                            throw e;
                        }
                        this.element = doc.getDocumentElement();
                        if (!QNameUtils.matches((QName)Constants.Q_ELEM_DEFINITIONS, (Node)this.element)) {
                            this.isWSDLFileImport = false;
                        }
                        if (!(importTargetNS = this.element.getAttribute("targetNamespace")).equals(this.namespace)) {
                            this.importingWSDLDoc.addReaderWarning(this.importingDef, this.importingDocImportElement, this.messagegenerator.getString("_WARN_WRONG_NS_ON_IMPORT", "'" + this.namespace + "'", "'" + importTargetNS + "'"));
                            this.element = null;
                            this.importInvalid = true;
                        }
                    }
                    catch (Exception exception) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.element;
    }

    public Import createWSDLImport(WSDLDocument wsdlDocument) {
        if (this.importDef != null) {
            return this.importDef;
        }
        this.importDef = this.getNewImport();
        if (this.importDef != null) {
            this.importDef.setDefinition(wsdlDocument.getDefinition());
            this.schemas.addAll(wsdlDocument.getSchemas());
            this.importingWSDLDoc.addSchemas(this.schemas);
        }
        return this.importDef;
    }

    public Import createXSDImport() {
        if (this.importDef != null) {
            return this.importDef;
        }
        this.importDef = this.getNewImport();
        XSDValidator xsdvalidator = new XSDValidator();
        xsdvalidator.validate(this.location, XMLCatalogResolver.getInstance(), this.valinfo.getSchemaCache());
        if (xsdvalidator.isValid()) {
            XSModel schema = xsdvalidator.getXSModel();
            if (schema != null) {
                this.schemas.add(schema);
            }
        } else {
            for (ErrorMessage err : xsdvalidator.getErrors()) {
                String uri = err.getURI();
                int line = err.getErrorLine();
                String errmess = err.getErrorMessage();
                this.valinfo.addError(errmess, line, err.getErrorColumn(), uri);
            }
        }
        this.importingWSDLDoc.addSchemas(this.schemas);
        return this.importDef;
    }

    public Import getImport() {
        return this.importDef;
    }

    private Import getNewImport() {
        if (this.importInvalid) {
            return null;
        }
        Import importDef = this.importingDef.createImport();
        if (this.namespace != null) {
            importDef.setNamespaceURI(this.namespace);
        }
        if (this.location != null) {
            importDef.setLocationURI(this.location);
        }
        if (this.element != null) {
            Element tempEl = DOMUtils.getFirstChildElement((Element)this.element);
            while (tempEl != null) {
                if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                    importDef.setDocumentationElement(tempEl);
                }
                tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
            }
        }
        return importDef;
    }

    public List getSchemas() {
        return this.schemas;
    }

    public boolean isWSDLFileImport() {
        return this.isWSDLFileImport;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == ImportHolder.class) {
            ImportHolder otherImport = (ImportHolder)obj;
            if (this.getNamespace().equals(otherImport.getNamespace()) && this.getLocation().equals(otherImport.getLocation())) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        ImportHolder otherImport = (ImportHolder)obj;
        return (this.getNamespace() + this.getLocation()).compareTo(otherImport.getNamespace() + otherImport.getLocation());
    }

    public void setMessageGenerator(MessageGenerator mg) {
        this.messagegenerator = mg;
    }

    public boolean isImportInvalid() {
        return this.importInvalid;
    }
}

