/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.modelhandler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapterFactory;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveWatcherFactory;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.jsp.core.internal.encoding.IJSPHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentLoader;
import org.eclipse.jst.jsp.core.internal.modelhandler.EmbeddedTypeStateData;
import org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl;
import org.eclipse.jst.jsp.core.internal.modelquery.ModelQueryAdapterFactoryForJSP;
import org.eclipse.jst.jsp.core.internal.parser.JSPReParser;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.IContentDescriptionForJSP;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeFamilyForHTML;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.model.AbstractModelLoader;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistry;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistryImpl;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.propagate.PropagatingAdapterFactoryImpl;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class JSPModelLoader
extends AbstractModelLoader {
    protected final int MAX_BUFFERED_SIZE_FOR_RESET_MARK = 200000;
    private EmbeddedTypeRegistry embeddedContentTypeRegistry;
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private static final String DEFAULT_LANGUAGE = "java";

    private EmbeddedTypeRegistry getEmbeddedContentTypeRegistry() {
        if (this.embeddedContentTypeRegistry == null) {
            this.embeddedContentTypeRegistry = EmbeddedTypeRegistryImpl.getInstance();
        }
        return this.embeddedContentTypeRegistry;
    }

    public IStructuredModel newModel() {
        DOMModelForJSP model = new DOMModelForJSP();
        return model;
    }

    private EmbeddedTypeHandler getJSPDefaultEmbeddedType(IStructuredModel model) {
        IFile file;
        EmbeddedTypeRegistry reg = this.getEmbeddedContentTypeRegistry();
        String mimeType = null;
        if (model != null && (file = this.getFile(model)) != null) {
            mimeType = JSPFContentProperties.getProperty("jsp-content-type", (IResource)file, true);
        }
        mimeType = mimeType == null ? this.getDefaultMimeType() : mimeType;
        return reg.getTypeFor(mimeType);
    }

    private String getDefaultMimeType() {
        return DEFAULT_MIME_TYPE;
    }

    public IStructuredDocument newStructuredDocument() {
        IStructuredDocument structuredDocument = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)this.getParser());
        ((BasicStructuredDocument)structuredDocument).setReParser((IStructuredTextReParser)new JSPReParser());
        EmbeddedTypeHandler embeddedType = this.getJSPDefaultEmbeddedType(null);
        embeddedType.initializeParser(structuredDocument.getParser());
        return structuredDocument;
    }

    public RegionParser getParser() {
        return new JSPSourceParser();
    }

    protected void preLoadAdapt(IStructuredModel structuredModel) {
        super.preLoadAdapt(structuredModel);
        IDOMModel domModel = (IDOMModel)structuredModel;
        IDOMDocument document = domModel.getDocument();
        Assert.isNotNull((Object)document);
        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)document).getAdapterFor(PropagatingAdapter.class);
        propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)new PageDirectiveWatcherFactory());
        ((INodeNotifier)document).getAdapterFor(ModelQueryAdapter.class);
    }

    public List getAdapterFactories() {
        ArrayList<AbstractAdapterFactory> result = new ArrayList<AbstractAdapterFactory>();
        AbstractAdapterFactory factory = null;
        factory = new ModelQueryAdapterFactoryForJSP();
        result.add(factory);
        factory = new PropagatingAdapterFactoryImpl();
        result.add(factory);
        factory = new PageDirectiveAdapterFactory();
        result.add(factory);
        return result;
    }

    public IJSPHeadContentDetector getHeadParser() {
        return new JSPDocumentHeadContentDetector();
    }

    private IContentDescription getContentDescription(IDocument doc) {
        if (doc == null) {
            return null;
        }
        DocumentReader reader = new DocumentReader(doc);
        return this.getContentDescription((Reader)reader);
    }

    private IContentDescription getContentDescription(Reader reader) {
        IContentDescription desc;
        block13: {
            if (reader == null) {
                return null;
            }
            desc = null;
            try {
                try {
                    IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
                    desc = contentTypeJSP.getDescriptionFor(reader, IContentDescription.ALL);
                }
                catch (IOException e) {
                    Logger.logException(e);
                    if (reader == null) break block13;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        Logger.logException(e2);
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
            }
        }
        return desc;
    }

    private IFile getFile(IStructuredModel model) {
        Path path;
        String location;
        if (model != null && (location = model.getBaseLocation()) != null && !(path = new Path(location)).toFile().exists() && path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    private String getLanguage(IStructuredModel model) {
        String result = null;
        result = this.getLanguageFromStructuredDocument(model.getStructuredDocument());
        IFile file = this.getFile(model);
        result = JSPFContentProperties.getProperty("jsp-language", (IResource)file, true);
        if (result == null) {
            result = DEFAULT_LANGUAGE;
        }
        return result;
    }

    private String getLanguageFromStructuredDocument(IStructuredDocument structuredDocument) {
        if (structuredDocument == null) {
            return null;
        }
        String result = null;
        IJSPHeadContentDetector localHeadParser = this.getHeadParser();
        localHeadParser.set((IDocument)structuredDocument);
        try {
            result = localHeadParser.getLanguage();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return result;
    }

    private void reInitializeEmbeddedType(IStructuredModel model, EmbeddedTypeHandler oldEmbeddedContentType, EmbeddedTypeHandler newEmbeddedContentType) {
        String language;
        Assert.isNotNull((Object)oldEmbeddedContentType, (String)"Program error: invalid call during model initialization");
        IDOMModel domModel = (IDOMModel)model;
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IDOMDocument document = domModel.getDocument();
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getExistingAdapter(PageDirectiveAdapter.class);
        oldEmbeddedContentType.uninitializeFactoryRegistry(model.getFactoryRegistry());
        oldEmbeddedContentType.uninitializeParser(structuredDocument.getParser());
        pageDirectiveAdapter.setEmbeddedType(newEmbeddedContentType);
        if (newEmbeddedContentType != null) {
            ((DOMModelImpl)model).setModelParser(null);
            newEmbeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
            newEmbeddedContentType.initializeParser(structuredDocument.getParser());
            IDocumentPartitioner documentPartitioner = structuredDocument.getDocumentPartitioner();
            if (documentPartitioner != null && documentPartitioner instanceof StructuredTextPartitionerForJSP) {
                if (newEmbeddedContentType.getFamilyId().equals(ContentTypeIdForXML.ContentTypeID_XML)) {
                    ((StructuredTextPartitionerForJSP)documentPartitioner).setEmbeddedPartitioner((IStructuredTextPartitioner)new StructuredTextPartitionerForXML());
                } else if (newEmbeddedContentType.getFamilyId().equals(ContentTypeIdForHTML.ContentTypeID_HTML)) {
                    ((StructuredTextPartitionerForJSP)documentPartitioner).setEmbeddedPartitioner((IStructuredTextPartitioner)new StructuredTextPartitionerForHTML());
                }
            }
        }
        if ((language = this.getLanguage(model)) != null && language.length() > 0) {
            pageDirectiveAdapter.setLanguage(language);
        }
    }

    private void initCloneOfEmbeddedType(IStructuredModel model, EmbeddedTypeHandler oldEmbeddedContentType, EmbeddedTypeHandler newEmbeddedContentType) {
        String language;
        Assert.isNotNull((Object)oldEmbeddedContentType, (String)"Program error: invalid call during model initialization");
        IDOMModel domModel = (IDOMModel)model;
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IDOMDocument document = domModel.getDocument();
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getAdapterFor(PageDirectiveAdapter.class);
        oldEmbeddedContentType.uninitializeFactoryRegistry(model.getFactoryRegistry());
        oldEmbeddedContentType.uninitializeParser(structuredDocument.getParser());
        pageDirectiveAdapter.setEmbeddedType(newEmbeddedContentType);
        if (newEmbeddedContentType != null) {
            newEmbeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
            newEmbeddedContentType.initializeParser(structuredDocument.getParser());
        }
        if ((language = this.getLanguage(model)) != null && language.length() > 0) {
            pageDirectiveAdapter.setLanguage(language);
        }
    }

    private EmbeddedTypeHandler getEmbeddedType(IStructuredModel model) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)((INodeNotifier)doc).getAdapterFor(PageDirectiveAdapter.class);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        return embeddedHandler;
    }

    protected void initEmbeddedTypePre(IStructuredModel model) {
        this.initEmbeddedTypePre(model, model.getStructuredDocument());
    }

    protected void initEmbeddedTypePre(IStructuredModel model, IStructuredDocument structuredDocument) {
        IContentDescription desc;
        EmbeddedTypeHandler embeddedContentType = null;
        IDOMModel domModel = (IDOMModel)model;
        if (embeddedContentType == null && (desc = this.getContentDescription((IDocument)structuredDocument)) != null) {
            Object prop = null;
            prop = desc.getProperty(IContentDescriptionForJSP.CONTENT_FAMILY_ATTRIBUTE);
            if (prop != null && ContentTypeFamilyForHTML.HTML_FAMILY.equals(prop)) {
                embeddedContentType = EmbeddedTypeRegistryImpl.getInstance().getTypeFor(DEFAULT_MIME_TYPE);
            }
            if (embeddedContentType == null && (prop = desc.getProperty(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE)) != null) {
                embeddedContentType = EmbeddedTypeRegistryImpl.getInstance().getTypeFor((String)prop);
            }
        }
        IDOMDocument document = domModel.getDocument();
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getAdapterFor(PageDirectiveAdapter.class);
        if (embeddedContentType != null) {
            pageDirectiveAdapter.setEmbeddedType(embeddedContentType);
            embeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
        } else {
            embeddedContentType = this.getJSPDefaultEmbeddedType(model);
            pageDirectiveAdapter.setEmbeddedType(embeddedContentType);
            embeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
        }
    }

    protected void initEmbeddedTypePost(IStructuredModel model) {
        this.setLanguageInPageDirective(model);
    }

    protected void initEmbeddedType(IStructuredModel oldModel, IStructuredModel newModel) {
        EmbeddedTypeHandler existingEmbeddedType = this.getEmbeddedType(oldModel);
        if (existingEmbeddedType == null) {
            this.initEmbeddedTypePre(newModel, newModel.getStructuredDocument());
            this.initEmbeddedTypePost(newModel);
        } else {
            EmbeddedTypeHandler newEmbeddedContentType = existingEmbeddedType.newInstance();
            this.initCloneOfEmbeddedType(newModel, existingEmbeddedType, newEmbeddedContentType);
            this.setLanguageInPageDirective(newModel);
        }
    }

    protected void setLanguageInPageDirective(IStructuredModel newModel) {
        if (newModel instanceof IDOMModel) {
            IDOMDocument document = ((IDOMModel)newModel).getDocument();
            PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getAdapterFor(PageDirectiveAdapter.class);
            String language = this.getLanguage(newModel);
            pageDirectiveAdapter.setLanguage(language);
        }
    }

    public IStructuredModel reinitialize(IStructuredModel model) {
        EmbeddedTypeHandler oldHandler = null;
        EmbeddedTypeHandler newHandler = null;
        Object reinitStateData = model.getReinitializeStateData();
        if (reinitStateData instanceof EmbeddedTypeStateData) {
            EmbeddedTypeStateData oldStateData = (EmbeddedTypeStateData)reinitStateData;
            oldHandler = oldStateData.getOldHandler();
            newHandler = oldStateData.getNewHandler();
            this.reInitializeEmbeddedType(model, oldHandler, newHandler);
        }
        return super.reinitialize(model);
    }

    public IModelLoader newInstance() {
        return new JSPModelLoader();
    }

    public IDocumentLoader getDocumentLoader() {
        if (this.documentLoaderInstance == null) {
            this.documentLoaderInstance = new JSPDocumentLoader();
        }
        return this.documentLoaderInstance;
    }

    public static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    protected byte[] getBytes(InputStream inputStream, int max) throws IOException {
        byte[] smallBuffer = new byte[max];
        byte[] returnBuffer = null;
        int nRead = inputStream.read(smallBuffer, 0, max);
        if (nRead < max) {
            if (nRead < 0) {
                nRead = 0;
            }
            byte[] smallerBuffer = new byte[nRead];
            System.arraycopy(smallBuffer, 0, smallerBuffer, 0, nRead);
            returnBuffer = smallerBuffer;
        } else {
            returnBuffer = smallBuffer;
        }
        return returnBuffer;
    }

    public IStructuredModel createModel(IStructuredModel oldModel) {
        IStructuredModel model = super.createModel(oldModel);
        ModelQueryAdapter modelQueryAdapter = this.getModelQueryAdapter(model);
        if (modelQueryAdapter == null) {
            modelQueryAdapter = this.getModelQueryAdapter(oldModel);
            IDOMDocument document = ((IDOMModel)model).getDocument();
            document.addAdapter((INodeAdapter)new JSPModelQueryAdapterImpl(modelQueryAdapter.getCMDocumentCache(), modelQueryAdapter.getModelQuery(), modelQueryAdapter.getIdResolver()));
        }
        return model;
    }

    private ModelQueryAdapter getModelQueryAdapter(IStructuredModel model) {
        IDOMDocument document = ((IDOMModel)model).getDocument();
        ModelQueryAdapter modelQueryAdapter = (ModelQueryAdapter)document.getAdapterFor(ModelQueryAdapter.class);
        return modelQueryAdapter;
    }
}

