/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.CopyMoveTests;
import org.eclipse.wst.jsdt.core.tests.model.TestProgressMonitor;

public class RenameTests
extends CopyMoveTests {
    IJavaScriptUnit cu;

    public RenameTests(String name) {
        super(name);
    }

    public void renameNegative(IJavaScriptElement[] elements, String[] renamings, boolean force, int failureCode) {
        try {
            this.getJavaModel().rename(elements, new IJavaScriptElement[]{elements[0].getParent()}, renamings, force, null);
        }
        catch (JavaScriptModelException jme) {
            RenameTests.assertTrue((String)("Code not correct for JavaScriptModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        RenameTests.assertTrue((String)"The rename should have failed for multiple renaming", (boolean)false);
    }

    public void renameNegative(IJavaScriptElement element, String rename, boolean force, int failureCode) {
        try {
            this.getJavaModel().rename(new IJavaScriptElement[]{element}, new IJavaScriptElement[]{element.getParent()}, new String[]{rename}, force, null);
        }
        catch (JavaScriptModelException jme) {
            RenameTests.assertTrue((String)("Code not correct for JavaScriptModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        RenameTests.assertTrue((String)("The rename should have failed for: " + element), (boolean)false);
    }

    public void renamePositive(IJavaScriptElement[] elements, String[] names, boolean force) throws JavaScriptModelException {
        this.renamePositive(elements, new IJavaScriptElement[]{elements[0].getParent()}, names, force);
    }

    public void renamePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, String[] names, boolean force) throws JavaScriptModelException {
        this.renamePositive(elements, destinations, names, force, false);
    }

    public void renamePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, String[] names, boolean force, boolean originalShouldExist) throws JavaScriptModelException {
        this.renamePositive(elements, destinations, names, force, originalShouldExist, null);
    }

    public void renamePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, String[] names, boolean force, boolean originalShouldExist, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptElement e;
        int i;
        if (force) {
            i = 0;
            while (i < elements.length) {
                e = elements[i];
                IJavaScriptElement collision = this.generateHandle(e, names[i], e.getParent());
                RenameTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
                ++i;
            }
        }
        this.getJavaModel().rename(elements, destinations, names, force, monitor);
        i = 0;
        while (i < elements.length) {
            e = elements[i];
            IJavaScriptElement renamed = this.generateHandle(e, names[i], e.getParent());
            RenameTests.assertTrue((String)"Renamed element should exist", (boolean)renamed.exists());
            if (!originalShouldExist) {
                RenameTests.assertTrue((String)"Original element should not exist", (!e.exists() ? 1 : 0) != 0);
            }
            IJavaScriptElementDelta destDelta = this.getDeltaFor(renamed.getParent());
            if (this.isMainType(e, e.getParent())) {
                RenameTests.assertTrue((String)"Renamed compilation unit as result of main type not added", (destDelta != null && destDelta.getKind() == 1 ? 1 : 0) != 0);
                RenameTests.assertTrue((String)"Added children not correct for element copy", (boolean)destDelta.getElement().equals(renamed.getParent()));
                RenameTests.assertTrue((String)"flag should be F_MOVED_FROM", ((destDelta.getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                RenameTests.assertTrue((String)"moved from handle should be original", (boolean)destDelta.getMovedFromElement().equals(e.getParent()));
            } else {
                RenameTests.assertTrue((String)"Destination container not changed", (destDelta != null && this.deltaChildrenChanged(destDelta) ? 1 : 0) != 0);
                IJavaScriptElementDelta[] deltas = destDelta.getAddedChildren();
                RenameTests.assertTrue((String)"Added children not correct for element rename", (deltas.length > i && deltas[i].getElement().equals(renamed) ? 1 : 0) != 0);
                RenameTests.assertTrue((String)"kind should be K_ADDED", (deltas[i].getKind() == 1 ? 1 : 0) != 0);
                deltas = destDelta.getRemovedChildren();
                RenameTests.assertTrue((String)"Removed children not correct for element rename", (deltas.length > i && deltas[i].getElement().equals(e) ? 1 : 0) != 0);
                RenameTests.assertTrue((String)"kind should be K_REMOVED", (deltas[i].getKind() == 2 ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void renamePositive(IJavaScriptElement element, String rename, boolean force) throws JavaScriptModelException {
        this.renamePositive(new IJavaScriptElement[]{element}, new String[]{rename}, force);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P", new String[]{"src"});
        this.createFile("/P/src/X.js", "public class X {\n  boolean other;\n  int bar;\n  {\n    bar = 1;\n  }\n  X(int i) {\n  }\n  void otherMethod(String s) {\n  }\n  void foo(String s) {\n  }\n}");
        this.cu = this.getCompilationUnit("/P/src/X.js");
        this.startDeltas();
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IJavaScriptProject project = this.createJavaProject("BinaryProject", new String[]{"src"}, new String[]{"JCL_LIB"});
        this.createFile("/BinaryProject/src/X.js", "public class X {\n  int bar;\n  public void foo() {\n  }\n}");
        project.getProject().build(6, null);
        RenameTests.waitForAutoBuild();
        project.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)new Path("/BinaryProject/lib"), null, null)}, null);
    }

    public static Test suite() {
        return RenameTests.buildModelTestSuite(RenameTests.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("BinaryProject");
        super.tearDownSuite();
    }

    public void testRenameBinaryField() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("BinaryProject", "lib", "", "X.class");
        IField binaryField = cf.getType().getField("bar");
        this.renameNegative((IJavaScriptElement)binaryField, "fred", false, 976);
    }

    public void testRenameBinaryMethod() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("BinaryProject", "lib", "", "X.class");
        IFunction binaryMethod = cf.getType().getFunctions()[0];
        this.renameNegative((IJavaScriptElement)binaryMethod, "fred", false, 976);
    }

    public void testRenameBinaryType() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("BinaryProject", "lib", "", "X.class");
        IType binaryType = cf.getType();
        this.renameNegative((IJavaScriptElement)binaryType, "Y", false, 976);
    }

    public void testRenameCompilationUnitAndType() {
        this.renameNegative(new IJavaScriptElement[]{this.cu, this.cu.getType("X")}, new String[]{"Y.js", "Y"}, false, 967);
    }

    public void testRenameCompilationUnitResultingInCollision() throws CoreException {
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        this.renameNegative((IJavaScriptElement)this.cu, "Y.js", false, 977);
        this.renamePositive((IJavaScriptElement)this.cu, "Y.js", true);
    }

    public void testRenameCompilationUnitsCheckingDeltas() throws CoreException {
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IJavaScriptUnit cu2 = this.getCompilationUnit("/P/src/Y.js");
        this.clearDeltas();
        this.renamePositive((IJavaScriptElement[])new IJavaScriptUnit[]{this.cu, cu2}, new String[]{"NewX.js", "NewY.js"}, false);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tNewX.java[+]: {MOVED_FROM(X.java [in <default> [in src [in P]]])}\n\t\t\tNewY.java[+]: {MOVED_FROM(Y.java [in <default> [in src [in P]]])}\n\t\t\tX.java[-]: {MOVED_TO(NewX.java [in <default> [in src [in P]]])}\n\t\t\tY.java[-]: {MOVED_TO(NewY.java [in <default> [in src [in P]]])}");
    }

    public void testRenameCompilationUnitWithInvalidName() {
        this.renameNegative((IJavaScriptElement)this.cu, "NewX", false, 983);
        this.renameNegative((IJavaScriptElement)this.cu, "New X.js", false, 983);
    }

    public void testRenameCompilationUnitWithNull() throws JavaScriptModelException {
        try {
            this.cu.rename(null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        RenameTests.assertTrue((String)"Should not be able to rename a cu with a null name", (boolean)false);
    }

    public void testRenameConstructor() {
        IFunction constructor = this.cu.getType("X").getFunction("X", new String[]{"I"});
        this.renameNegative((IJavaScriptElement)constructor, "newName", false, 977);
    }

    public void testRenameCU() throws CoreException {
        this.cu.rename("NewX.js", false, null);
        RenameTests.assertTrue((String)"Original CU should not exist", (!this.cu.exists() ? 1 : 0) != 0);
        IJavaScriptUnit newCU = this.getCompilationUnit("/P/src/NewX.js");
        RenameTests.assertTrue((String)"New CU should exist", (boolean)newCU.exists());
        this.assertTypesEqual("Unexpected types", "NewX\n", newCU.getAllTypes());
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tNewX.java[+]: {MOVED_FROM(X.java [in <default> [in src [in P]]])}\n\t\t\tX.java[-]: {MOVED_TO(NewX.java [in <default> [in src [in P]]])}");
    }

    public void testRenameCUForce() throws CoreException {
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        this.clearDeltas();
        this.cu.rename("Y.js", true, null);
        IFile file = (IFile)this.cu.getResource();
        IJavaScriptUnit destCU = this.getCompilationUnit("/P/src/Y.js");
        IFile destFile = (IFile)destCU.getResource();
        RenameTests.assertTrue((String)"Original CU should not exist", (!this.cu.exists() ? 1 : 0) != 0);
        RenameTests.assertTrue((String)"Original file should not exist", (!file.exists() ? 1 : 0) != 0);
        RenameTests.assertTrue((String)"Destination CU should exist", (boolean)destCU.exists());
        RenameTests.assertTrue((String)"Destination file should exist", (boolean)destFile.exists());
        this.assertTypesEqual("Unexpected types", "Y\n", destCU.getAllTypes());
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[-]: {MOVED_TO(Y.java [in <default> [in src [in P]]])}\n\t\t\tY.java[+]: {MOVED_FROM(X.java [in <default> [in src [in P]]])}");
    }

    public void testRenameEmptyPF() throws CoreException {
        this.createFolder("/P/src/x/y/z");
        this.clearDeltas();
        this.getPackage("/P/src/x/y/z").rename("x.y", false, null);
        IPackageFragment newFrag = this.getPackage("/P/src/x/y");
        RenameTests.assertTrue((String)"New package should exist", (boolean)newFrag.exists());
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tx.y[+]: {MOVED_FROM(x.y.z [in src [in P]])}\n\t\tx.y.z[-]: {MOVED_TO(x.y [in src [in P]])}");
    }

    public void testRenameEnum() throws CoreException {
        try {
            this.createJavaProject("P15", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            this.createFile("/P15/En.js", "public enum En {\n  ;\n  En() {\n  }\n}");
            IJavaScriptUnit enumCU = this.getCompilationUnit("/P15/En.js");
            enumCU.rename("OtherEnum.js", false, null);
            IJavaScriptUnit renamedCu = this.getCompilationUnit("/P15/OtherEnum.js");
            this.assertSourceEquals("Unexpected source after rename", "public enum OtherEnum {\n  ;\n  OtherEnum() {\n  }\n}", renamedCu.getSource());
        }
        finally {
            this.deleteProject("P15");
        }
    }

    public void testRenameEnum2() throws CoreException {
        try {
            this.createJavaProject("P15", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            this.createFile("/P15/En.js", "public enum En {\n  CONST() {\n  }\n}");
            IJavaScriptUnit enumCU = this.getCompilationUnit("/P15/En.js");
            enumCU.rename("OtherEnum.js", false, null);
            IJavaScriptUnit renamedCu = this.getCompilationUnit("/P15/OtherEnum.js");
            this.assertSourceEquals("Unexpected source after rename", "public enum OtherEnum {\n  CONST() {\n  }\n}", renamedCu.getSource());
        }
        finally {
            this.deleteProject("P15");
        }
    }

    public void testRenameFieldsCheckingDeltasAndPositions() throws JavaScriptModelException {
        IType type = this.cu.getType("X");
        IField field = type.getField("bar");
        this.renamePositive((IJavaScriptElement)field, "fred", false);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tbar[-]: {}\n\t\t\t\t\tfred[+]: {}");
        this.ensureCorrectPositioning((IParent)type, (IJavaScriptElement)type.getField("fred"), (IJavaScriptElement)type.getField("other"));
    }

    public void testRenameFieldFragment() throws Exception {
        this.createFile("/P/src/Y.js", "public class Y {\n  int int1, int2, int3;\n}");
        IJavaScriptUnit c = this.getCompilationUnit("/P/src/Y.js");
        IType type = c.getType("Y");
        IField field = type.getField("int2");
        this.renamePositive((IJavaScriptElement)field, "int2_renamed", false);
    }

    public void testRenameFieldsMultiStatus() throws CoreException {
        String addition = "multiStatus";
        IType type = this.cu.getType("X");
        IField[] iFields = type.getFields();
        String[] newNames = new String[iFields.length];
        int i = 0;
        while (i < iFields.length) {
            IField f = iFields[i];
            newNames[i] = String.valueOf(addition) + f.getElementName();
            ++i;
        }
        newNames[1] = ";";
        boolean e = false;
        try {
            type.getJavaScriptModel().rename((IJavaScriptElement[])iFields, new IJavaScriptElement[]{type}, newNames, false, null);
        }
        catch (JavaScriptModelException jme) {
            RenameTests.assertTrue((String)"Should not be multistatus (only one failure)", (!jme.getStatus().isMultiStatus() ? 1 : 0) != 0);
            RenameTests.assertTrue((String)"Should be an invalid destination", (jme.getStatus().getCode() == 983 ? 1 : 0) != 0);
            e = true;
        }
        RenameTests.assertTrue((String)"Should have been an exception", (boolean)e);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tmultiStatusother[+]: {}\n\t\t\t\t\tother[-]: {}");
        IJavaScriptElement copy = this.generateHandle((IJavaScriptElement)iFields[0], newNames[0], (IJavaScriptElement)type);
        RenameTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
    }

    public void testRenameFieldsResultingInCollision() throws JavaScriptModelException {
        String addition = "new";
        IType type = this.cu.getType("X");
        IField[] iFields = type.getFields();
        String[] newNames = new String[iFields.length];
        int i = 0;
        while (i < iFields.length) {
            IField f = iFields[i];
            newNames[i] = String.valueOf(addition) + f.getElementName();
            ++i;
        }
        newNames[i - 1] = newNames[i - 2];
        this.renameNegative((IJavaScriptElement[])iFields, newNames, false, 977);
    }

    public void testRenameFieldsWithCancel() throws CoreException {
        boolean isCanceled = false;
        String addition = "new1";
        IType type = this.cu.getType("X");
        IField[] iFields = type.getFields();
        String[] newNames = new String[iFields.length];
        int i = 0;
        while (i < iFields.length) {
            IField f = iFields[i];
            newNames[i] = String.valueOf(addition) + f.getElementName();
            ++i;
        }
        try {
            TestProgressMonitor monitor = TestProgressMonitor.getInstance();
            monitor.setCancelledCounter(1);
            this.renamePositive((IJavaScriptElement[])iFields, new IJavaScriptElement[]{type}, newNames, false, false, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            isCanceled = true;
        }
        RenameTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
    }

    public void testRenameInitializer() {
        IType typeSource = this.cu.getType("X");
        IInitializer initializerSource = typeSource.getInitializer(1);
        this.renameNegative((IJavaScriptElement)initializerSource, "someName", false, 967);
    }

    public void testRenameMainTypes() throws CoreException {
        this.createFile("/P/src/Y.js", "public class Y {\n  public Y() {\n  }\n}");
        IJavaScriptUnit cu2 = this.getCompilationUnit("/P/src/Y.js");
        IPackageFragment pkg = (IPackageFragment)this.cu.getParent();
        IJavaScriptElement[] types = new IJavaScriptElement[]{this.cu.getType("X"), cu2.getType("Y")};
        String[] newNames = new String[]{"NewX", "NewY"};
        this.renamePositive(new IJavaScriptElement[]{this.cu.getType("X"), cu2.getType("Y")}, new IJavaScriptElement[]{types[0].getParent(), types[1].getParent()}, newNames, false);
        IJavaScriptUnit renamedCU1 = pkg.getJavaScriptUnit("NewX.js");
        IJavaScriptUnit renamedCU2 = pkg.getJavaScriptUnit("NewY.js");
        IType newType1 = renamedCU1.getType("NewX");
        IType newType2 = renamedCU2.getType("NewY");
        RenameTests.assertTrue((String)"NewX should be present", (boolean)newType1.exists());
        RenameTests.assertTrue((String)"NewY should be present", (boolean)newType2.exists());
        IFunction constructor1 = newType1.getFunction("NewX", new String[]{"I"});
        IFunction constructor2 = newType2.getFunction("NewY", new String[0]);
        RenameTests.assertTrue((String)"NewX(int) should be present", (boolean)constructor1.exists());
        RenameTests.assertTrue((String)"NewY() should be present", (boolean)constructor2.exists());
    }

    public void testRenameMainTypesAndAChild() throws CoreException {
        this.createFile("/P/src/Y.js", "public class Y {\n  public Y() {\n  }\n}");
        IJavaScriptUnit cu2 = this.getCompilationUnit("/P/src/Y.js");
        String[] newNames = new String[]{"newBar", "NewX", "NewY"};
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.cu.getType("X").getField("bar"), this.cu.getType("X"), cu2.getType("Y")};
        IJavaScriptElement[] destinations = new IJavaScriptElement[elements.length];
        int i = 0;
        while (i < elements.length) {
            destinations[i] = elements[i].getParent();
            ++i;
        }
        this.getJavaModel().rename(elements, destinations, newNames, false, null);
        IPackageFragment pkg = (IPackageFragment)this.cu.getParent();
        IJavaScriptUnit renamedCU1 = pkg.getJavaScriptUnit("NewX.js");
        IType newX = renamedCU1.getType("NewX");
        RenameTests.assertTrue((String)"NewX should be present", (boolean)newX.exists());
        IJavaScriptUnit renamedCU2 = pkg.getJavaScriptUnit("NewY.js");
        IType newY = renamedCU2.getType("NewY");
        RenameTests.assertTrue((String)"NewY should be present", (boolean)newY.exists());
        IField newBar = newX.getField("newBar");
        RenameTests.assertTrue((String)"Renamed field should exist", (boolean)newBar.exists());
    }

    public void testRenameMethod() throws JavaScriptModelException {
        IType type = this.cu.getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.renamePositive((IJavaScriptElement)method, "newFoo", false);
        this.ensureCorrectPositioning((IParent)type, (IJavaScriptElement)type.getFunction("newFoo", new String[]{"QString;"}), (IJavaScriptElement)type.getFunction("otherMethod", new String[]{"QString;"}));
    }

    public void testRenameMethodResultingInCollision() {
        IType type = this.cu.getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.renameNegative((IJavaScriptElement)method, "otherMethod", false, 977);
    }

    public void testRenameMethodsWithInvalidName() {
        IFunction method = this.cu.getType("X").getFunction("foo", new String[]{"QString;"});
        this.renameNegative((IJavaScriptElement)method, "%%someInvalidName", false, 983);
    }

    public void testRenamePF() throws CoreException {
        this.createFolder("/P/src/x/y/z");
        this.createFile("/P/src/x/y/z/A.js", "package x.y.z;\npublic class A {\n}");
        IPackageFragment frag = this.getPackage("/P/src/x/y/z");
        this.clearDeltas();
        frag.rename("x.y.newZ", false, null);
        IPackageFragment newFrag = this.getPackage("/P/src/x/y/newZ");
        RenameTests.assertTrue((String)"Old package should not exist", (!frag.exists() ? 1 : 0) != 0);
        RenameTests.assertTrue((String)"New package should exist", (boolean)newFrag.exists());
        IJavaScriptUnit compilationUnit = newFrag.getJavaScriptUnit("A.js");
        RenameTests.assertTrue((String)"A.java should exits in new package", (boolean)compilationUnit.exists());
        IType[] types = compilationUnit.getTypes();
        RenameTests.assertTrue((types != null && types.length == 1 ? 1 : 0) != 0);
        IType mainType = types[0];
        RenameTests.assertEquals((String)"Unexpected A.java's main type'", (String)"x.y.newZ.A", (String)mainType.getFullyQualifiedName());
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tx.y.newZ[+]: {MOVED_FROM(x.y.z [in src [in P]])}\n\t\tx.y.z[-]: {MOVED_TO(x.y.newZ [in src [in P]])}");
    }

    public void testRenamePF2() throws CoreException {
        this.createFolder("/P/src/x/y/z");
        this.createFile("/P/src/x/y/z/A.js", "package x.y.z;\npublic class A {\n}");
        IPackageFragment frag = this.getPackage("/P/src/x/y/z");
        this.clearDeltas();
        frag.rename("x.y. z2", false, null);
        IPackageFragment newFrag = this.getPackage("/P/src/x/y/z2");
        RenameTests.assertTrue((String)"Old package should not exist", (!frag.exists() ? 1 : 0) != 0);
        RenameTests.assertTrue((String)"New package should exist", (boolean)newFrag.exists());
        IJavaScriptUnit compilationUnit = newFrag.getJavaScriptUnit("A.js");
        RenameTests.assertTrue((String)"A.java should exits in new package", (boolean)compilationUnit.exists());
        IType[] types = compilationUnit.getTypes();
        RenameTests.assertTrue((types != null && types.length == 1 ? 1 : 0) != 0);
        IType mainType = types[0];
        RenameTests.assertEquals((String)"Unexpected A.java's main type'", (String)"x.y.z2.A", (String)mainType.getFullyQualifiedName());
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tx.y.z[-]: {MOVED_TO(x.y.z2 [in src [in P]])}\n\t\tx.y.z2[+]: {MOVED_FROM(x.y.z [in src [in P]])}");
    }

    public void testRenamePF3() throws CoreException {
        this.createFolder("/P/src/x");
        this.createFile("/P/src/x/A.js", "package x;\npublic class A {\n}");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RenameTests.this.getPackage("/P/src/x").rename("x.y", false, null);
                IType type = RenameTests.this.getJavaProject("P").findType("x.y.A");
                RenameTests.this.assertTypesEqual("Unepected type", "x.y.A\n", new IType[]{type});
            }
        };
        this.getWorkspace().run(runnable, null);
    }

    public void testRenamePFWithSubPackages() throws CoreException {
        this.createFolder("/P/src/x/y/z");
        this.createFile("/P/src/x/y/z/A.js", "package x.y.z;\npublic class A {\n}");
        this.clearDeltas();
        this.getPackage("/P/src/x").rename("newX", false, null);
        IPackageFragment oldFrag = this.getPackage("/P/src/x/y/z");
        RenameTests.assertTrue((String)"Old inner package should still exist", (boolean)oldFrag.exists());
        IPackageFragment newFrag = this.getPackage("/P/src/newX");
        RenameTests.assertTrue((String)"New package should exist", (boolean)newFrag.exists());
        IJavaScriptUnit compilationUnit = oldFrag.getJavaScriptUnit("A.js");
        RenameTests.assertTrue((String)"A.java should exits in old inner package", (boolean)compilationUnit.exists());
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tnewX[+]: {}");
    }

    public void testRenameSyntaxErrorMethod() throws CoreException {
        this.createFile("/P/src/Y.js", "public class Y {\n  void foo( {\n  }\n}");
        IFunction method = this.getCompilationUnit("/P/src/Y.js").getType("Y").getFunction("foo", null);
        this.renamePositive((IJavaScriptElement)method, "newFoo", false);
    }

    public void testRenameWithInvalidRenamings() {
        IFunction method = this.getCompilationUnit("/P/src/X.js").getType("X").getFunction("foo", null);
        this.renameNegative(new IJavaScriptElement[]{method}, new String[]{"", ""}, false, 980);
        this.renameNegative(new IJavaScriptElement[]{method}, null, false, 982);
    }

    public void testRenameWorkingCopy() throws JavaScriptModelException {
        IJavaScriptUnit copy = null;
        try {
            copy = this.cu.getWorkingCopy(null);
            this.renameNegative((IJavaScriptElement)copy, "NewX", false, 967);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }
}

