/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.swing;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableCellEditorAdapter
extends AbstractCellEditor
implements TableCellEditor {
    private Renderer renderer;
    private static final long serialVersionUID = 1L;

    private TableCellEditorAdapter() {
    }

    public TableCellEditorAdapter(Renderer renderer) {
        this();
        this.initialize(renderer);
    }

    protected void initialize(Renderer r) {
        this.renderer = r;
        r.setImmediateEditListener(this.buildImmediateEditListener());
    }

    private ImmediateEditListener buildImmediateEditListener() {
        return new ImmediateEditListener(){

            @Override
            public void immediateEdit() {
                TableCellEditorAdapter.this.stopCellEditing();
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        return this.renderer.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        return this.renderer.getTableCellRendererComponent(table, value, selected, true, row, column);
    }

    public static interface ImmediateEditListener {
        public void immediateEdit();
    }

    public static interface Renderer
    extends TableCellRenderer {
        public Object getValue();

        public void setImmediateEditListener(ImmediateEditListener var1);
    }
}

