/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters;

import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.core.JEMPlugin;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.util.logger.proxy.Logger;

public abstract class ReflectionAdaptor
extends AdapterImpl
implements ReadAdaptor {
    public static final char C_CLASS_MEMBER_DELIMITER = '.';
    public static final char C_METHOD_PARM_DELIMITER = '(';
    public static final char C_METHODID_PARMID_DELIMITER = '-';
    public static final char C_PARM_PARM_DELIMITER = ',';
    public static final char PATH_DELIMITER = '/';
    public static final String S_CONSTRUCTOR_TOKEN = "_V";
    protected static String[] emptyStringArray = new String[0];
    public static final int EVENT = -3456;
    public static final EAttribute REFLECTION_EVENT = EcoreFactory.eINSTANCE.createEAttribute();
    protected boolean hasReflected = false;
    protected boolean isReflecting = false;

    static {
        REFLECTION_EVENT.setName("reflectValues");
    }

    public ReflectionAdaptor() {
    }

    public ReflectionAdaptor(Notifier target) {
        this.setTarget(target);
    }

    public static void forceDeferredReadFor(EObject target) {
        ReflectionAdaptor adaptor = ReflectionAdaptor.retrieveAdaptorFrom(target);
        if (adaptor != null) {
            adaptor.reflectValuesIfNecessary();
        }
    }

    protected Resource getTargetResource() {
        if (this.getTarget() != null) {
            return ((EObject)this.getTarget()).eResource();
        }
        return null;
    }

    public static Object getValue(EObject object, EReference attribute) {
        return object.eGet((EStructuralFeature)attribute);
    }

    public static Object getValue(EObject object, EObject attribute) {
        return object.eGet((EStructuralFeature)attribute);
    }

    @Override
    public Object getValueIn(EObject object, EObject attribute) {
        return object.eGet((EStructuralFeature)attribute);
    }

    public boolean isAdapterForType(Object type) {
        return type == "JavaReflection";
    }

    public abstract boolean reflectValues();

    @Override
    public synchronized boolean reflectValuesIfNecessary() {
        block8: {
            if (!this.hasReflected && !this.isReflecting) {
                try {
                    try {
                        this.isReflecting = true;
                        EObject etarget = (EObject)this.getTarget();
                        if (!etarget.eIsProxy() && etarget.eResource() != null && etarget.eResource().getResourceSet() != null) {
                            this.hasReflected = this.reflectValues();
                            break block8;
                        }
                        this.hasReflected = false;
                    }
                    catch (Exception e) {
                        this.hasReflected = false;
                        Logger logger = Logger.getLogger();
                        if (logger.isLoggingLevel(Level.WARNING)) {
                            logger.log((Object)ResourceHandler.getString("Failed_reflecting_values_ERROR_"), Level.WARNING);
                            logger.logWarning((Throwable)e);
                            JEMPlugin.logWarning(ResourceHandler.getString("Failed_reflecting_values_ERROR_"), e);
                        }
                        this.isReflecting = false;
                        this.getTarget().eNotify((Notification)new ENotificationImpl((InternalEObject)this.getTarget(), -3456, (EStructuralFeature)REFLECTION_EVENT, null, null, -1));
                    }
                }
                finally {
                    this.isReflecting = false;
                    this.getTarget().eNotify((Notification)new ENotificationImpl((InternalEObject)this.getTarget(), -3456, (EStructuralFeature)REFLECTION_EVENT, null, null, -1));
                }
            }
        }
        return this.hasReflected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectionAdaptor retrieveAdaptorFrom(EObject object) {
        EObject eObject = object;
        synchronized (eObject) {
            return (ReflectionAdaptor)EcoreUtil.getRegisteredAdapter((EObject)object, (Object)"JavaReflection");
        }
    }
}

