/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.utils.HTMLSpecialCharHelper;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;

public class EntityMap {
    private static Logger _log = PDPlugin.getLogger(EntityMap.class);

    public static String translate(String s) {
        char[] array = s.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int posi = 0;
        int len = array.length;
        while (posi < len) {
            if (array[posi] != '&') {
                buffer.append(EntityMap.replaceBadEntity(array[posi++]));
                continue;
            }
            int lastPosi = posi++;
            if (posi < len && array[posi] == '#') {
                ++posi;
            }
            while (posi < len) {
                if (!Character.isLetterOrDigit(array[posi])) break;
                ++posi;
            }
            String str = new String(array, lastPosi, posi - lastPosi);
            if (EntityMap.translateEntity(str, buffer) && posi < len && array[posi] == ';') {
                ++posi;
            }
            if (posi != len) continue;
            return buffer.toString();
        }
        return buffer.toString();
    }

    public static String translateAndCompact(String s) {
        char[] array = s.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int posi = 0;
        int len = array.length;
        while (posi < len) {
            if (HTMLUtil.isHTMLWhitespace(array[posi])) {
                while (++posi < len && HTMLUtil.isHTMLWhitespace(array[posi])) {
                }
                buffer.append(' ');
                continue;
            }
            if (array[posi] != '&') {
                buffer.append(EntityMap.replaceBadEntity(array[posi++]));
                continue;
            }
            int lastPosi = posi++;
            if (posi < len && array[posi] == '#') {
                ++posi;
            }
            while (posi < len) {
                if (!Character.isLetterOrDigit(array[posi])) break;
                ++posi;
            }
            String str = new String(array, lastPosi, posi - lastPosi);
            if (EntityMap.translateEntity(str, buffer) && posi < len && array[posi] == ';') {
                ++posi;
            }
            if (posi != len) continue;
            return buffer.toString();
        }
        return buffer.toString();
    }

    public static boolean translateEntity(String s, StringBuffer strBuf) {
        int i = HTMLSpecialCharHelper.getSpecial(s);
        if (i != -1) {
            strBuf.append((char)i);
            return true;
        }
        if (s.length() > 2 && s.charAt(1) == '#') {
            String number = s.substring(2);
            try {
                int n = number.length() > 0 && (number.charAt(0) == 'x' || number.charAt(0) == 'X') ? Integer.parseInt(number.substring(1), 16) : Integer.parseInt(number);
                strBuf.append(EntityMap.replaceBadEntity((char)n));
                return true;
            }
            catch (Exception ex) {
                _log.info("Error occurred in integer formatting", (Throwable)ex);
                strBuf.append(s);
                return false;
            }
        }
        strBuf.append(s);
        return false;
    }

    private static char replaceBadEntity(char n) {
        if (n < '\u0084' || n > '\u009c') {
            return n;
        }
        switch (n) {
            case '\u0084': {
                return '\u201e';
            }
            case '\u0085': {
                return '\u2026';
            }
            case '\u0086': {
                return '\u2020';
            }
            case '\u0087': {
                return '\u2021';
            }
            case '\u008b': {
                return '\u2039';
            }
            case '\u008c': {
                return '\u0152';
            }
            case '\u0091': {
                return '\u2018';
            }
            case '\u0092': {
                return '\u2019';
            }
            case '\u0093': {
                return '\u201c';
            }
            case '\u0094': {
                return '\u201d';
            }
            case '\u0095': {
                return '\u2022';
            }
            case '\u0097': {
                return '\u2014';
            }
            case '\u0099': {
                return '\u2122';
            }
            case '\u009b': {
                return '\u203a';
            }
            case '\u009c': {
                return '\u0153';
            }
        }
        return n;
    }
}

