/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.jsdtbridge;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AdHocFormatter {
    public static TextEdit format(String source, String header) {
        FormatSession session = new FormatSession(source, header);
        session.run();
        return session.getResult();
    }

    private static class FormatSession {
        private int position = 0;
        private final String header;
        private final String source;
        private final SpaceCache spaceCache = new SpaceCache();
        private final MultiTextEdit result = new MultiTextEdit();
        private LastSeenState currentState = LastSeenState.NEW_LINE;
        private int currentNesting = 0;

        FormatSession(String source, String header) {
            this.source = source;
            this.header = header;
        }

        void run() {
            this.result.addChild((TextEdit)new ReplaceEdit(0, 0, this.header));
            while (this.position < this.source.length()) {
                char ch = this.source.charAt(this.position);
                switch (ch) {
                    case ';': {
                        this.handleSemicolon();
                        break;
                    }
                    case '{': {
                        this.handleOpenBrace();
                        break;
                    }
                    case '}': {
                        this.handleCloseBrace();
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        this.handleLineEnd();
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    default: {
                        this.handleNonSpace();
                    }
                }
                ++this.position;
            }
        }

        TextEdit getResult() {
            return this.result;
        }

        private void handleLineEnd() {
            this.currentState = LastSeenState.NEW_LINE;
        }

        private void handleSemicolon() {
            this.currentState = LastSeenState.SEMICOLON;
        }

        private void handleOpenBrace() {
            if (this.currentState == LastSeenState.SEMICOLON || this.currentState == LastSeenState.CLOSE_BRACE || this.currentState == LastSeenState.OPEN_BRACE) {
                this.insertNewLine();
            }
            ++this.currentNesting;
            this.currentState = LastSeenState.OPEN_BRACE;
        }

        private void handleCloseBrace() {
            if (this.currentNesting > 0) {
                --this.currentNesting;
            }
            if (this.currentState != LastSeenState.NEW_LINE) {
                this.insertNewLine();
            }
            this.currentState = LastSeenState.CLOSE_BRACE;
        }

        private void handleNonSpace() {
            if (this.currentState == LastSeenState.SEMICOLON || this.currentState == LastSeenState.CLOSE_BRACE || this.currentState == LastSeenState.OPEN_BRACE) {
                this.insertNewLine();
            }
            this.currentState = LastSeenState.NON_SPACE;
        }

        private void insertNewLine() {
            this.result.addChild((TextEdit)new ReplaceEdit(this.position, 0, this.spaceCache.getSpace(this.currentNesting * 2)));
        }

        private static enum LastSeenState {
            OPEN_BRACE,
            CLOSE_BRACE,
            SEMICOLON,
            NEW_LINE,
            NON_SPACE;

        }

        private static class SpaceCache {
            private final Map<Integer, String> map = new HashMap<Integer, String>();

            private SpaceCache() {
            }

            public String getSpace(int len) {
                String result = this.map.get(len);
                if (result == null) {
                    StringBuilder builder = new StringBuilder(len + 1);
                    builder.append('\n');
                    int i = 0;
                    while (i < len) {
                        builder.append(' ');
                        ++i;
                    }
                    result = builder.toString();
                    this.map.put(len, result);
                }
                return result;
            }
        }
    }
}

