/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.search.actions;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.core.search.scope.WorkspaceSearchScope;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Binding;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Interface;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Message;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;
import org.eclipse.wst.xsd.ui.internal.editor.ISelectionMapper;
import org.eclipse.wst.xsd.ui.internal.search.XSDSearchQuery;
import org.eclipse.wst.xsd.ui.internal.search.actions.FindAction;

public class WSDLFindReferencesAction
extends FindAction {
    private WSDLBaseAdapter component;
    private IFile file;
    private QualifiedName[] names;

    public WSDLFindReferencesAction(IEditorPart editor) {
        super(editor);
        this.init();
    }

    protected void init() {
        this.component = this.getWSDLNamedComponent();
        this.file = this.getCurrentFile();
        this.names = this.determineMetaAndQualifiedName(this.component);
        if (this.file == null || this.component == null || this.names == null) {
            this.setEnabled(false);
        }
    }

    public void setActionDefinitionId(String string) {
    }

    protected IFile getCurrentFile() {
        IEditorInput input;
        if (this.editor != null && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            return fileEditorInput.getFile();
        }
        return null;
    }

    protected QualifiedName[] determineMetaAndQualifiedName(WSDLBaseAdapter component) {
        QualifiedName[] names = null;
        if (component instanceof W11Message) {
            names = new QualifiedName[2];
            names[0] = IWSDLSearchConstants.MESSAGE_META_NAME;
            QName qName = ((Message)component.getTarget()).getQName();
            names[1] = new QualifiedName(qName.getNamespaceURI(), qName.getLocalPart());
        } else if (component instanceof W11Interface) {
            names = new QualifiedName[2];
            names[0] = IWSDLSearchConstants.PORT_TYPE_META_NAME;
            QName qName = ((PortType)component.getTarget()).getQName();
            names[1] = new QualifiedName(qName.getNamespaceURI(), qName.getLocalPart());
        } else if (component instanceof W11Binding) {
            names = new QualifiedName[2];
            names[0] = IWSDLSearchConstants.BINDING_META_NAME;
            QName qName = ((Binding)component.getTarget()).getQName();
            names[1] = new QualifiedName(qName.getNamespaceURI(), qName.getLocalPart());
        }
        return names;
    }

    protected WSDLBaseAdapter getWSDLNamedComponent() {
        if (this.editor != null) {
            ISelectionProvider provider = (ISelectionProvider)this.editor.getAdapter(ISelectionProvider.class);
            ISelectionMapper mapper = (ISelectionMapper)this.editor.getAdapter(ISelectionMapper.class);
            if (provider != null) {
                IStructuredSelection s;
                Object o;
                ISelection selection = provider.getSelection();
                if (mapper != null) {
                    selection = mapper.mapSelection(selection);
                }
                if (selection != null && selection instanceof IStructuredSelection && (o = (s = (IStructuredSelection)selection).getFirstElement()) != null && o instanceof WSDLBaseAdapter) {
                    return (WSDLBaseAdapter)o;
                }
            }
        }
        return null;
    }

    public void run() {
        String pattern = "";
        if (this.file != null && this.component != null && this.names != null) {
            WorkspaceSearchScope scope = new WorkspaceSearchScope();
            String scopeDescription = "Workspace";
            XSDSearchQuery searchQuery = new XSDSearchQuery(pattern, this.file, this.names[1], this.names[0], 2, (SearchScope)scope, scopeDescription);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
        }
    }
}

