/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.internal.factory.FactoryTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class MapToolsTests
extends TestCase {
    public static final Transformer<String, String> REVERSE_STRING_TRANSFORMER = new ReverseStringTransformer();
    public static final Transformer<String, String> SORT_STRING_TRANSFORMER = new SortStringTransformer();

    public MapToolsTests(String name) {
        super(name);
    }

    public void testGetMapObjectObject() {
        Map<String, String> map = this.buildMap();
        MapToolsTests.assertEquals((String)"one", (String)((String)MapTools.get(map, (Object)"1", (Object)"")));
        MapToolsTests.assertEquals((String)"", (String)((String)MapTools.get(map, (Object)"7", (Object)"")));
        MapToolsTests.assertEquals((String)"", (String)map.get("7"));
        map.put("7", null);
        MapToolsTests.assertEquals(null, (String)((String)MapTools.get(map, (Object)"7", (Object)"")));
    }

    public void testGet_MapObjectObject() {
        Map<String, String> map = this.buildMap();
        MapToolsTests.assertEquals((String)"one", (String)((String)MapTools.get_(map, (Object)"1", (Object)"")));
        MapToolsTests.assertEquals((String)"", (String)((String)MapTools.get_(map, (Object)"7", (Object)"")));
        MapToolsTests.assertEquals((String)"", (String)map.get("7"));
        map.put("7", null);
        MapToolsTests.assertEquals((String)"", (String)((String)MapTools.get_(map, (Object)"7", (Object)"")));
    }

    public void testGetMapObjectFactory() {
        Factory factory = FactoryTools.staticFactory((Object)"");
        Map<String, String> map = this.buildMap();
        MapToolsTests.assertEquals((String)"one", (String)((String)MapTools.get(map, (Object)"1", (Factory)factory)));
        MapToolsTests.assertEquals((String)"", (String)((String)MapTools.get(map, (Object)"7", (Factory)factory)));
        MapToolsTests.assertEquals((String)"", (String)map.get("7"));
        map.put("7", null);
        MapToolsTests.assertEquals(null, (String)((String)MapTools.get(map, (Object)"7", (Factory)factory)));
    }

    public void testGet_MapObjectFactory() {
        Factory factory = FactoryTools.staticFactory((Object)"");
        Map<String, String> map = this.buildMap();
        MapToolsTests.assertEquals((String)"one", (String)((String)MapTools.get_(map, (Object)"1", (Factory)factory)));
        MapToolsTests.assertEquals((String)"", (String)((String)MapTools.get_(map, (Object)"7", (Factory)factory)));
        MapToolsTests.assertEquals((String)"", (String)map.get("7"));
        map.put("7", null);
        MapToolsTests.assertEquals((String)"", (String)((String)MapTools.get_(map, (Object)"7", (Factory)factory)));
    }

    public void testGetMapObjectClass() {
        ArrayList list = new ArrayList();
        Map<String, ArrayList<String>> map = this.buildListMap();
        MapToolsTests.assertEquals(list, (Object)MapTools.get(map, (Object)"1", ArrayList.class));
        MapToolsTests.assertEquals(list, (Object)MapTools.get(map, (Object)"7", ArrayList.class));
        map.put("7", null);
        MapToolsTests.assertEquals(null, (Object)MapTools.get(map, (Object)"7", ArrayList.class));
    }

    public void testGet_MapObjectClass() {
        ArrayList list = new ArrayList();
        Map<String, ArrayList<String>> map = this.buildListMap();
        MapToolsTests.assertEquals(list, (Object)MapTools.get_(map, (Object)"1", ArrayList.class));
        MapToolsTests.assertEquals(list, (Object)MapTools.get_(map, (Object)"7", ArrayList.class));
        map.put("7", null);
        MapToolsTests.assertEquals(list, (Object)MapTools.get_(map, (Object)"7", ArrayList.class));
    }

    public void testGetMapObjectClassClassObject() {
        ArrayList list = new ArrayList();
        Map<String, ArrayList<String>> map = this.buildListMap();
        MapToolsTests.assertEquals(list, (Object)MapTools.get(map, (Object)"1", ArrayList.class, Collection.class, new ArrayList()));
        MapToolsTests.assertEquals(list, (Object)MapTools.get(map, (Object)"7", ArrayList.class, Collection.class, new ArrayList()));
        map.put("7", null);
        MapToolsTests.assertEquals(null, (Object)MapTools.get(map, (Object)"7", ArrayList.class, Collection.class, new ArrayList()));
    }

    public void testGet_MapObjectClassClassObject() {
        ArrayList list = new ArrayList();
        Map<String, ArrayList<String>> map = this.buildListMap();
        MapToolsTests.assertEquals(list, (Object)MapTools.get_(map, (Object)"1", ArrayList.class, Collection.class, new ArrayList()));
        MapToolsTests.assertEquals(list, (Object)MapTools.get_(map, (Object)"7", ArrayList.class, Collection.class, new ArrayList()));
        map.put("7", null);
        MapToolsTests.assertEquals(new ArrayList(), (Object)MapTools.get_(map, (Object)"7", ArrayList.class, Collection.class, new ArrayList()));
    }

    public void testAddMapObjectTransformer() {
        HashMap map = new HashMap();
        MapToolsTests.assertEquals(null, (String)((String)MapTools.add(map, (Object)"one", REVERSE_STRING_TRANSFORMER)));
        MapToolsTests.assertEquals((String)"one", (String)((String)map.get("eno")));
    }

    public void testAddMapObjectTransformerTransformer() {
        HashMap map = new HashMap();
        MapToolsTests.assertEquals(null, (String)((String)MapTools.add(map, (Object)"cczzaa", REVERSE_STRING_TRANSFORMER, SORT_STRING_TRANSFORMER)));
        MapToolsTests.assertEquals((String)"aacczz", (String)((String)map.get("aazzcc")));
    }

    public void testAddAllMapIterableTransformer() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("foo");
        strings.add("bar");
        strings.add("baz");
        HashMap map = new HashMap();
        MapTools.addAll(map, strings, REVERSE_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"bar", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"baz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapQueueTransformer() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("foo");
        strings.add("bar");
        strings.add("baz");
        ArrayQueue queue = QueueTools.arrayQueue(strings);
        HashMap map = new HashMap();
        QueueTools.drainTo((Queue)queue, map, REVERSE_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"bar", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"baz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapStackTransformer() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("foo");
        strings.add("bar");
        strings.add("baz");
        ArrayStack stack = StackTools.arrayStack(strings);
        HashMap map = new HashMap();
        StackTools.popAllTo((Stack)stack, map, REVERSE_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"bar", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"baz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapTransformerArray() {
        HashMap map = new HashMap();
        MapTools.addAll(map, REVERSE_STRING_TRANSFORMER, (Object[])new String[]{"foo", "bar", "baz"});
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"bar", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"baz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapIterableTransformerTransformer() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("foo");
        strings.add("bar");
        strings.add("baz");
        HashMap map = new HashMap();
        MapTools.addAll(map, strings, REVERSE_STRING_TRANSFORMER, SORT_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"abr", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"abz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapQueueTransformerTransformer() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("foo");
        strings.add("bar");
        strings.add("baz");
        ArrayQueue queue = QueueTools.arrayQueue(strings);
        HashMap map = new HashMap();
        QueueTools.drainTo((Queue)queue, map, REVERSE_STRING_TRANSFORMER, SORT_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"abr", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"abz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapStackTransformerTransformer() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("foo");
        strings.add("bar");
        strings.add("baz");
        ArrayStack stack = StackTools.arrayStack(strings);
        HashMap map = new HashMap();
        StackTools.popAllTo((Stack)stack, map, REVERSE_STRING_TRANSFORMER, SORT_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"abr", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"abz", (String)((String)map.get("zab")));
    }

    public void testAddAllMapTransformerArrayTransformer() {
        HashMap map = new HashMap();
        MapTools.addAll(map, REVERSE_STRING_TRANSFORMER, SORT_STRING_TRANSFORMER, (Object[])new String[]{"foo", "bar", "baz"});
        MapToolsTests.assertEquals((String)"foo", (String)((String)map.get("oof")));
        MapToolsTests.assertEquals((String)"abr", (String)((String)map.get("rab")));
        MapToolsTests.assertEquals((String)"abz", (String)((String)map.get("zab")));
    }

    public void testPutAllMapListList() {
        HashMap map = new HashMap();
        MapTools.putAll(map, this.buildKeys(), this.buildValues());
        MapToolsTests.assertEquals(this.buildMap(), map);
    }

    public void testPutAllMapListList_IAE() {
        HashMap map = new HashMap();
        boolean exCaught = false;
        try {
            List<String> values = this.buildValues();
            values.remove(0);
            MapTools.putAll(map, this.buildKeys(), values);
            MapToolsTests.fail((String)("bogus: " + map));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MapToolsTests.assertTrue((boolean)exCaught);
    }

    public void testPutAllMapArrayArray() {
        HashMap map = new HashMap();
        MapTools.putAll(map, (Object[])this.buildKeys().toArray(StringTools.EMPTY_STRING_ARRAY), (Object[])this.buildValues().toArray(StringTools.EMPTY_STRING_ARRAY));
        MapToolsTests.assertEquals(this.buildMap(), map);
    }

    public void testPutAllMapArrayArray_IAE() {
        HashMap map = new HashMap();
        boolean exCaught = false;
        try {
            Object[] values = this.buildValues().toArray(StringTools.EMPTY_STRING_ARRAY);
            values = (String[])ArrayTools.removeElementAtIndex((Object[])values, (int)0);
            MapTools.putAll(map, (Object[])this.buildKeys().toArray(StringTools.EMPTY_STRING_ARRAY), (Object[])values);
            MapToolsTests.fail((String)("bogus: " + map));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        MapToolsTests.assertTrue((boolean)exCaught);
    }

    public void testContainsAllKeysMapIterable() {
        Map<String, String> map = this.buildMap();
        List<String> keys = this.buildKeys();
        MapToolsTests.assertTrue((boolean)MapTools.containsAllKeys(map, keys));
        map.remove("1");
        MapToolsTests.assertFalse((boolean)MapTools.containsAllKeys(map, keys));
    }

    public void testContainsAllKeysMapArray() {
        Map<String, String> map = this.buildMap();
        Object[] keys = this.buildKeys().toArray(StringTools.EMPTY_STRING_ARRAY);
        MapToolsTests.assertTrue((boolean)MapTools.containsAllKeys(map, (Object[])keys));
        map.remove("1");
        MapToolsTests.assertFalse((boolean)MapTools.containsAllKeys(map, (Object[])keys));
    }

    public void testContainsAllValuesMapIterable() {
        Map<String, String> map = this.buildMap();
        List<String> values = this.buildValues();
        MapToolsTests.assertTrue((boolean)MapTools.containsAllValues(map, values));
        map.remove("1");
        MapToolsTests.assertFalse((boolean)MapTools.containsAllValues(map, values));
    }

    public void testContainsAllValuesMapArray() {
        Map<String, String> map = this.buildMap();
        Object[] values = this.buildValues().toArray(StringTools.EMPTY_STRING_ARRAY);
        MapToolsTests.assertTrue((boolean)MapTools.containsAllValues(map, (Object[])values));
        map.remove("1");
        MapToolsTests.assertFalse((boolean)MapTools.containsAllValues(map, (Object[])values));
    }

    public void testRemoveAllMapIterable() {
        Map<String, String> map = this.buildMap();
        List<String> keys = this.buildKeys();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.removeAll(map, keys);
        MapToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testRemoveAllMapArray() {
        Map<String, String> map = this.buildMap();
        Object[] keys = this.buildKeys().toArray(StringTools.EMPTY_STRING_ARRAY);
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.removeAll(map, (Object[])keys);
        MapToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testRetainAllMapCollection() {
        Map<String, String> map = this.buildMap();
        List<String> keys = this.buildKeys();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, keys);
        MapToolsTests.assertEquals(this.buildMap(), map);
        keys.remove("3");
        MapTools.retainAll(map, keys);
        MapToolsTests.assertFalse((boolean)map.containsKey("3"));
    }

    public void testRetainAllMapCollection_empty() {
        Map<String, String> map = this.buildMap();
        ArrayList keys = new ArrayList();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, keys);
        MapToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testRetainAllMapIterable() {
        Map<String, String> map = this.buildMap();
        List<String> keys = this.buildKeys();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, keys);
        MapToolsTests.assertEquals(this.buildMap(), map);
        List<String> temp = this.buildKeys();
        temp.remove("3");
        keys = temp;
        MapTools.retainAll(map, keys);
        MapToolsTests.assertFalse((boolean)map.containsKey("3"));
    }

    public void testRetainAllMapIterable_empty() {
        Map<String, String> map = this.buildMap();
        ArrayList keys = new ArrayList();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, keys);
        MapToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testRetainAllMapIterableInt() {
        Map<String, String> map = this.buildMap();
        List<String> keys = this.buildKeys();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, keys, (int)77);
        MapToolsTests.assertEquals(this.buildMap(), map);
        List<String> temp = this.buildKeys();
        temp.remove("3");
        keys = temp;
        MapTools.retainAll(map, keys);
        MapToolsTests.assertFalse((boolean)map.containsKey("3"));
    }

    public void testRetainAllMapIterableInt_empty() {
        Map<String, String> map = this.buildMap();
        ArrayList keys = new ArrayList();
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, keys, (int)77);
        MapToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testRetainAllMapArray() {
        Map<String, String> map = this.buildMap();
        Object[] keys = this.buildKeys().toArray(StringTools.EMPTY_STRING_ARRAY);
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, (Object[])keys);
        MapToolsTests.assertEquals(this.buildMap(), map);
        keys = (String[])ArrayTools.remove((Object[])keys, (Object)"3");
        MapTools.retainAll(map, (Object[])keys);
        MapToolsTests.assertFalse((boolean)map.containsKey("3"));
    }

    public void testRetainAllMapArray_empty() {
        Map<String, String> map = this.buildMap();
        Object[] keys = StringTools.EMPTY_STRING_ARRAY;
        MapToolsTests.assertFalse((boolean)map.isEmpty());
        MapTools.retainAll(map, (Object[])keys);
        MapToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testInvertMap() {
        HashMap map = this.buildMap();
        map = MapTools.invert(map);
        List<String> keys = this.buildValues();
        List<String> values = this.buildKeys();
        int i = 0;
        while (i < keys.size()) {
            MapToolsTests.assertEquals((String)values.get(i), (String)((String)map.get(keys.get(i))));
            ++i;
        }
    }

    public void testFilterMapPredicate() {
        HashMap map = this.buildMap();
        map = MapTools.filter(map, (Predicate)new StringLengthPredicate(3));
        MapToolsTests.assertEquals(null, (String)((String)map.get("0")));
        MapToolsTests.assertFalse((boolean)map.containsKey("0"));
        MapToolsTests.assertEquals((String)"one", (String)((String)map.get("1")));
        MapToolsTests.assertEquals((String)"two", (String)((String)map.get("2")));
        MapToolsTests.assertEquals(null, (String)((String)map.get("3")));
        MapToolsTests.assertFalse((boolean)map.containsKey("3"));
        MapToolsTests.assertEquals(null, (String)((String)map.get("4")));
        MapToolsTests.assertFalse((boolean)map.containsKey("4"));
    }

    public void testTransformMapTransformer() {
        HashMap map = this.buildMap();
        map = MapTools.transform(map, REVERSE_STRING_TRANSFORMER);
        MapToolsTests.assertEquals((String)"orez", (String)((String)map.get("0")));
        MapToolsTests.assertEquals((String)"eno", (String)((String)map.get("1")));
        MapToolsTests.assertEquals((String)"owt", (String)((String)map.get("2")));
        MapToolsTests.assertEquals((String)"eerht", (String)((String)map.get("3")));
        MapToolsTests.assertEquals((String)"ruof", (String)((String)map.get("4")));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(MapTools.class);
                MapToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        MapToolsTests.assertTrue((boolean)exCaught);
    }

    private List<String> buildKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("0");
        keys.add("1");
        keys.add("2");
        keys.add("3");
        keys.add("4");
        return keys;
    }

    private List<String> buildValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("zero");
        values.add("one");
        values.add("two");
        values.add("three");
        values.add("four");
        return values;
    }

    private Map<String, String> buildMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "zero");
        map.put("1", "one");
        map.put("2", "two");
        map.put("3", "three");
        map.put("4", "four");
        return map;
    }

    private Map<String, ArrayList<String>> buildListMap() {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("0", new ArrayList());
        map.put("1", new ArrayList());
        map.put("2", new ArrayList());
        map.put("3", new ArrayList());
        map.put("4", new ArrayList());
        return map;
    }

    public static class ReverseStringTransformer
    extends AbstractTransformer<String, String> {
        protected String transform_(String input) {
            return StringTools.reverse((String)input);
        }
    }

    public static class SortStringTransformer
    extends AbstractTransformer<String, String> {
        protected String transform_(String input) {
            return new String(ArrayTools.sort((char[])input.toCharArray()));
        }
    }

    public static class StringLengthPredicate
    extends PredicateAdapter<String> {
        private final int length;

        public StringLengthPredicate(int length) {
            this.length = length;
        }

        public boolean evaluate(String s) {
            return s.length() == this.length;
        }
    }
}

