/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.NullList;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class NullListTests
extends TestCase {
    public NullListTests(String name) {
        super(name);
    }

    public void testAddObject() {
        List list = NullList.instance();
        NullListTests.assertFalse((boolean)list.add("foo"));
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testAddIntObject() {
        List list = NullList.instance();
        list.add(0, "foo");
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testAddAllCollection() {
        List list = NullList.instance();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("bar");
        NullListTests.assertFalse((boolean)list.addAll(collection));
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testAddAllIntCollection() {
        List list = NullList.instance();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("bar");
        NullListTests.assertFalse((boolean)list.addAll(0, collection));
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testClear() {
        List list = NullList.instance();
        list.clear();
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testContainsObject() {
        List list = NullList.instance();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("bar");
        NullListTests.assertFalse((boolean)list.addAll(collection));
        NullListTests.assertFalse((boolean)list.contains("foo"));
        NullListTests.assertFalse((boolean)list.contains("bar"));
        NullListTests.assertFalse((boolean)list.contains("XXX"));
    }

    public void testContainsAllCollection() {
        List list = NullList.instance();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("bar");
        NullListTests.assertFalse((boolean)list.addAll(collection));
        NullListTests.assertFalse((boolean)list.containsAll(collection));
        collection.clear();
        NullListTests.assertTrue((boolean)list.containsAll(collection));
    }

    public void testGetInt() {
        List list = NullList.instance();
        boolean exCaught = false;
        try {
            list.get(0);
            NullListTests.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
    }

    public void testIndexOfObject() {
        List list = NullList.instance();
        NullListTests.assertEquals((int)-1, (int)list.indexOf("foo"));
    }

    public void testIsEmpty() {
        List list = NullList.instance();
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testIterator() {
        List list = NullList.instance();
        NullListTests.assertTrue((boolean)IteratorTools.isEmpty(list.iterator()));
    }

    public void testLastIndexOfObject() {
        List list = NullList.instance();
        NullListTests.assertEquals((int)-1, (int)list.lastIndexOf("foo"));
    }

    public void testListIterator() {
        List list = NullList.instance();
        NullListTests.assertTrue((boolean)IteratorTools.isEmpty(list.listIterator()));
    }

    public void testListIteratorInt() {
        List list = NullList.instance();
        ListIterator iterator = list.listIterator(0);
        NullListTests.assertTrue((boolean)IteratorTools.isEmpty(iterator));
        boolean exCaught = false;
        try {
            iterator = list.listIterator(1);
            NullListTests.fail((String)("bogus list iterator: " + iterator));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveObject() {
        List list = NullList.instance();
        NullListTests.assertFalse((boolean)list.remove("foo"));
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testRemoveInt() {
        List list = NullList.instance();
        boolean exCaught = false;
        try {
            String object = (String)list.remove(0);
            NullListTests.fail((String)("bogus element: " + object));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testRemoveAllCollection() {
        List list = NullList.instance();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("bar");
        NullListTests.assertFalse((boolean)list.removeAll(collection));
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testRetainAllCollection() {
        List list = NullList.instance();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("bar");
        NullListTests.assertFalse((boolean)list.retainAll(collection));
        NullListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testSetIntObject() {
        List list = NullList.instance();
        boolean exCaught = false;
        try {
            String element = list.set(0, "foo");
            NullListTests.fail((String)("bogus set: " + element));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
    }

    public void testSize() {
        List list = NullList.instance();
        NullListTests.assertEquals((int)0, (int)list.size());
    }

    public void testSubList() {
        List list = NullList.instance();
        List subList = list.subList(0, 0);
        NullListTests.assertTrue((boolean)subList.isEmpty());
        boolean exCaught = false;
        try {
            subList = list.subList(0, 3);
            NullListTests.fail((String)("bogus sub list: " + subList));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            subList = list.subList(3, 0);
            NullListTests.fail((String)("bogus sub list: " + subList));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            subList = list.subList(3, 3);
            NullListTests.fail((String)("bogus sub list: " + subList));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        NullListTests.assertTrue((boolean)exCaught);
        subList = list.subList(0, 0);
        NullListTests.assertTrue((boolean)subList.isEmpty());
    }

    public void testToArray() {
        List list = NullList.instance();
        NullListTests.assertEquals((int)0, (int)list.toArray().length);
    }

    public void testToArrayObjectArray() {
        List list = NullList.instance();
        NullListTests.assertEquals((int)0, (int)list.toArray(ObjectTools.EMPTY_OBJECT_ARRAY).length);
    }

    public void testSerialization() throws Exception {
        List list = NullList.instance();
        NullListTests.assertSame((Object)list, (Object)TestTools.serialize(list));
    }

    public void testToString() {
        List list = NullList.instance();
        NullListTests.assertEquals((String)"[]", (String)list.toString());
    }
}

