/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.exception.NullExceptionHandler;

public abstract class AbstractSafeCommandContext<E extends CommandContext>
implements CommandContext {
    protected final E commandContext;
    protected final ExceptionHandler exceptionHandler;

    protected AbstractSafeCommandContext(E commandContext) {
        this(commandContext, NullExceptionHandler.instance());
    }

    protected AbstractSafeCommandContext(E commandContext, ExceptionHandler exceptionHandler) {
        if (commandContext == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.commandContext = commandContext;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute(Command command) {
        try {
            this.commandContext.execute(command);
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commandContext);
    }
}

