/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation.ValidationTestsSetUp;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;

public class EndpointIsSessionBeanRuleTest
extends ValidationTestsSetUp {
    private TestProject ejbProject;
    private TestProject webProject;
    private static final String CU_NAME = "MyTestClass";
    private static final String CU_PACKAGE = "test";
    private static final String CU_CONTENT = MessageFormat.format("public class {0} '{'public void test()'{'}}", "MyTestClass");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestProjectsUtils.deleteWorkspaceProjects();
        this.ejbProject = new TestProject(TestProjectsUtils.createEjb3Project((String)("EJB3" + System.currentTimeMillis())).getProject());
        this.createCompilationUnit(this.ejbProject);
        this.ejbProject.setAptProcessingEnabled(true, false);
        this.webProject = new TestProject(TestProjectsUtils.createWeb25Project((String)("Web25" + System.currentTimeMillis())).getProject());
        this.createCompilationUnit(this.webProject);
        this.webProject.setAptProcessingEnabled(true, false);
    }

    @Override
    protected TestProject[] createFixtureProjects() throws CoreException {
        this.ejbProject = new TestProject(TestProjectsUtils.createEjb3Project((String)("EJB3" + System.currentTimeMillis())).getProject());
        this.createCompilationUnit(this.ejbProject);
        this.ejbProject.setAptProcessingEnabled(true, false);
        this.webProject = new TestProject(TestProjectsUtils.createWeb25Project((String)("Web25" + System.currentTimeMillis())).getProject());
        this.createCompilationUnit(this.webProject);
        this.webProject.setAptProcessingEnabled(true, false);
        return new TestProject[]{this.ejbProject, this.webProject};
    }

    private void createCompilationUnit(TestProject project) throws CoreException {
        IPackageFragment pkg = project.createPackage(CU_PACKAGE);
        IType cu = project.createType(pkg, "MyTestClass.java", CU_CONTENT);
        this.refreshAndBuildProject(project);
        this.assertNoValidationErrors(cu.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }

    private void refreshAndBuildProject(final TestProject project) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                project.getProject().build(6, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable((IWorkspaceRunnable)runnable);
    }

    private IType findTestEndpoint(TestProject project) throws JavaModelException {
        IJavaProject javaP = project.getJavaProject();
        IType result = javaP.findType("test.MyTestClass");
        EndpointIsSessionBeanRuleTest.assertNotNull((Object)result);
        return result;
    }

    public void testWsAnnotationOnJavaClassInEjbProject() throws AnnotationGeneratorException, CoreException, IOException, WsDOMLoadCanceledException {
        IType endpointType = this.findTestEndpoint(this.ejbProject);
        IAnnotation wsann = AnnotationFactory.createAnnotation((String)"javax.jws.WebService", (IJavaElement)endpointType, new HashSet());
        AnnotationWriter.getInstance().setAppliedElement(wsann, (IJavaElement)endpointType);
        this.refreshAndBuildProject(this.ejbProject);
        HashMap<String, Object> markersExpectations = new HashMap<String, Object>();
        markersExpectations.put("charStart", 46);
        markersExpectations.put("charEnd", 56);
        markersExpectations.put("lineNumber", 5);
        markersExpectations.put("message", JAXWSCoreMessages.WEBSERVICE_ONLY_ON_STATELESS_OR_SINGLETON_SESSION_BEANS);
        this.validateResourceMarkers(endpointType.getResource(), new ValidationTestsSetUp.MarkerData(this, endpointType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markersExpectations));
    }

    public void testWsAnnotationInEjbStateless() throws AnnotationGeneratorException, CoreException, IOException, WsDOMLoadCanceledException {
        IType endpointType = this.findTestEndpoint(this.ejbProject);
        IAnnotation beanAnnotation = AnnotationFactory.createAnnotation((String)"javax.ejb.Stateless", (IJavaElement)endpointType, new HashSet());
        AnnotationWriter.getInstance().setAppliedElement(beanAnnotation, (IJavaElement)endpointType);
        this.refreshAndBuildProject(this.ejbProject);
        this.assertNoValidationErrors(endpointType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }

    public void testWsAnnotationInWeb() throws AnnotationGeneratorException, CoreException, IOException, WsDOMLoadCanceledException {
        IType endpointType = this.findTestEndpoint(this.webProject);
        IAnnotation wsann = AnnotationFactory.createAnnotation((String)"javax.jws.WebService", (IJavaElement)endpointType, new HashSet());
        AnnotationWriter.getInstance().setAppliedElement(wsann, (IJavaElement)endpointType);
        this.refreshAndBuildProject(this.webProject);
        this.assertNoValidationErrors(endpointType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void disposeFixtureProjects() throws CoreException {
        this.ejbProject.dispose();
        this.webProject.dispose();
    }
}

