/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.jsp.ui.views.contentoutline.JSPContentOutlineConfiguration;
import org.eclipse.jst.pagedesigner.editors.OutlineTargetListenerReader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;

public class OutlineConfiguration
extends JSPContentOutlineConfiguration {
    private Object[] _selections = new Object[0];

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        if (viewer.getInput() instanceof IStructuredModel && selection instanceof ITextSelection) {
            this._selections = this.getSelectedObjects((IStructuredModel)viewer.getInput(), (ITextSelection)selection);
            if (this._selections != null) {
                return super.getSelection(viewer, (ISelection)new StructuredSelection(this._selections));
            }
        } else if (selection instanceof IStructuredSelection) {
            return super.getSelection(viewer, selection);
        }
        return super.getSelection(viewer, (ISelection)new StructuredSelection(this._selections));
    }

    private Object[] getSelectedObjects(IStructuredModel model, ITextSelection selection) {
        Object[] selectedStructures = null;
        if (model != null) {
            IndexedRegion region = model.getIndexedRegion(selection.getOffset());
            int end = selection.getOffset() + selection.getLength();
            if (region != null) {
                if (end <= region.getEndOffset()) {
                    selectedStructures = new Object[]{region};
                } else {
                    int maxLength = model.getStructuredDocument().getLength();
                    ArrayList<IndexedRegion> structures = new ArrayList<IndexedRegion>(2);
                    while (region != null && region.getEndOffset() <= end && region.getEndOffset() < maxLength) {
                        structures.add(region);
                        region = model.getIndexedRegion(region.getEndOffset() + 1);
                    }
                    selectedStructures = structures.toArray();
                }
            }
        }
        if (selectedStructures == null) {
            selectedStructures = new Object[]{};
        }
        return selectedStructures;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(TreeViewer treeViewer) {
        TransferDropTargetListener[] originalListeners = super.getTransferDropTargetListeners(treeViewer);
        List<TransferDropTargetListener> configuredListeners = this.getConfiguredTransferDropTargetListeners();
        TransferDropTargetListener[] consolidated = new TransferDropTargetListener[originalListeners.length + configuredListeners.size()];
        int i = 0;
        for (TransferDropTargetListener configured : configuredListeners) {
            consolidated[i++] = configured;
        }
        TransferDropTargetListener[] transferDropTargetListenerArray = originalListeners;
        int n = originalListeners.length;
        int n2 = 0;
        while (n2 < n) {
            TransferDropTargetListener original = transferDropTargetListenerArray[n2];
            consolidated[i++] = original;
            ++n2;
        }
        return consolidated;
    }

    private List<TransferDropTargetListener> getConfiguredTransferDropTargetListeners() {
        return OutlineTargetListenerReader.getListeners();
    }
}

