/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryConfigProjectData;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryConfiglModelSource;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryRegistryUtil;

public class JAXRSLibraryConfigModel {
    private final JAXRSLibraryConfiglModelSource data;
    private final JAXRSLibraryRegistryUtil jaxrsLibReg;
    private List colJAXRSImplLib;

    private JAXRSLibraryConfigModel(JAXRSLibraryConfiglModelSource data) {
        this.data = data;
        this.jaxrsLibReg = JAXRSLibraryRegistryUtil.getInstance();
    }

    public List getJAXRSImplementationLibraries() {
        if (this.colJAXRSImplLib == null) {
            JAXRSLibraryInternalReference srcLib;
            this.colJAXRSImplLib = this.jaxrsLibReg.getJAXRSImplementationLibraries();
            JAXRSLibraryInternalReference targetLib = this.data.getJAXRSImplementationLibrary();
            if (targetLib == null) {
                targetLib = this.jaxrsLibReg.getDefaultJAXRSImplementationLibrary();
            }
            if (targetLib != null && (srcLib = this.jaxrsLibReg.getJAXRSLibraryReferencebyID(targetLib.getID())) != null) {
                srcLib.setSelected(true);
                srcLib.setToBeDeployed(targetLib.isCheckedToBeDeployed());
                srcLib.setToBeSharedLibrary(targetLib.isSharedLibSupported() && targetLib.isCheckedToBeSharedLibrary());
                srcLib.setSharedLibSupported(targetLib.isSharedLibSupported());
            }
        }
        return this.colJAXRSImplLib;
    }

    public JAXRSLibraryInternalReference getCurrentJAXRSImplementationLibrarySelection() {
        Iterator it = this.getJAXRSImplementationLibraries().iterator();
        JAXRSLibraryInternalReference crtItem = null;
        while (it.hasNext()) {
            crtItem = (JAXRSLibraryInternalReference)it.next();
            if (!crtItem.isSelected()) continue;
            return crtItem;
        }
        return null;
    }

    public JAXRSLibraryInternalReference getSavedJAXRSImplementationLibrary() {
        return this.data.getJAXRSImplementationLibrary();
    }

    public void setCurrentJAXRSImplementationLibrarySelection(JAXRSLibraryInternalReference library) {
        if (library != null) {
            Iterator it = this.getJAXRSImplementationLibraries().iterator();
            JAXRSLibraryInternalReference crtjaxrslib = null;
            while (it.hasNext()) {
                crtjaxrslib = (JAXRSLibraryInternalReference)it.next();
                if (crtjaxrslib.getID().equals(library.getID())) {
                    crtjaxrslib.setSelected(true);
                    crtjaxrslib.setToBeDeployed(library.isCheckedToBeDeployed());
                    crtjaxrslib.setToBeSharedLibrary(library.isSharedLibSupported() && library.isCheckedToBeSharedLibrary());
                    crtjaxrslib.setSharedLibSupported(library.isSharedLibSupported());
                    continue;
                }
                crtjaxrslib.setSelected(false);
            }
        }
    }

    public void saveData(IProject project) {
        JAXRSLibraryConfigProjectData data_ = new JAXRSLibraryConfigProjectData(project);
        ArrayList<JAXRSLibraryInternalReference> implLibs = new ArrayList<JAXRSLibraryInternalReference>();
        implLibs.add(this.getCurrentJAXRSImplementationLibrarySelection());
        data_.saveData(implLibs);
    }

    public static final class JAXRSLibraryConfigModelFactory {
        public static JAXRSLibraryConfigModel createInstance(JAXRSLibraryConfiglModelSource source) {
            if (source == null) {
                throw new NullPointerException(Messages.JAXRSLibraryConfigModel_Null_Data_Source);
            }
            return new JAXRSLibraryConfigModel(source);
        }
    }
}

