/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PageflowElementPropertySource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class PageflowElementTreeEditPart
extends AbstractTreeEditPart
implements Adapter {
    private static final ImageDescriptor IMG_PAGE = EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Page16.gif");
    private static final ImageDescriptor IMG_NODE = EditorPlugin.getDefault().getImageDescriptor("facesconfig/FacesConfig_Pageflow16.gif");
    private IPropertySource propertySource = null;
    private Notifier target = null;

    public static Image getImage(PageflowElement element) {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = element instanceof PageflowPage ? IMG_PAGE : IMG_NODE;
        if (imageDescriptor == null) {
            return null;
        }
        Image image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        if (image == null) {
            EditorPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), imageDescriptor);
            image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        }
        return image;
    }

    public PageflowElementTreeEditPart(PageflowElement pageflowElement) {
        super((Object)pageflowElement);
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            return this.getPropertySource();
        }
        return super.getAdapter(key);
    }

    protected Image getImage() {
        return PageflowElementTreeEditPart.getImage(this.getPageflowElement());
    }

    private IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new PageflowElementPropertySource(this.getPageflowElement());
        }
        return this.propertySource;
    }

    public Notifier getTarget() {
        return this.target;
    }

    protected String getText() {
        return this.getPageflowElement().getName() != null ? this.getPageflowElement().getName() : "[unnamed]";
    }

    public PageflowElement getPageflowElement() {
        return (PageflowElement)this.getModel();
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(this.getModel().getClass());
    }

    public void notifyChanged(Notification notification) {
        int type = notification.getEventType();
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                    this.refreshVisuals();
                    break;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PageflowElementTreeEditPart.this.refreshVisuals();
                    }
                });
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        this.hookIntoPageflowElement(this.getPageflowElement());
        super.activate();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.unhookFromPageflowElement(this.getPageflowElement());
        super.deactivate();
    }

    protected void hookIntoPageflowElement(PageflowElement element) {
        if (element != null) {
            element.eAdapters().add((Object)this);
        }
    }

    protected void unhookFromPageflowElement(PageflowElement element) {
        if (element != null) {
            element.eAdapters().remove((Object)this);
        }
    }
}

