/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ConstantTest
extends AbstractRegressionTest {
    public ConstantTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ConstantTest.class);
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.js", "  if(55!=00000000000000000000055) {\n    print(\"55!=00000000000000000000055\");\n  }\n  else {\n    print(\"55==00000000000000000000055\");\n  }\n"}, "55!=00000000000000000000055\n");
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.js", "  if(55e2!=550e1) {\n    print(\"55e2!=550e1\");\n  }\n  else {\n    print(\"55e2==550e1\");\n  }\n"}, "55e2==550e1\n");
    }

    public void test004() {
        this.runConformTest(new String[]{"p/X.js", "  if(5.5e2!=5.50e1) {\n    print(\"5.5e2!=5.50e1\");\n  }\n  else {\n    print(\"5.5e2==5.50e1\");\n  }\n"}, "5.5e2!=5.50e1\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"p/X.js", "  if(5.5e-2!=0.550e-1) {\n    print(\"5.5e-2!=0.550e-1\");\n  }\n  else {\n    print(\"5.5e-2==00.55e-1\");\n  }\n"}, "5.5e-2==00.55e-1\n");
    }

    public void test006() {
        this.runConformTest(new String[]{"p/X.js", "  if(0x5a!=0x5A) {\n    print(\"0x5a != 0x5A\");\n  }\n  else {\n    print(\"0x5a == 0x5A\");\n  }\n"}, "0x5a == 0x5A\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.js", "var F = false;\t\nvar Str = F ? \"dummy\" : null;\t\nfunction main(args) {\t\n   if (Str == null)\n      print(\"SUCCESS\");\n   else\n      print(\"FAILED\");\n}\nmain();"}, "SUCCESS\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.js", "function X() {\t\n    function main(args) {\t\n      \tprint(\"SUCCESS\");\t\n\t} \t\n\tfunction foo(){\t\n\t\twhile (null == null);\t//not an inlinable constant\n\t\tprint(\"unreachable but shouldn't be flagged\");\t\n\t}\t\n}\t\n"});
    }

    public void test009() {
        this.runConformTest(new String[]{"X.js", "       if (null == null) print(\"1\");\t\n       if ((null==null ? null:null) == (null==null ? null:null))\t\n        \tprint(\"2\");\t\n\t\tvar b = (\"[\" + null + \"]\") == \"[null]\";  // cannot inline\t\n\t\tprint(\"3\");\t\n\t\tvar s = null;\t\n\t\tif (s == null) print(\"4\");\t\n\t\tvar s2 = \"aaa\";\t\n\t\tif (s2 == \"aaa\") print(\"5\");\t\n"}, "1\n2\n3\n4\n5\n");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.js", "function main(args) {\n       if (null == null) {\n\t\t\tprint(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tprint(\"SHOULDN'T BE GENERATED\");\t\n}\t\nmain();\n"}, "SUCCESS\n");
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.js", "       if (null == null) {\n\t\t\tprint(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tprint(\"SHOULDN'T BE GENERATED\");\t\n"}, "----------\n1. ERROR in X.js (at line 3)\n\treturn;\t\n\t^^^^^^^\nCannot return from outside a function or method.\n----------\n");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.js", "function main(args) {\n       if (\"a\" == \"a\") {\n\t\t\tprint(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tprint(\"FAIL\");\t\n}\t\nmain();\n"}, "SUCCESS\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.js", "function main(args) {\n       if (true == true) {\n\t\t\tprint(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tprint(\"FAIL\");\t\n}\t\nmain();\n"}, "SUCCESS\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.js", "function main(args) {\n       if (5) {\n\t\t\tprint(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tprint(\"FAIL\");\t\n}\t\nmain();\n"}, "SUCCESS\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.js", "function main(args) {\n       var a = true;\n       if (a == true) {\n\t\t\tprint(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tprint(\"FAIL\");\t\n}\t\nmain();\n"}, "SUCCESS\n");
    }

    public static Class testClass() {
        return ConstantTest.class;
    }
}

