/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.eclipse;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;

public class URIResolverWrapper
implements IExtensibleURIResolver {
    @Override
    public void resolve(String baseLocation, String publicId, String systemId, IURIResolutionResult result) {
        URIResolver resolver = URIResolverPlugin.createResolver();
        String resolvedSystemId = this.resolvePlatformURL(systemId);
        String location = null;
        if (publicId != null || resolvedSystemId != null) {
            location = resolver.resolve(baseLocation, publicId, resolvedSystemId);
        }
        if (location != null) {
            result.setLogicalLocation(location);
            String physical = resolver.resolvePhysicalLocation(baseLocation, publicId, location);
            if (physical != null) {
                result.setPhysicalLocation(physical);
            } else {
                result.setPhysicalLocation(location);
            }
        }
    }

    protected String resolvePlatformURL(String url) {
        String result = url;
        if (url != null && url.startsWith("platform:")) {
            try {
                URL fileURL = FileLocator.toFileURL((URL)new URL(url));
                result = fileURL.toExternalForm();
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

