/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.views.contentoutline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropCommand;
import org.eclipse.wst.dtd.core.internal.document.DTDModelImpl;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.dtd.ui.internal.dnd.DTDDragAndDropManager;
import org.eclipse.wst.dtd.ui.views.contentoutline.DTDContextMenuHelper;
import org.eclipse.wst.dtd.ui.views.contentoutline.DTDLabelProvider;
import org.eclipse.wst.dtd.ui.views.contentoutline.DTDTreeContentProvider;
import org.eclipse.wst.dtd.ui.views.contentoutline.OrderAction;
import org.eclipse.wst.dtd.ui.views.contentoutline.SortAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.util.Assert;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;

public class DTDContentOutlineConfiguration
extends ContentOutlineConfiguration {
    private IContentProvider fContentProvider = null;
    private ILabelProvider fLabelProvider = null;
    private DTDContextMenuHelper fMenuHelper;
    private TransferDragSourceListener[] fTransferDragSourceListeners;
    private TransferDropTargetListener[] fTransferDropTargetListeners;
    private Map fViewerContributions = new HashMap(2);
    private final String OUTLINE_ORDER_PREF = "outline-order";
    private final String OUTLINE_SORT_PREF = "outline-sort";
    private static final String OUTLINE_FILTER_PREF = "org.eclipse.wst.dtd.ui.OutlinePage";

    public IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        Assert.isTrue((boolean)(this.getContentProvider(viewer) instanceof DTDTreeContentProvider), (String)"invalid content provider on viewer");
        IContributionItem[] items = super.createToolbarContributions(viewer);
        SortAction sortAction = new SortAction(viewer, DTDUIPlugin.getDefault().getPreferenceStore(), "outline-sort");
        OrderAction orderAction = new OrderAction(viewer, (DTDTreeContentProvider)this.getContentProvider(viewer), DTDUIPlugin.getDefault().getPreferenceStore(), "outline-order");
        PropertyChangeUpdateActionContributionItem sortItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)sortAction);
        PropertyChangeUpdateActionContributionItem orderItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)orderAction);
        if (items == null) {
            items = new IContributionItem[]{sortItem, orderItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 2];
            combinedItems[0] = sortItem;
            combinedItems[1] = orderItem;
            System.arraycopy(items, 0, combinedItems, 2, items.length);
            items = combinedItems;
        }
        return items;
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new DTDTreeContentProvider();
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DTDLabelProvider();
        }
        return this.fLabelProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        IMenuListener listener = null;
        if (this.fMenuHelper == null && viewer.getInput() instanceof DTDModelImpl) {
            this.fMenuHelper = new DTDContextMenuHelper((DTDModelImpl)viewer.getInput());
            this.fMenuHelper.createMenuListenersFor((Viewer)viewer);
        }
        if (this.fMenuHelper != null) {
            listener = this.fMenuHelper.getMenuListener();
        }
        return listener;
    }

    protected IPreferenceStore getPreferenceStore() {
        return DTDUIPlugin.getDefault().getPreferenceStore();
    }

    public TransferDragSourceListener[] getTransferDragSourceListeners(final TreeViewer treeViewer) {
        if (this.fTransferDragSourceListeners == null) {
            this.fTransferDragSourceListeners = new TransferDragSourceListener[]{new TransferDragSourceListener(){

                public void dragFinished(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(null);
                }

                public void dragSetData(DragSourceEvent event) {
                }

                public void dragStart(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(treeViewer.getSelection());
                }

                public Transfer getTransfer() {
                    return LocalSelectionTransfer.getTransfer();
                }
            }};
        }
        return this.fTransferDragSourceListeners;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(TreeViewer treeViewer) {
        if (this.fTransferDropTargetListeners == null) {
            this.fTransferDropTargetListeners = new TransferDropTargetListener[]{new TransferDropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                }

                public void dragLeave(DropTargetEvent event) {
                }

                public void dragOperationChanged(DropTargetEvent event) {
                }

                public void dragOver(DropTargetEvent event) {
                    event.feedback = 1;
                    float feedbackFloat = this.getHeightInItem(event);
                    if ((double)feedbackFloat > 0.75) {
                        event.feedback = 4;
                    } else if ((double)feedbackFloat < 0.25) {
                        event.feedback = 2;
                    }
                    event.feedback |= 0x18;
                }

                public void drop(DropTargetEvent event) {
                    IStructuredSelection selection;
                    if (event.operations != 0 && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()) != null && !selection.isEmpty() && event.item != null && event.item.getData() != null) {
                        float feedbackFloat = this.getHeightInItem(event);
                        final DragAndDropCommand command = new DTDDragAndDropManager().createCommand(event.item.getData(), feedbackFloat, event.operations, event.detail, selection.toList());
                        if (command != null && command.canExecute()) {
                            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                                public void run() throws Exception {
                                    command.execute();
                                }
                            });
                        }
                    }
                }

                public void dropAccept(DropTargetEvent event) {
                }

                private float getHeightInItem(DropTargetEvent event) {
                    if (event.item == null) {
                        return 0.5f;
                    }
                    if (event.item instanceof TreeItem) {
                        TreeItem treeItem = (TreeItem)event.item;
                        Tree control = treeItem.getParent();
                        Point point = control.toControl(new Point(event.x, event.y));
                        Rectangle bounds = treeItem.getBounds();
                        return (float)(point.y - bounds.y) / (float)bounds.height;
                    }
                    if (event.item instanceof TableItem) {
                        TableItem tableItem = (TableItem)event.item;
                        Table control = tableItem.getParent();
                        Point point = control.toControl(new Point(event.x, event.y));
                        Rectangle bounds = tableItem.getBounds(0);
                        return (float)(point.y - bounds.y) / (float)bounds.height;
                    }
                    return 0.0f;
                }

                public Transfer getTransfer() {
                    return LocalSelectionTransfer.getTransfer();
                }

                public boolean isEnabled(DropTargetEvent event) {
                    return this.getTransfer().isSupportedType(event.currentDataType);
                }
            }};
        }
        return this.fTransferDropTargetListeners;
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fViewerContributions.remove(viewer);
        if (this.fMenuHelper != null) {
            this.fMenuHelper.removeMenuListenersFor((Viewer)viewer);
            this.fMenuHelper = null;
        }
    }

    protected String getOutlineFilterTarget() {
        return OUTLINE_FILTER_PREF;
    }
}

