/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;

public class TemporaryAnnotation
extends Annotation
implements ITemporaryAnnotation,
IReconcileResult,
IAnnotationPresentation,
IQuickFixableAnnotation {
    public static final String ANNOT_ERROR = "org.eclipse.wst.sse.ui.temp.error";
    public static final String ANNOT_INFO = "org.eclipse.wst.sse.ui.temp.info";
    public static final String ANNOT_UNKNOWN = "org.eclipse.text.annotation.unknown";
    public static final String ANNOT_WARNING = "org.eclipse.wst.sse.ui.temp.warning";
    private static final int INFO_LAYER;
    private static final int WARNING_LAYER;
    private static final int ERROR_LAYER;
    public static final String ERROR_SYSTEM_IMAGE = "error";
    public static final String WARNING_SYSTEM_IMAGE = "warning";
    public static final String INFO_SYSTEM_IMAGE = "info";
    public static final String TASK_SYSTEM_IMAGE = "task";
    public static final String BOOKMARK_SYSTEM_IMAGE = "bookmark";
    private static final Map<String, String> MAPPING;
    private Object fAdditionalFixInfo = null;
    private Object fKey = null;
    private Position fPosition = null;
    private Map<String, String> fAttributes = null;
    private boolean fIsQuickFixable = false;
    private boolean fIsQuickFixableStateSet = false;
    private int fProblemID;
    private int fLayer = 0;
    private Image fImage = null;

    static {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        INFO_LAYER = TemporaryAnnotation.computeLayer(ANNOT_INFO, lookup);
        WARNING_LAYER = TemporaryAnnotation.computeLayer(ANNOT_WARNING, lookup);
        ERROR_LAYER = TemporaryAnnotation.computeLayer(ANNOT_ERROR, lookup);
        MAPPING = new HashMap<String, String>();
        MAPPING.put(ERROR_SYSTEM_IMAGE, "IMG_OBJS_ERROR_TSK");
        MAPPING.put(WARNING_SYSTEM_IMAGE, "IMG_OBJS_WARN_TSK");
        MAPPING.put(INFO_SYSTEM_IMAGE, "IMG_OBJS_INFO_TSK");
        MAPPING.put(TASK_SYSTEM_IMAGE, "IMG_OBJS_TASK_TSK");
        MAPPING.put(BOOKMARK_SYSTEM_IMAGE, "IMG_OBJS_BKMRK_TSK");
    }

    private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
        Annotation annotation = new Annotation(annotationType, false, null);
        AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer() + 1;
        }
        return 1;
    }

    public TemporaryAnnotation(Position p, String type, String message, ReconcileAnnotationKey key) {
        this.fPosition = p;
        this.setType(type);
        this.fKey = key;
        this.setText(message);
        this.initLayer();
    }

    public TemporaryAnnotation(Position p, String type, String message, ReconcileAnnotationKey key, int problemId) {
        this.fPosition = p;
        this.fKey = key;
        this.setType(type);
        this.setText(message);
        this.fProblemID = problemId;
        this.initLayer();
    }

    private void initLayer() {
        String type = this.getType();
        if (type.equals(ANNOT_ERROR)) {
            this.fLayer = ERROR_LAYER;
        } else if (type.equals(ANNOT_WARNING)) {
            this.fLayer = WARNING_LAYER;
        } else if (type.equals(ANNOT_INFO)) {
            this.fLayer = INFO_LAYER;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TemporaryAnnotation) {
            TemporaryAnnotation ta = (TemporaryAnnotation)obj;
            boolean samePosition = ta.getPosition().equals((Object)this.getPosition());
            boolean sameText = false;
            if (ta.getText() != null && this.getText() != null && ta.getText().equals(this.getText())) {
                sameText = true;
            } else if (ta.getText() == null && this.getText() == null) {
                sameText = true;
            }
            return sameText && samePosition;
        }
        return super.equals(obj);
    }

    public Object getAdditionalFixInfo() {
        return this.fAdditionalFixInfo;
    }

    public String getDescription() {
        return this.getText();
    }

    @Override
    public Object getKey() {
        return this.fKey;
    }

    public Position getPosition() {
        return this.fPosition;
    }

    public int getProblemID() {
        return this.fProblemID;
    }

    public boolean isPersistent() {
        return false;
    }

    public void setAdditionalFixInfo(Object info) {
        this.fAdditionalFixInfo = info;
        this.setQuickFixable(true);
    }

    public int getLayer() {
        return this.fLayer;
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        if (this.fImage == null || this.fImage.isDisposed()) {
            this.fImage = this.getImage();
        }
        if (this.fImage != null) {
            ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    public String toString() {
        return "" + this.fPosition.getOffset() + ':' + this.fPosition.getLength() + ": " + this.getText();
    }

    public Map<String, String> getAttributes() {
        return this.fAttributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.fAttributes = attributes;
    }

    public boolean isQuickFixable() {
        return this.fIsQuickFixable;
    }

    public void setQuickFixable(boolean state) {
        this.fIsQuickFixable = state;
        this.fIsQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.fIsQuickFixableStateSet;
    }

    private AnnotationPreference getAnnotationPreference() {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        return lookup != null ? lookup.getAnnotationPreference((Annotation)this) : null;
    }

    private boolean hasQuickFix() {
        Object object = this.getAdditionalFixInfo();
        if (object instanceof IQuickAssistProcessor) {
            return ((IQuickAssistProcessor)object).canFix((Annotation)this);
        }
        return false;
    }

    private Image getImage() {
        Image image;
        block26: {
            ImageDescriptor quickFixImageDesc;
            String annotationType;
            AnnotationPreference preference = this.getAnnotationPreference();
            ImageRegistry registry = SSEUIPlugin.getInstance().getImageRegistry();
            IAnnotationImageProvider annotationImageProvider = preference.getAnnotationImageProvider();
            if (annotationImageProvider != null) {
                Image image2 = annotationImageProvider.getManagedImage((Annotation)this);
                if (image2 != null) {
                    return image2;
                }
                String id = annotationImageProvider.getImageDescriptorId((Annotation)this);
                if (id != null) {
                    image2 = registry.get(id);
                    if (image2 == null) {
                        ImageDescriptor descriptor = annotationImageProvider.getImageDescriptor(id);
                        registry.put(id, descriptor);
                        image2 = registry.get(id);
                    }
                    return image2;
                }
            }
            if ((annotationType = this.getType()) == null) {
                return null;
            }
            if (this.hasQuickFix() && (quickFixImageDesc = preference.getQuickFixImageDescriptor()) != null) {
                Image image3 = registry.get(quickFixImageDesc.toString());
                if (image3 == null) {
                    registry.put(quickFixImageDesc.toString(), quickFixImageDesc);
                    image3 = registry.get(quickFixImageDesc.toString());
                }
                if (image3 != null) {
                    return image3;
                }
            }
            if ((image = registry.get(annotationType)) == null) {
                ImageDescriptor descriptor = preference.getImageDescriptor();
                if (descriptor != null) {
                    registry.put(annotationType, descriptor);
                    image = registry.get(annotationType);
                } else {
                    String key;
                    String symbolicImageName = preference.getSymbolicImageName();
                    if (symbolicImageName != null && (key = TemporaryAnnotation.getSharedImageName(preference.getSymbolicImageName())) != null) {
                        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                        image = sharedImages.getImage(key);
                    }
                }
            }
            if (image != null) break block26;
            String key = null;
            switch (annotationType) {
                case "org.eclipse.wst.sse.ui.temp.error": {
                    key = TemporaryAnnotation.getSharedImageName(ERROR_SYSTEM_IMAGE);
                    break;
                }
                case "org.eclipse.wst.sse.ui.temp.warning": {
                    key = TemporaryAnnotation.getSharedImageName(WARNING_SYSTEM_IMAGE);
                    break;
                }
                case "org.eclipse.wst.sse.ui.temp.info": {
                    key = TemporaryAnnotation.getSharedImageName(INFO_SYSTEM_IMAGE);
                }
            }
            if (key != null) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                image = sharedImages.getImage(key);
            }
        }
        return image;
    }

    public static String getSharedImageName(String symbolicImageName) {
        Assert.isLegal((symbolicImageName != null ? 1 : 0) != 0);
        String sharedImageName = MAPPING.get(symbolicImageName);
        Assert.isLegal((sharedImageName != null ? 1 : 0) != 0);
        return sharedImageName;
    }
}

