/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;

public final class PropertyUtils {
    private static final String ENCODED_CHAR_PERCENT = "%25";
    private static final String ENCODED_CHAR_CARRIAGE_RETURN = "%0d";
    private static final String ENCODED_CHAR_TAB = "%09";
    private static final String ENCODED_CHAR_NEWLINE = "%0a";
    private static final String ENCODED_CHAR_SPACE = "%20";
    private static final String ENCODED_CHAR_COLON = "%3a";
    private static final String ENCODED_CHAR_EQUALS = "%3d";
    private static final String NAME_PROPERTIES = ".props";
    private static final String STR_BOUNDS_END = ".bounds";
    private static final int INSET = 40;

    public static String getProperty(Properties props, String key, String theDefault) {
        try {
            String value = props.getProperty(key, theDefault);
            if (value != null && value.length() == 0) {
                value = null;
            }
            if (value == null) {
                value = theDefault;
            }
            return value;
        }
        catch (Exception exception) {
            return theDefault;
        }
    }

    public static String getProperty(Properties props, String key) {
        try {
            String value = props.getProperty(key);
            if (value != null && value.length() == 0) {
                value = null;
            }
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getPropertyValue(Properties props, String key, int defaultValue, int minimumValue) {
        int theValue = PropertyUtils.getPropertyValue(props, key, defaultValue);
        if (theValue < minimumValue) {
            theValue = minimumValue;
        }
        return theValue;
    }

    public static int getPropertyValue(Properties props, String key, int defaultValue) {
        String stringValue = PropertyUtils.getProperty(props, key);
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public static long getPropertyLongValue(Properties props, String key, long defaultValue) {
        String stringValue = PropertyUtils.getProperty(props, key);
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public static boolean isProperty(Properties props, String key, boolean bDefault) {
        return PropertyUtils.getProperty(props, key, "" + bDefault).equals("true");
    }

    public static String[] getPropertyStrings(Properties props, String key) {
        String tokenString = PropertyUtils.getProperty(props, key);
        if (tokenString == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(tokenString, ",");
        String[] pNames = new String[tokenizer.countTokens()];
        int ii = 0;
        while (ii < pNames.length) {
            pNames[ii] = ((String)tokenizer.nextElement()).trim();
            ++ii;
        }
        return pNames;
    }

    public static String getResourceProperty(ResourceBundle bundle, String key, String theDefault) {
        try {
            String value = bundle.getString(key);
            if (value == null || value.length() == 0) {
                value = theDefault;
            }
            return value;
        }
        catch (NullPointerException nullPointerException) {
            return theDefault;
        }
        catch (MissingResourceException missingResourceException) {
            return theDefault;
        }
        catch (ClassCastException classCastException) {
            return theDefault;
        }
    }

    public static String getResourceProperty(ResourceBundle bundle, String key) {
        try {
            String value = bundle.getString(key);
            if (value != null && value.length() == 0) {
                value = null;
            }
            return value;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static int getResourcePropertyValue(ResourceBundle bundle, String key, int defaultValue, int minimumValue) {
        int theValue = PropertyUtils.getResourcePropertyValue(bundle, key, defaultValue);
        if (theValue < minimumValue) {
            theValue = minimumValue;
        }
        return theValue;
    }

    public static int getResourcePropertyValue(ResourceBundle bundle, String key, int defaultValue) {
        String stringValue = PropertyUtils.getResourceProperty(bundle, key);
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public static long getResourcePropertyLongValue(ResourceBundle bundle, String key, long defaultValue) {
        String stringValue = PropertyUtils.getResourceProperty(bundle, key);
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public static boolean isResourceProperty(ResourceBundle bundle, String key, boolean bDefault) {
        return PropertyUtils.getResourceProperty(bundle, key, "" + bDefault).equals("true");
    }

    public static String encodeName(String theName) {
        int theSize = theName.length();
        StringBuffer encoded = new StringBuffer(theSize);
        int ii = 0;
        while (ii < theSize) {
            char ch = theName.charAt(ii);
            switch (ch) {
                case '=': {
                    encoded.append(ENCODED_CHAR_EQUALS);
                    break;
                }
                case ':': {
                    encoded.append(ENCODED_CHAR_COLON);
                    break;
                }
                case ' ': {
                    encoded.append(ENCODED_CHAR_SPACE);
                    break;
                }
                case '\n': {
                    encoded.append(ENCODED_CHAR_NEWLINE);
                    break;
                }
                case '\t': {
                    encoded.append(ENCODED_CHAR_TAB);
                    break;
                }
                case '\r': {
                    encoded.append(ENCODED_CHAR_CARRIAGE_RETURN);
                    break;
                }
                case '%': {
                    encoded.append(ENCODED_CHAR_PERCENT);
                    break;
                }
                default: {
                    encoded.append(ch);
                }
            }
            ++ii;
        }
        return encoded.toString();
    }

    public static String decodeName(String theName) {
        int theSize = theName.length();
        StringBuffer decoded = new StringBuffer(theSize);
        int ii = 0;
        while (ii < theSize) {
            char ch = theName.charAt(ii);
            if (ch == '%') {
                ch = theName.charAt(++ii);
                int kk = Character.digit(ch, 16);
                kk *= 16;
                ch = theName.charAt(++ii);
                decoded.append((char)(kk += Character.digit(ch, 16)));
            } else {
                decoded.append(ch);
            }
            ++ii;
        }
        return decoded.toString();
    }

    public static Properties openProperties(String propName) throws IOException, FileNotFoundException {
        return PropertyUtils.openProperties(propName, null, true);
    }

    public static Properties openProperties(String propName, Properties propDefaults) throws IOException, FileNotFoundException {
        return PropertyUtils.openProperties(propName, propDefaults, true);
    }

    public static Properties openProperties(String propName, Properties propDefaults, boolean bCreatePropertiesPathname) throws IOException, FileNotFoundException {
        Properties theProperties;
        block4: {
            theProperties = new Properties(propDefaults);
            try {
                String propertiesFilename = bCreatePropertiesPathname ? PropertyUtils.getPropertiesPathname(propName) : propName;
                FileInputStream theStream = new FileInputStream(propertiesFilename);
                theProperties.load(theStream);
                ((InputStream)theStream).close();
            }
            catch (FileNotFoundException ee) {
                if (propDefaults == null) {
                    throw ee;
                }
            }
            catch (IOException ee) {
                if (propDefaults != null) break block4;
                throw ee;
            }
        }
        return theProperties;
    }

    public static Properties combineProperties(Properties localProperties, Properties defaultProperties) throws IOException {
        Properties theNewProperties = new Properties();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        defaultProperties.store(os, "");
        localProperties.store(os, "");
        byte[] theData = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(theData);
        theNewProperties.load(is);
        return theNewProperties;
    }

    public static String encodeFilename(String theFilename) {
        String theSeparator = System.getProperty("file.separator");
        int ii = 0;
        while (ii < theSeparator.length()) {
            char theChar = theSeparator.charAt(ii);
            theFilename = theFilename.replace(theChar, ' ');
            ++ii;
        }
        return theFilename;
    }

    public static String getPropertiesPathname(String baseName) {
        if (baseName.endsWith(NAME_PROPERTIES)) {
            return System.getProperty("user.dir") + System.getProperty("file.separator") + PropertyUtils.encodeFilename(baseName);
        }
        return System.getProperty("user.dir") + System.getProperty("file.separator") + PropertyUtils.encodeFilename(baseName) + NAME_PROPERTIES;
    }

    public static void setComponentBounds(Properties props, Component theComponent, String[] names, String defaultValue) {
        PropertyUtils.setComponentBounds(props, theComponent, names, defaultValue, false);
    }

    public static void setComponentBounds(Properties props, Component theComponent, String[] names, String defaultValue, boolean bEnsureDesktopVisibility) {
        String tmpString = PropertyUtils.getComponentPropertyName(names, STR_BOUNDS_END);
        PropertyUtils.setComponentBounds(props, theComponent, tmpString, defaultValue, bEnsureDesktopVisibility);
    }

    public static void setComponentBounds(Properties props, Component theComponent, String thePropertyName, String defaultValue) {
        PropertyUtils.setComponentBounds(props, theComponent, thePropertyName, defaultValue, false);
    }

    public static void setComponentBounds(Properties props, Component theComponent, String thePropertyName, String defaultValue, boolean bEnsureDesktopVisibility) {
        String tmpString = props.getProperty(thePropertyName, defaultValue);
        Rectangle theValue = PropertyUtils.decodeBounds(tmpString);
        theComponent.setBounds(theValue);
        if (bEnsureDesktopVisibility) {
            Point theLoc = theComponent.getLocation();
            Dimension portSize = new Dimension(Toolkit.getDefaultToolkit().getScreenSize());
            if (theLoc.x > portSize.width) {
                theLoc.x = 40;
            }
            if (theLoc.y > portSize.height) {
                theLoc.y = 40;
            }
            theComponent.setLocation(theLoc);
        }
    }

    public static void saveComponentBounds(Properties props, Component theComponent, String[] names) {
        String tmpString = PropertyUtils.getComponentPropertyName(names, STR_BOUNDS_END);
        PropertyUtils.saveComponentBounds(props, theComponent, tmpString);
    }

    public static void saveComponentBounds(Properties props, Component theComponent, String thePropertyName) {
        Rectangle theBounds = theComponent.getBounds();
        String theValue = PropertyUtils.encodeBounds(theBounds);
        props.put(thePropertyName, theValue);
    }

    public static String getComponentPropertyName(String[] names, String subsystemName) {
        Object tmpString = "";
        int ii = 0;
        while (ii < names.length) {
            tmpString = (String)tmpString + (ii > 0 ? "." : "") + PropertyUtils.encodeName(names[ii]);
            ++ii;
        }
        if (!subsystemName.startsWith(".")) {
            tmpString = (String)tmpString + ".";
        }
        tmpString = (String)tmpString + subsystemName;
        return tmpString;
    }

    public static Rectangle decodeBounds(String sBounds) {
        int[] theValue = new int[4];
        String restString = sBounds;
        int ii = 0;
        while (ii < 4) {
            theValue[ii] = 0;
            ++ii;
        }
        try {
            ii = 0;
            while (ii < 4) {
                String tmpString;
                int index = restString.indexOf(",");
                if (index > 0) {
                    tmpString = restString.substring(0, index);
                    restString = restString.substring(index + 1);
                } else {
                    tmpString = restString;
                    restString = null;
                }
                theValue[ii] = Integer.valueOf(tmpString);
                ++ii;
            }
        }
        catch (Exception exception) {}
        return new Rectangle(theValue[0], theValue[1], theValue[2], theValue[3]);
    }

    public static String encodeBounds(Rectangle rBounds) {
        return rBounds.x + "," + rBounds.y + "," + rBounds.width + "," + rBounds.height;
    }

    public static Properties getPropertiesFromString(String thePropertyString) throws IOException {
        if (thePropertyString == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(thePropertyString.getBytes());
        Properties props = new Properties();
        props.load(in);
        in = null;
        return props;
    }

    public static Properties getPropertiesFromEncodedString(String theEncodedPropertyString) throws IOException {
        if (theEncodedPropertyString == null) {
            return null;
        }
        return PropertyUtils.getPropertiesFromString(PropertyUtils.decodeName(theEncodedPropertyString));
    }

    public static Properties encodedStringToProperties(String theEncodedPropertyString) {
        try {
            return PropertyUtils.getPropertiesFromEncodedString(theEncodedPropertyString);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String savePropertiesToString(Properties props, String comment) throws IOException {
        if (props == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        props.store(out, comment);
        String tmpString = out.toString();
        out = null;
        return tmpString;
    }

    public static String savePropertiesToEncodedString(Properties props, String comment) throws IOException {
        if (props == null) {
            return null;
        }
        return PropertyUtils.encodeName(PropertyUtils.savePropertiesToString(props, comment));
    }

    public static String propertiesToEncodedString(Properties props) {
        try {
            return PropertyUtils.savePropertiesToEncodedString(props, "");
        }
        catch (IOException ee) {
            JSFUICommonPlugin.getLogger(PropertyUtils.class).error("saving properties", ee);
            return null;
        }
    }

    private PropertyUtils() {
    }
}

