/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.impl.extension.wsdl;

import org.apache.wsil.QName;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.ExtensionReader;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.extension.wsdl.ReferencedService;
import org.apache.wsil.impl.extension.wsdl.ImplementedBindingImpl;
import org.apache.wsil.impl.extension.wsdl.ReferenceImpl;
import org.apache.wsil.impl.extension.wsdl.ReferencedServiceImpl;
import org.apache.wsil.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDLExtensionReader
implements ExtensionReader {
    public ExtensionElement parseElement(Element element, WSILElement wSILElement) throws WSILException {
        ExtensionElement extensionElement = null;
        QName qName = new QName(element);
        if (qName.equals(Reference.QNAME)) {
            extensionElement = this.parseReference(element, wSILElement);
        } else if (qName.equals(ReferencedService.QNAME)) {
            extensionElement = this.parseReferencedService(element, wSILElement);
        } else if (qName.equals(ImplementedBinding.QNAME)) {
            extensionElement = this.parseImplementedBinding(element, wSILElement);
        } else {
            throw new WSILException("WSIL document contains undefined WSDL extension element: " + element.getTagName() + ".");
        }
        return extensionElement;
    }

    protected ExtensionElement parseReference(Element element, WSILElement wSILElement) {
        Object object;
        ReferenceImpl referenceImpl = new ReferenceImpl();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        if (attr != null && (object = attr.getValue()) != null) {
            referenceImpl.setEndpointPresent(Boolean.valueOf((String)object));
        }
        if ((object = XMLUtil.getFirstChild(element)) == null) {
            return referenceImpl;
        }
        QName qName = new QName((Node)object);
        if (qName.equals(ReferencedService.QNAME)) {
            referenceImpl.setReferencedService((ReferencedService)this.parseReferencedService((Element)object, wSILElement));
        }
        if (qName.equals(ImplementedBinding.QNAME)) {
            while (object != null) {
                referenceImpl.addImplementedBinding((ImplementedBinding)this.parseImplementedBinding((Element)object, referenceImpl));
                object = XMLUtil.getNextSibling((Element)object);
            }
        }
        return referenceImpl;
    }

    protected ExtensionElement parseImplementedBinding(Element element, WSILElement wSILElement) {
        ImplementedBindingImpl implementedBindingImpl = new ImplementedBindingImpl();
        int n = XMLUtil.getText(element).lastIndexOf(":");
        String string = XMLUtil.getText(element).substring(n + 1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        String string2 = attr.getValue();
        implementedBindingImpl.setBindingName(new QName(string2, string));
        return implementedBindingImpl;
    }

    protected ExtensionElement parseReferencedService(Element element, WSILElement wSILElement) {
        ReferencedServiceImpl referencedServiceImpl = new ReferencedServiceImpl();
        int n = XMLUtil.getText(element).lastIndexOf(":");
        String string = XMLUtil.getText(element).substring(n + 1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        String string2 = attr.getValue();
        referencedServiceImpl.setReferencedServiceName(new QName(string2, string));
        return referencedServiceImpl;
    }
}

