/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

class ExternalFileHyperlink
implements IHyperlink {
    private IRegion fHyperlinkRegion;
    private File fHyperlinkFile;

    public ExternalFileHyperlink(IRegion region, File file) {
        this.fHyperlinkFile = file;
        this.fHyperlinkRegion = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.fHyperlinkRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String path = this.fHyperlinkFile.getPath();
        if (path.length() > 60) {
            path = String.valueOf(path.substring(0, 25)) + "..." + path.substring(path.length() - 25, path.length());
        }
        return NLS.bind((String)JSPUIMessages.Open, (Object)path);
    }

    public void open() {
        if (this.fHyperlinkFile != null) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IFileStore store = EFS.getLocalFileSystem().getStore(this.fHyperlinkFile.toURI());
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
            }
            catch (PartInitException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
    }
}

