/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.AbstractSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.WsSerializerAdapter;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;

public class AbstractSerializerAdapterTest
extends MockObjectTestCase {
    private TestWsSerializerAdapter adapter;
    private JaxWsWorkspaceResource resource;

    public void setUp() {
        Mock javaModelMock = this.mock(IJavaModel.class);
        this.resource = new JaxWsWorkspaceResource((IJavaModel)javaModelMock.proxy());
        this.adapter = new TestWsSerializerAdapter(null, false);
    }

    public void testWsSerializerAdapter() {
        try {
            new WsSerializerAdapter(null);
            AbstractSerializerAdapterTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testNotifyChangedNotificationEditEnabledOnSet() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.expects(this.once()).method("isTouch").will(this.returnValue(false));
        notificationMock.stubs().method("getEventType").will(this.returnValue(1));
        this.adapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertTrue((boolean)this.adapter.saveCalled);
    }

    public void testNotifyChangedNotificationEditEnabledOnUnset() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.expects(this.once()).method("isTouch").will(this.returnValue(false));
        notificationMock.stubs().method("getEventType").will(this.returnValue(2));
        this.adapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertTrue((boolean)this.adapter.saveCalled);
    }

    public void testNotifyChangedNotificationEditEnabledOnAdd() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.expects(this.once()).method("isTouch").will(this.returnValue(false));
        notificationMock.stubs().method("getEventType").will(this.returnValue(3));
        this.adapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertFalse((boolean)this.adapter.saveCalled);
    }

    public void testNotifyChangedNotificationObjectTouched() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.expects(this.once()).method("isTouch").will(this.returnValue(true));
        this.adapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertFalse((boolean)this.adapter.saveCalled);
    }

    public void testNotifyChangedNotificationEditDisabled() {
        this.resource.disableSaving();
        Mock notificationMock = this.mock(Notification.class);
        this.adapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertFalse((boolean)this.adapter.saveCalled);
    }

    public void testCheckStringValue() {
        IWebService ws = DomFactory.eINSTANCE.createIWebService();
        TestWsSerializerAdapter adapter = new TestWsSerializerAdapter(ws, true);
        Mock msg = this.mock(Notification.class);
        msg.stubs().method("getFeature").will(this.returnValue(DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        msg.stubs().method("getOldStringValue").will(this.returnValue("oldValue"));
        msg.stubs().method("getNewStringValue").will(this.returnValue("newValue"));
        AbstractSerializerAdapterTest.assertTrue((boolean)adapter.checkValue((Notification)msg.proxy()));
        AbstractSerializerAdapterTest.assertEquals((String)"newValue", (String)ws.getName());
    }

    public void testCheckStringValueInvalidValues() {
        IWebService ws = DomFactory.eINSTANCE.createIWebService();
        TestWsSerializerAdapter adapter = new TestWsSerializerAdapter(ws, true);
        Mock msg = this.mock(Notification.class);
        msg.stubs().method("getFeature").will(this.returnValue(DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        msg.stubs().method("getOldValue").will(this.returnValue("oldValue"));
        msg.stubs().method("getNewStringValue").will(this.returnValue(null));
        AbstractSerializerAdapterTest.assertFalse((boolean)adapter.checkValue((Notification)msg.proxy()));
        AbstractSerializerAdapterTest.assertEquals((String)"oldValue", (String)ws.getName());
        msg.stubs().method("getNewStringValue").will(this.returnValue(""));
        AbstractSerializerAdapterTest.assertFalse((boolean)adapter.checkValue((Notification)msg.proxy()));
        AbstractSerializerAdapterTest.assertEquals((String)"oldValue", (String)ws.getName());
        msg.stubs().method("getNewStringValue").will(this.returnValue(" "));
        AbstractSerializerAdapterTest.assertFalse((boolean)adapter.checkValue((Notification)msg.proxy()));
        AbstractSerializerAdapterTest.assertEquals((String)"oldValue", (String)ws.getName());
        msg.stubs().method("getNewStringValue").will(this.returnValue(" oldValue "));
        AbstractSerializerAdapterTest.assertTrue((boolean)adapter.checkValue((Notification)msg.proxy()));
        AbstractSerializerAdapterTest.assertEquals((String)"oldValue", (String)ws.getName());
    }

    public void testIsAdapterForTypeObject() {
        AbstractSerializerAdapterTest.assertTrue((boolean)this.adapter.isAdapterForType(IAnnotationSerializer.class));
        AbstractSerializerAdapterTest.assertFalse((boolean)this.adapter.isAdapterForType(Notification.class));
    }

    public void testUpdateCalledForRequiredAnnotation() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.stubs().method("isTouch").will(this.returnValue(false));
        notificationMock.stubs().method("getEventType").will(this.returnValue(2));
        notificationMock.stubs().method("getNewStringValue").will(this.returnValue("test"));
        notificationMock.stubs().method("getOldValue").will(this.returnValue("oldValue"));
        notificationMock.stubs().method("getFeature").will(this.returnValue(DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getParamValuePairs").will(this.returnValue(new HashSet()));
        TestSavingWsSerializerAdapter saveAdapter = new TestSavingWsSerializerAdapter(this.resource, true, (IAnnotation<? extends IJavaElement>)((IAnnotation)ann.proxy()));
        saveAdapter.setTarget((Notifier)DomFactory.eINSTANCE.createIWebService());
        saveAdapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertTrue((boolean)saveAdapter.annWriter.updateCalled);
        AbstractSerializerAdapterTest.assertFalse((boolean)saveAdapter.annWriter.removeCalled);
    }

    public void testUpdateCalledForNonEmptyAnnotation() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.stubs().method("isTouch").will(this.returnValue(false));
        notificationMock.stubs().method("getEventType").will(this.returnValue(2));
        notificationMock.stubs().method("getNewStringValue").will(this.returnValue("test"));
        notificationMock.stubs().method("getOldValue").will(this.returnValue("oldValue"));
        notificationMock.stubs().method("getFeature").will(this.returnValue(DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        Mock ann = this.mock(IAnnotation.class);
        HashSet<IParamValuePair> params = new HashSet<IParamValuePair>();
        Mock param = this.mock(IParamValuePair.class);
        params.add((IParamValuePair)param.proxy());
        ann.stubs().method("getParamValuePairs").will(this.returnValue(params));
        TestSavingWsSerializerAdapter saveAdapter = new TestSavingWsSerializerAdapter(this.resource, false, (IAnnotation<? extends IJavaElement>)((IAnnotation)ann.proxy()));
        saveAdapter.setTarget((Notifier)DomFactory.eINSTANCE.createIWebService());
        saveAdapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertTrue((boolean)saveAdapter.annWriter.updateCalled);
        AbstractSerializerAdapterTest.assertFalse((boolean)saveAdapter.annWriter.removeCalled);
    }

    public void testRemoveCalledForNotRequiredAnnotation() {
        this.resource.enableSaving();
        Mock notificationMock = this.mock(Notification.class);
        notificationMock.stubs().method("isTouch").will(this.returnValue(false));
        notificationMock.stubs().method("getEventType").will(this.returnValue(2));
        notificationMock.stubs().method("getNewStringValue").will(this.returnValue("test"));
        notificationMock.stubs().method("getOldValue").will(this.returnValue("oldValue"));
        notificationMock.stubs().method("getFeature").will(this.returnValue(DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getParamValuePairs").will(this.returnValue(new HashSet()));
        TestSavingWsSerializerAdapter saveAdapter = new TestSavingWsSerializerAdapter(this.resource, false, (IAnnotation<? extends IJavaElement>)((IAnnotation)ann.proxy()));
        saveAdapter.setTarget((Notifier)DomFactory.eINSTANCE.createIWebService());
        saveAdapter.notifyChanged((Notification)notificationMock.proxy());
        AbstractSerializerAdapterTest.assertFalse((boolean)saveAdapter.annWriter.updateCalled);
        AbstractSerializerAdapterTest.assertTrue((boolean)saveAdapter.annWriter.removeCalled);
    }

    protected class MyAnnotationWriter
    extends AnnotationWriter {
        boolean removeCalled;
        boolean updateCalled;

        protected MyAnnotationWriter() {
        }

        public void clear() {
            this.removeCalled = false;
            this.updateCalled = false;
        }

        public <T extends IJavaElement> void update(IAnnotation<T> annotation) {
            this.updateCalled = true;
        }

        public <T extends IJavaElement> void remove(IAnnotation<T> annotation) {
            this.removeCalled = true;
        }
    }

    protected class TestSavingWsSerializerAdapter
    extends AbstractSerializerAdapter {
        boolean annRequired;
        MyAnnotationWriter annWriter;
        IAnnotation<? extends IJavaElement> ann;

        public TestSavingWsSerializerAdapter(JaxWsWorkspaceResource resource, boolean annRequired, IAnnotation<? extends IJavaElement> ann) {
            super(resource);
            this.annWriter = new MyAnnotationWriter();
            this.annRequired = annRequired;
            this.ann = ann;
        }

        protected IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
            return this.ann;
        }

        protected boolean isAnnotationRequired() {
            return this.annRequired;
        }

        protected AnnotationWriter getAnnotationWriter() {
            return this.annWriter;
        }
    }

    protected class TestWsSerializerAdapter
    extends AbstractSerializerAdapter {
        public boolean saveCalled;
        private boolean doCheck;
        private IWebService ws;

        public TestWsSerializerAdapter(IWebService ws, boolean doCheck) {
            super(AbstractSerializerAdapterTest.this.resource);
            this.ws = ws;
            this.doCheck = doCheck;
        }

        public void save(Notification msg) {
            this.saveCalled = true;
        }

        protected IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
            return null;
        }

        public boolean checkValue(Notification msg) {
            if (!this.doCheck) {
                return true;
            }
            return super.checkValue(msg);
        }

        public EObject getTarget() {
            return this.ws;
        }

        protected boolean isAnnotationRequired() {
            return true;
        }
    }
}

