/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ErrorDialog
extends MessageDialog {
    protected static final String[] LABELS_OK = new String[]{IDialogConstants.OK_LABEL};
    protected static final String[] LABELS_OK_CANCEL = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
    protected static final String[] LABELS_OK_DETAILS = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
    protected static final String[] LABELS_OK_CANCEL_DETAILS = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
    private Throwable detail;
    private int detailButtonID = -1;
    private Text text;
    private String msg;
    private int defaultButtonIndex = 0;
    private static final int TEXT_LINE_COUNT = 15;

    public ErrorDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, Throwable detail, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.defaultButtonIndex = defaultIndex;
        this.detail = detail;
        this.msg = dialogMessage;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    public int open() {
        this.create();
        Button b = this.getButton(this.defaultButtonIndex);
        b.setFocus();
        b.getShell().setDefaultButton(b);
        return super.open();
    }

    public void setDetailButton(int index) {
        this.detailButtonID = index;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.detailButtonID) {
            this.toggleDetailsArea();
        } else {
            this.setReturnCode(buttonId);
            this.close();
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
            this.getButton(this.detailButtonID).setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownText((Composite)this.getContents());
            this.getButton(this.detailButtonID).setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected void createDropDownText(Composite parent) {
        this.text = new Text(parent, 2816);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            this.detail.printStackTrace(ps);
            if (this.detail instanceof SWTError && ((SWTError)this.detail).throwable != null) {
                ps.println("\n*** Stack trace of contained exception ***");
                ((SWTError)this.detail).throwable.printStackTrace(ps);
            } else if (this.detail instanceof SWTException && ((SWTException)this.detail).throwable != null) {
                ps.println("\n*** Stack trace of contained exception ***");
                ((SWTException)this.detail).throwable.printStackTrace(ps);
            }
            ps.flush();
            baos.flush();
            this.text.setText(baos.toString());
        }
        catch (IOException iOException) {}
        GridData data = new GridData(1808);
        data.heightHint = this.text.getLineHeight() * 15;
        this.text.setLayoutData((Object)data);
    }

    public static boolean openError(Shell parent, String title, String message, Throwable detail, int defaultIndex, boolean showCancel) {
        String[] labels = detail == null ? (showCancel ? LABELS_OK_CANCEL : LABELS_OK) : (showCancel ? LABELS_OK_CANCEL_DETAILS : LABELS_OK_DETAILS);
        ErrorDialog dialog = new ErrorDialog(parent, title, null, message, detail, 1, labels, defaultIndex);
        if (detail != null) {
            dialog.setDetailButton(labels.length - 1);
        }
        return dialog.open() == 0;
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Image image = composite.getDisplay().getSystemImage(1);
        if (image != null) {
            label = new Label(composite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        if (this.msg != null) {
            label = new Label(composite, 64);
            label.setText(this.msg);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        return composite;
    }
}

