/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0, which accompanies this distribution
 * and is available at https://www.eclipse.org/legal/epl-2.0/.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.core.validation;

import org.eclipse.jpt.common.core.internal.utility.ValidationMessageLoader;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/**
 * Localized validation messages used by Dali JPA core.
 * <b>
 * <strong>NB:</strong> These are not loaded like "normal" message
 * (i.e. messages loaded by {@link org.eclipse.osgi.util.NLS});
 * instead they are loaded as {@link ValidationMessage}s.
 * @see ValidationMessageLoader
 */
public class JptJpaCoreValidationMessages {
	//Content is organized based on the categories and entries in each categories are listed alphabetically.
	//If adding a new entry, please be sure to add it to the corresponding category at the right place.
	
	//Project
	public static ValidationMessage NO_JPA_PROJECT;
	public static ValidationMessage JPA_VALIDATION_FAILED;
	public static ValidationMessage PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS;
	public static ValidationMessage PERSISTENCE_NO_PERSISTENCE_UNIT;
	public static ValidationMessage PERSISTENCE_XML_INVALID_CONTENT;
	public static ValidationMessage PERSISTENCE_XML_UNSUPPORTED_CONTENT;
	public static ValidationMessage PROJECT_INACTIVE_CONNECTION;
	public static ValidationMessage PROJECT_INVALID_CONNECTION;
	public static ValidationMessage PROJECT_INVALID_LIBRARY_PROVIDER;
	public static ValidationMessage PROJECT_MULTIPLE_PERSISTENCE_XML;
	public static ValidationMessage PROJECT_NO_CONNECTION;
	public static ValidationMessage PROJECT_NO_PERSISTENCE_XML;
	public static ValidationMessage XML_VERSION_NOT_LATEST;

	//Persistence Unit
	public static ValidationMessage MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA;
	public static ValidationMessage PERSISTENT_TYPE_DUPLICATE_CLASS;
	public static ValidationMessage PERSISTENCE_UNIT_DUPLICATE_CLASS;
	public static ValidationMessage PERSISTENCE_UNIT_DUPLICATE_JAR_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_INVALID_CLASS;
	public static ValidationMessage PERSISTENCE_UNIT_INVALID_MAPPING_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING;
	public static ValidationMessage PERSISTENCE_UNIT_NONEXISTENT_CLASS;
	public static ValidationMessage PERSISTENCE_UNIT_LISTED_CLASS_IS_AN_INTERFACE;
	public static ValidationMessage PERSISTENCE_UNIT_LISTED_CLASS_IS_AN_ENUM;
	public static ValidationMessage PERSISTENCE_UNIT_NONEXISTENT_JAR_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_REDUNDANT_CLASS;
	public static ValidationMessage PERSISTENCE_UNIT_UNSPECIFIED_CLASS;
	public static ValidationMessage PERSISTENCE_UNIT_UNSPECIFIED_JAR_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE;
	public static ValidationMessage PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT;

	//Type
	public static ValidationMessage ENTITY_NAME_DUPLICATED;
	public static ValidationMessage ENTITY_NAME_MISSING;
	public static ValidationMessage ENTITY_NO_PK;
	public static ValidationMessage ENTITY_NON_ROOT_ID_ATTRIBUTE_SPECIFIED;
	public static ValidationMessage ENTITY_NON_ROOT_ID_CLASS_SPECIFIED;
	public static ValidationMessage TYPE_ANNOTATED_BUT_NOT_LISTED_IN_PERSISTENCE_XML;
	public static ValidationMessage TYPE_MANAGED_BUT_NOT_LISTED_IN_PERSISTENCE_XML;
	public static ValidationMessage MANAGED_TYPE_UNRESOLVED_CLASS;
	public static ValidationMessage MANAGED_TYPE_UNSPECIFIED_CLASS;
	public static ValidationMessage ROOT_ENTITY_HAS_PK_JOIN_COLUMN_DEFINED;
	public static ValidationMessage TARGET_NOT_AN_EMBEDDABLE;
	public static ValidationMessage TYPE_MAPPING_CLASS_MISSING_NO_ARG_CONSTRUCTOR;
	public static ValidationMessage TYPE_MAPPING_CLASS_PRIVATE_NO_ARG_CONSTRUCTOR;
	public static ValidationMessage TYPE_MAPPING_FINAL_CLASS;
	public static ValidationMessage TYPE_MAPPING_ID_AND_EMBEDDED_ID_BOTH_USED;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_AND_EMBEDDED_ID_BOTH_USED;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_ATTRIBUTE_DOES_NOT_EXIST;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_DUPLICATE_MATCH;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_NO_MATCH;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NO_MATCH;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NOT_PRIMARY_KEY;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_ATTRIBUTE_TYPE_DOES_NOT_AGREE;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_MISSING_EQUALS_METHOD;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_MISSING_HASHCODE_METHOD;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_MISSING_NO_ARG_CONSTRUCTOR;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_MISSING_PUBLIC_NO_ARG_CONSTRUCTOR;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_NAME_EMPTY;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_NOT_EXIST;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_NOT_IMPLEMENT_SERIALIZABLE;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_NOT_PUBLIC;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_PROPERTY_METHOD_NOT_PUBLIC;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_REDEFINED;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_REQUIRED;
	public static ValidationMessage TYPE_MAPPING_ID_CLASS_WITH_MAPS_ID;
	public static ValidationMessage TYPE_MAPPING_MAPS_ID_ATTRIBUTE_TYPE_DOES_NOT_AGREE;
	public static ValidationMessage TYPE_MAPPING_MEMBER_CLASS;
	public static ValidationMessage TYPE_MAPPING_MULTIPLE_EMBEDDED_ID;
	public static ValidationMessage TYPE_MAPPING_PK_REDEFINED_ID_ATTRIBUTE;
	public static ValidationMessage TYPE_MAPPING_PK_REDEFINED_ID_CLASS;
	
	//Attribute
	public static ValidationMessage MAP_KEY_CLASS_NOT_DEFINED;
	public static ValidationMessage MAP_KEY_CLASS_NOT_EXIST;
	public static ValidationMessage MAP_KEY_CLASS_MUST_BE_ENTITY_EMBEDDABLE_OR_BASIC_TYPE;
	public static ValidationMessage ELEMENT_COLLECTION_TARGET_CLASS_DOES_NOT_EXIST;
	public static ValidationMessage ELEMENT_COLLECTION_CONTAINS_EMBEDDABLE_WITH_ELEMENT_COLLECTION_MAPPING;
	public static ValidationMessage ELEMENT_COLLECTION_CONTAINS_EMBEDDABLE_WITH_PROHIBITED_RELATIONSHIP_MAPPING;
	public static ValidationMessage ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE;
	public static ValidationMessage ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED;
	public static ValidationMessage EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC;
	public static ValidationMessage EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE;
	public static ValidationMessage EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR;
	public static ValidationMessage EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE;
	public static ValidationMessage EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS;
	public static ValidationMessage EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED;
	public static ValidationMessage ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED;
	public static ValidationMessage MAPS_ID_VALUE_INVALID;
	public static ValidationMessage MAPS_ID_VALUE_NOT_RESOLVED;
	public static ValidationMessage MAPS_ID_VALUE_NOT_SPECIFIED;
	public static ValidationMessage MAPPING_INVALID_MAPPED_BY;
	public static ValidationMessage MAPPING_MAPPED_BY_ON_BOTH_SIDES;
	public static ValidationMessage MAPPING_UNRESOLVED_MAPPED_BY;
	public static ValidationMessage ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_ELEMENT_COLLECTION_INVALID_VALUE_TYPE;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_INVALID_TEMPORAL_MAP_KEY_TYPE;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_FINAL_FIELD;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_FINAL_GETTER;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_FINAL_SETTER;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_INHERITED_ATTRIBUTES_NOT_SUPPORTED;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_INVALID_MAPPING;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_INVALID_TEMPORAL_MAPPING_TYPE;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_PUBLIC_FIELD;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME;
	public static ValidationMessage PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME;
	public static ValidationMessage TARGET_ENTITY_IS_NOT_AN_ENTITY;
	public static ValidationMessage TARGET_ENTITY_NOT_DEFINED;
	public static ValidationMessage TARGET_ENTITY_NOT_EXIST;
	public static ValidationMessage ATTRIBUTE_TYPE_IS_NOT_SUPPORTED_COLLECTION_TYPE;

	//***Implied Attribute***
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_CLASS_NOT_DEFINED;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_CLASS_MUST_BE_ENTITY_EMBEDDABLE_OR_BASIC_TYPE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_DOES_NOT_EXIST;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_CONTAINS_EMBEDDABLE_WITH_ELEMENT_COLLECTION_MAPPING;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_CONTAINS_EMBEDDABLE_WITH_PROHIBITED_RELATIONSHIP_MAPPING;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVALID_TEMPORAL_MAP_KEY_TYPE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_INVALID_VALUE_TYPE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVALID_TEMPORAL_MAPPING_TYPE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ATTRIBUTE_TYPE_IS_NOT_SUPPORTED_COLLECTION_TYPE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_TARGET_NOT_AN_EMBEDDABLE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED;
	
	
	//Table
	public static ValidationMessage COLLECTION_TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage COLLECTION_TABLE_UNRESOLVED_NAME;
	public static ValidationMessage COLLECTION_TABLE_UNRESOLVED_SCHEMA;
	public static ValidationMessage JOIN_TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage JOIN_TABLE_UNRESOLVED_NAME;
	public static ValidationMessage JOIN_TABLE_UNRESOLVED_SCHEMA;
	public static ValidationMessage SECONDARY_TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage SECONDARY_TABLE_UNRESOLVED_NAME;
	public static ValidationMessage SECONDARY_TABLE_UNRESOLVED_SCHEMA;
	public static ValidationMessage TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage TABLE_UNRESOLVED_NAME;
	public static ValidationMessage TABLE_UNRESOLVED_SCHEMA;
	//***Implied Attribute***
	public static ValidationMessage VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_SCHEMA;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA;

	//Column
	public static ValidationMessage COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage COLUMN_UNRESOLVED_TABLE;
	public static ValidationMessage INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage INVERSE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage INVERSE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage MAP_KEY_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage MAP_KEY_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage ORDER_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage MAP_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage MAP_KEY_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage MAP_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage MAP_KEY_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage MAP_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;

	// virtual attribute
	public static ValidationMessage VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ORDER_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;	
	public static ValidationMessage VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_MAP_KEY_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_MAP_KEY_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;

	//Overrides
	public static ValidationMessage ASSOCIATION_OVERRIDE_INVALID_NAME;
	public static ValidationMessage ATTRIBUTE_OVERRIDE_INVALID_NAME;
	public static ValidationMessage ATTRIBUTE_OVERRIDE_INVALID_TYPE;
	public static ValidationMessage ATTRIBUTE_OVERRIDE_DERIVED_AND_SPECIFIED;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_INVALID_NAME;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_CATALOG;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_SCHEMA;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVALID_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_INVALID_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_INVALID_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_NAME;
	public static ValidationMessage VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_TYPE;
	public static ValidationMessage VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID;
	public static ValidationMessage VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_INVALID_NAME;

	//Inheritance
	public static ValidationMessage DISCRIMINATOR_COLUMN_UNRESOLVED_NAME;
	public static ValidationMessage ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED;
	public static ValidationMessage ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE;
	public static ValidationMessage ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED;
	public static ValidationMessage ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE;
	public static ValidationMessage ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED;
	public static ValidationMessage ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED;
	public static ValidationMessage ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM;
	public static ValidationMessage ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM;

	//Generator
	public static ValidationMessage GENERATOR_DUPLICATE_NAME;
	public static ValidationMessage GENERATOR_NAME_UNDEFINED;
	public static ValidationMessage UNRESOLVED_GENERATOR_NAME;
	
	//Query
	public static ValidationMessage JPQL_QUERY_VALIDATION;
	public static ValidationMessage QUERY_DUPLICATE_NAME;
	public static ValidationMessage QUERY_NAME_UNDEFINED;
	public static ValidationMessage QUERY_STATEMENT_UNDEFINED;


	// ********** static initialization **********

	private static final ValidationMessageLoader.PreferencesAdapter PREFERENCES_ADAPTER = new ValidationMessageLoader.PluginPreferencesAdapter(JptJpaCorePlugin.instance());

	private static final String MESSAGE_BUNDLE_NAME = "jpt_jpa_core_validation"; //$NON-NLS-1$
	private static final String DESCRIPTION_BUNDLE_NAME = "jpt_jpa_core_validation_description"; //$NON-NLS-1$
	private static final Class<?> BUNDLE_CLASS = JptJpaCoreValidationMessages.class;
	static {
		ValidationMessageLoader.load(BUNDLE_CLASS, MESSAGE_BUNDLE_NAME, DESCRIPTION_BUNDLE_NAME, JpaProject.MARKER_TYPE, PREFERENCES_ADAPTER);

		// WARNINGs
		ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PERSISTENT_ATTRIBUTE_INHERITED_ATTRIBUTES_NOT_SUPPORTED.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PERSISTENT_TYPE_DUPLICATE_CLASS.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PROJECT_INACTIVE_CONNECTION.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PROJECT_INVALID_CONNECTION.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		PROJECT_NO_CONNECTION.setDefaultSeverity(IMessage.NORMAL_SEVERITY);
		TYPE_ANNOTATED_BUT_NOT_LISTED_IN_PERSISTENCE_XML.setDefaultSeverity(IMessage.NORMAL_SEVERITY);

		// INFOs
		XML_VERSION_NOT_LATEST.setDefaultSeverity(IMessage.LOW_SEVERITY);
		PERSISTENCE_UNIT_REDUNDANT_CLASS.setDefaultSeverity(IMessage.LOW_SEVERITY);
	}
}
